/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciidocDocumentationCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AsciidocDocumentationCodegen.class);
    public static final String SPEC_DIR = "specDir";
    public static final String SNIPPET_DIR = "snippetDir";
    public static final String HEADER_ATTRIBUTES_FLAG = "headerAttributes";
    public static final String USE_INTRODUCTION_FLAG = "useIntroduction";
    public static final String SKIP_EXAMPLES_FLAG = "skipExamples";
    public static final String USE_METHOD_AND_PATH_FLAG = "useMethodAndPath";
    public static final String USE_TABLE_TITLES_FLAG = "useTableTitles";
    protected String invokerPackage = "org.openapitools.client";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-client";
    protected String artifactVersion = "1.0.0";
    protected boolean headerAttributes = true;
    protected boolean useIntroduction = false;
    protected boolean skipExamples = false;
    protected boolean useMethodAndPath = false;
    protected boolean useTableTitles = false;
    private IncludeMarkupLambda includeSpecMarkupLambda;
    private IncludeMarkupLambda includeSnippetMarkupLambda;
    private LinkMarkupLambda linkSnippetMarkupLambda;

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    static String sanitize(String name) {
        String sanitized = name == null ? "" : name.trim();
        sanitized = sanitized.replace("//", "/");
        return sanitized.startsWith(File.separator) || sanitized.startsWith("/") ? sanitized.substring(1) : sanitized;
    }

    @Override
    public String getName() {
        return "asciidoc";
    }

    @Override
    public String getHelp() {
        return "Generates asciidoc markup based documentation.";
    }

    public String getSpecDir() {
        return this.additionalProperties.get(SPEC_DIR).toString();
    }

    public String getSnippetDir() {
        return this.additionalProperties.get(SNIPPET_DIR).toString();
    }

    public AsciidocDocumentationCodegen() {
        this.modifyFeatureSet(features -> features.securityFeatures(EnumSet.noneOf(SecurityFeature.class)).documentationFeatures(EnumSet.noneOf(DocumentationFeature.class)).globalFeatures(EnumSet.noneOf(GlobalFeature.class)).schemaSupportFeatures(EnumSet.noneOf(SchemaSupportFeature.class)).clientModificationFeatures(EnumSet.noneOf(ClientModificationFeature.class)));
        this.LOGGER.trace("start asciidoc codegen");
        this.outputFolder = "generated-code" + File.separator + "asciidoc";
        this.templateDir = "asciidoc-documentation";
        this.embeddedTemplateDir = "asciidoc-documentation";
        this.defaultIncludes = new HashSet();
        this.cliOptions.add(new CliOption("appName", "short name of the application"));
        this.cliOptions.add(new CliOption("appDescription", "description of the application"));
        this.cliOptions.add(new CliOption("infoUrl", "a URL where users can get more information about the application"));
        this.cliOptions.add(new CliOption("infoEmail", "an email address to contact for inquiries about the application"));
        this.cliOptions.add(new CliOption("licenseInfo", "a short description of the license"));
        this.cliOptions.add(new CliOption("licenseUrl", "a URL pointing to the full license"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml. This also becomes part of the generated library's filename"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml. This also becomes part of the generated library's filename. If not provided, uses the version from the OpenAPI specification file. If that's also not present, uses the default value of the artifactVersion option."));
        this.cliOptions.add(new CliOption(SNIPPET_DIR, "path with includable markup snippets (e.g. test output generated by restdoc, default: .)").defaultValue("."));
        this.cliOptions.add(new CliOption(SPEC_DIR, "path with includable markup spec files (e.g. handwritten additional docs, default: ..)").defaultValue(".."));
        this.cliOptions.add(CliOption.newBoolean(HEADER_ATTRIBUTES_FLAG, "generation of asciidoc header meta data attributes (set to false to suppress, default: true)", true));
        this.cliOptions.add(CliOption.newBoolean(USE_INTRODUCTION_FLAG, "use introduction section, rather than an initial abstract (default: false)", false));
        this.cliOptions.add(CliOption.newBoolean(SKIP_EXAMPLES_FLAG, "skip examples sections (default: false)", false));
        this.cliOptions.add(CliOption.newBoolean(USE_METHOD_AND_PATH_FLAG, "Use HTTP method and path as operation heading, instead of operation id (default: false)", false));
        this.cliOptions.add(CliOption.newBoolean(USE_TABLE_TITLES_FLAG, "Use titles for tables, rather than wrapping tables instead their own section (default: false)", false));
        this.additionalProperties.put("appName", "OpenAPI Sample description");
        this.additionalProperties.put("appDescription", "A sample OpenAPI documentation");
        this.additionalProperties.put("infoUrl", "https://openapi-generator.tech");
        this.additionalProperties.put("infoEmail", "team@openapitools.org");
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.adoc"));
        this.reservedWords = new HashSet();
        this.languageSpecificPrimitives = new HashSet();
        this.importMapping = new HashMap();
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    public boolean isHeaderAttributes() {
        return this.headerAttributes;
    }

    public void setHeaderAttributes(boolean headerAttributes) {
        this.headerAttributes = headerAttributes;
    }

    public boolean isUseIntroduction() {
        return this.useIntroduction;
    }

    public void setUseIntroduction(boolean useIntroduction) {
        this.useIntroduction = useIntroduction;
    }

    public boolean isSkipExamples() {
        return this.skipExamples;
    }

    public void setSkipExamples(boolean skipExamples) {
        this.skipExamples = skipExamples;
    }

    public boolean isUseMethodAndPath() {
        return this.useMethodAndPath;
    }

    public void setUseMethodAndPath(boolean useMethodAndPath) {
        this.useMethodAndPath = useMethodAndPath;
    }

    public boolean isUseTableTitles() {
        return this.useTableTitles;
    }

    public void setUseTableTitles(boolean useTableTitles) {
        this.useTableTitles = useTableTitles;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        String specDir = String.valueOf(this.additionalProperties.get(SPEC_DIR));
        if (!Files.isDirectory(Paths.get(specDir, new String[0]), new LinkOption[0])) {
            this.LOGGER.warn("base part for include markup lambda not found: {} as {}", (Object)specDir, (Object)Paths.get(specDir, new String[0]).toAbsolutePath());
        }
        this.includeSpecMarkupLambda = new IncludeMarkupLambda(SPEC_DIR, specDir);
        this.additionalProperties.put("specinclude", this.includeSpecMarkupLambda);
        String snippetDir = String.valueOf(this.additionalProperties.get(SNIPPET_DIR));
        if (!Files.isDirectory(Paths.get(snippetDir, new String[0]), new LinkOption[0])) {
            this.LOGGER.warn("base part for include markup lambda not found: {} as {}", (Object)snippetDir, (Object)Paths.get(snippetDir, new String[0]).toAbsolutePath());
        }
        this.includeSnippetMarkupLambda = new IncludeMarkupLambda(SNIPPET_DIR, snippetDir);
        this.additionalProperties.put("snippetinclude", this.includeSnippetMarkupLambda);
        this.linkSnippetMarkupLambda = new LinkMarkupLambda(snippetDir);
        this.additionalProperties.put("snippetlink", this.linkSnippetMarkupLambda);
        this.processBooleanFlag(HEADER_ATTRIBUTES_FLAG, this.headerAttributes);
        this.processBooleanFlag(USE_INTRODUCTION_FLAG, this.useIntroduction);
        this.processBooleanFlag(SKIP_EXAMPLES_FLAG, this.skipExamples);
        this.processBooleanFlag(USE_METHOD_AND_PATH_FLAG, this.useMethodAndPath);
        this.processBooleanFlag(USE_TABLE_TITLES_FLAG, this.useTableTitles);
    }

    private void processBooleanFlag(String flag, boolean value) {
        if (this.additionalProperties.containsKey(flag)) {
            this.setHeaderAttributes(this.convertPropertyToBooleanAndWriteBack(flag));
        } else {
            this.additionalProperties.put(flag, value);
        }
    }

    @Override
    public void processOpenAPI(OpenAPI openAPI) {
        if (this.includeSpecMarkupLambda != null) {
            this.LOGGER.debug("specs: : " + this.includeSpecMarkupLambda.resetCounter());
        }
        if (this.includeSnippetMarkupLambda != null) {
            this.LOGGER.debug("snippets: : " + this.includeSnippetMarkupLambda.resetCounter());
        }
        super.processOpenAPI(openAPI);
    }

    public class LinkMarkupLambda
    implements Mustache.Lambda {
        private long linkedCount = 0L;
        private long notFoundLinkCount = 0L;
        private String basePath;

        public LinkMarkupLambda(String basePath) {
            this.basePath = basePath;
        }

        public String resetCounter() {
            String msg = "linked:" + this.linkedCount + " notFound: " + this.notFoundLinkCount + " from " + this.basePath;
            this.linkedCount = 0L;
            this.notFoundLinkCount = 0L;
            return msg;
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            String content = frag.execute();
            String[] tokens = content.split(",", 2);
            String linkName = tokens.length > 0 ? tokens[0] : "";
            String relativeFileName = AsciidocDocumentationCodegen.sanitize(tokens.length > 1 ? tokens[1] : linkName);
            Path filePathToLinkTo = Paths.get(this.basePath, relativeFileName).toAbsolutePath();
            if (Files.isRegularFile(filePathToLinkTo, new LinkOption[0])) {
                AsciidocDocumentationCodegen.this.LOGGER.debug("linking {}. file into markup from: {}", (Object)(++this.linkedCount), (Object)filePathToLinkTo);
                out.write("\n" + linkName + " link:" + relativeFileName + "[]\n");
            } else {
                AsciidocDocumentationCodegen.this.LOGGER.debug("{}. file not found, skip link for: {}", (Object)(++this.notFoundLinkCount), (Object)filePathToLinkTo);
                out.write("\n// file not found, no " + linkName + " link :" + relativeFileName + "[]\n");
            }
        }
    }

    public class IncludeMarkupLambda
    implements Mustache.Lambda {
        private long includeCount = 0L;
        private long notFoundCount = 0L;
        private String attributePathReference;
        private String basePath;

        public IncludeMarkupLambda(String attributePathReference, String basePath) {
            this.attributePathReference = attributePathReference;
            this.basePath = basePath;
        }

        public String resetCounter() {
            String msg = "included: " + this.includeCount + " notFound: " + this.notFoundCount + " from " + this.basePath;
            this.includeCount = 0L;
            this.notFoundCount = 0L;
            return msg;
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            String relativeFileName = AsciidocDocumentationCodegen.sanitize(frag.execute());
            Path filePathToInclude = Paths.get(this.basePath, relativeFileName).toAbsolutePath();
            String includeStatement = "include::{" + this.attributePathReference + "}" + this.escapeCurlyBrackets(relativeFileName) + "[opts=optional]";
            if (Files.isRegularFile(filePathToInclude, new LinkOption[0])) {
                AsciidocDocumentationCodegen.this.LOGGER.debug("including {}. file into markup from: {}", (Object)(++this.includeCount), (Object)filePathToInclude);
                out.write("\n" + includeStatement + "\n");
            } else {
                AsciidocDocumentationCodegen.this.LOGGER.debug("{}. file not found, skip include for: {}", (Object)(++this.notFoundCount), (Object)filePathToInclude);
                out.write("\n// markup not found, no " + includeStatement + "\n");
            }
        }

        private String escapeCurlyBrackets(String relativeFileName) {
            return relativeFileName.replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}");
        }
    }
}

