/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenComposedSchemas;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.VendorExtension;
import org.openapitools.codegen.languages.JavaClientCodegen;
import org.openapitools.codegen.languages.features.DocumentationProviderFeatures;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaCodegen
extends DefaultCodegen
implements CodegenConfig,
DocumentationProviderFeatures {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractJavaCodegen.class);
    private static final String ARTIFACT_VERSION_DEFAULT_VALUE = "1.0.0";
    public static final String DEFAULT_LIBRARY = "<default>";
    public static final String DATE_LIBRARY = "dateLibrary";
    public static final String SUPPORT_ASYNC = "supportAsync";
    public static final String WITH_XML = "withXml";
    public static final String DISABLE_HTML_ESCAPING = "disableHtmlEscaping";
    public static final String BOOLEAN_GETTER_PREFIX = "booleanGetterPrefix";
    public static final String IGNORE_ANYOF_IN_ENUM = "ignoreAnyOfInEnum";
    public static final String ADDITIONAL_MODEL_TYPE_ANNOTATIONS = "additionalModelTypeAnnotations";
    public static final String ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS = "additionalOneOfTypeAnnotations";
    public static final String ADDITIONAL_ENUM_TYPE_ANNOTATIONS = "additionalEnumTypeAnnotations";
    public static final String DISCRIMINATOR_CASE_SENSITIVE = "discriminatorCaseSensitive";
    public static final String OPENAPI_NULLABLE = "openApiNullable";
    public static final String JACKSON = "jackson";
    public static final String TEST_OUTPUT = "testOutput";
    public static final String IMPLICIT_HEADERS = "implicitHeaders";
    public static final String IMPLICIT_HEADERS_REGEX = "implicitHeadersRegex";
    public static final String JAVAX_PACKAGE = "javaxPackage";
    public static final String USE_JAKARTA_EE = "useJakartaEe";
    public static final String CONTAINER_DEFAULT_TO_NULL = "containerDefaultToNull";
    public static final String CAMEL_CASE_DOLLAR_SIGN = "camelCaseDollarSign";
    public static final String USE_ONE_OF_INTERFACES = "useOneOfInterfaces";
    public static final String LOMBOK = "lombok";
    public static final String DEFAULT_TEST_FOLDER = "${project.build.directory}/generated-test-sources/openapi";
    public static final String GENERATE_CONSTRUCTOR_WITH_ALL_ARGS = "generateConstructorWithAllArgs";
    public static final String GENERATE_BUILDERS = "generateBuilders";
    protected String dateLibrary = "java8";
    protected boolean supportAsync = false;
    protected boolean withXml = false;
    protected String invokerPackage = "org.openapitools";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-java";
    protected String artifactVersion = null;
    protected String artifactUrl = "https://github.com/openapitools/openapi-generator";
    protected String artifactDescription = "OpenAPI Java";
    protected String developerName = "OpenAPI-Generator Contributors";
    protected String developerEmail = "team@openapitools.org";
    protected String developerOrganization = "OpenAPITools.org";
    protected String developerOrganizationUrl = "http://openapitools.org";
    protected String scmConnection = "scm:git:git@github.com:openapitools/openapi-generator.git";
    protected String scmDeveloperConnection = "scm:git:git@github.com:openapitools/openapi-generator.git";
    protected String scmUrl = "https://github.com/openapitools/openapi-generator";
    protected String licenseName = "Unlicense";
    protected String licenseUrl = "http://unlicense.org";
    protected String projectFolder = "src/main";
    protected String projectTestFolder = "src/test";
    protected String sourceFolder = this.projectFolder + "/java";
    protected String testFolder = this.projectTestFolder + "/java";
    protected boolean discriminatorCaseSensitive = true;
    protected Boolean serializableModel = false;
    protected boolean serializeBigDecimalAsString = false;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean disableHtmlEscaping = false;
    protected String booleanGetterPrefix = "get";
    protected boolean ignoreAnyOfInEnum = false;
    protected String parentGroupId = "";
    protected String parentArtifactId = "";
    protected String parentVersion = "";
    protected boolean parentOverridden = false;
    protected List<String> additionalModelTypeAnnotations = new LinkedList<String>();
    protected Map<String, Boolean> lombokAnnotations = null;
    protected List<String> additionalOneOfTypeAnnotations = new LinkedList<String>();
    protected List<String> additionalEnumTypeAnnotations = new LinkedList<String>();
    protected boolean openApiNullable = true;
    protected String outputTestFolder = "";
    protected DocumentationProviderFeatures.DocumentationProvider documentationProvider;
    protected DocumentationProviderFeatures.AnnotationLibrary annotationLibrary;
    protected boolean implicitHeaders = false;
    protected String implicitHeadersRegex = null;
    protected boolean camelCaseDollarSign = false;
    protected boolean useJakartaEe = false;
    protected boolean containerDefaultToNull = false;
    protected boolean generateConstructorWithAllArgs = false;
    protected boolean jackson = false;
    protected boolean generateBuilders;
    protected boolean useBeanValidation = false;
    private Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();

    public AbstractJavaCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.supportsInheritance = true;
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTestTemplateFiles.put("api_test.mustache", ".java");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = false;
        this.setReservedWordsLowerCase(Arrays.asList("object", "list", "file", "localVarPath", "localVarQueryParams", "localVarCollectionQueryParams", "localVarHeaderParams", "localVarCookieParams", "localVarFormParams", "localVarPostBody", "localVarAccepts", "localVarAccept", "localVarContentTypes", "localVarContentType", "localVarAuthNames", "localReturnType", "ApiClient", "ApiException", "ApiResponse", "Configuration", "StringUtil", "_", "abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null", "offsetdatetime", "localdate", "localtime"));
        this.languageSpecificPrimitives = Sets.newHashSet((Object[])new String[]{"String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object", "byte[]"});
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("set", "LinkedHashSet");
        this.instantiationTypes.put("map", "HashMap");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("AnyType", "Object");
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("List", "java.util.*");
        this.importMapping.put("Set", "java.util.*");
        this.importMapping.put("LinkedHashSet", "java.util.LinkedHashSet");
        this.importMapping.put("DateTime", "org.joda.time.*");
        this.importMapping.put("LocalDateTime", "org.joda.time.*");
        this.importMapping.put("LocalDate", "org.joda.time.*");
        this.importMapping.put("LocalTime", "org.joda.time.*");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code").defaultValue(this.getInvokerPackage()));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml").defaultValue(this.getGroupId()));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml. This also becomes part of the generated library's filename").defaultValue(this.getArtifactId()));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml. This also becomes part of the generated library's filename. If not provided, uses the version from the OpenAPI specification file. If that's also not present, uses the default value of the artifactVersion option.").defaultValue(ARTIFACT_VERSION_DEFAULT_VALUE));
        this.cliOptions.add(new CliOption("artifactUrl", "artifact URL in generated pom.xml").defaultValue(this.getArtifactUrl()));
        this.cliOptions.add(new CliOption("artifactDescription", "artifact description in generated pom.xml").defaultValue(this.getArtifactDescription()));
        this.cliOptions.add(new CliOption("scmConnection", "SCM connection in generated pom.xml").defaultValue(this.getScmConnection()));
        this.cliOptions.add(new CliOption("scmDeveloperConnection", "SCM developer connection in generated pom.xml").defaultValue(this.getScmDeveloperConnection()));
        this.cliOptions.add(new CliOption("scmUrl", "SCM URL in generated pom.xml").defaultValue(this.getScmUrl()));
        this.cliOptions.add(new CliOption("developerName", "developer name in generated pom.xml").defaultValue(this.getDeveloperName()));
        this.cliOptions.add(new CliOption("developerEmail", "developer email in generated pom.xml").defaultValue(this.getDeveloperEmail()));
        this.cliOptions.add(new CliOption("developerOrganization", "developer organization in generated pom.xml").defaultValue(this.getDeveloperOrganization()));
        this.cliOptions.add(new CliOption("developerOrganizationUrl", "developer organization URL in generated pom.xml").defaultValue(this.getDeveloperOrganizationUrl()));
        this.cliOptions.add(new CliOption("licenseName", "The name of the license").defaultValue(this.getLicenseName()));
        this.cliOptions.add(new CliOption("licenseUrl", "The URL of the license").defaultValue(this.getLicenseUrl()));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code").defaultValue(this.getSourceFolder()));
        this.cliOptions.add(CliOption.newBoolean("serializableModel", "boolean - toggle \"implements Serializable\" for generated models", this.getSerializableModel()));
        this.cliOptions.add(CliOption.newBoolean("bigDecimalAsString", "Treat BigDecimal values as Strings to avoid precision loss.", this.serializeBigDecimalAsString));
        this.cliOptions.add(CliOption.newBoolean(DISCRIMINATOR_CASE_SENSITIVE, "Whether the discriminator value lookup should be case-sensitive or not. This option only works for Java API client", this.discriminatorCaseSensitive));
        this.cliOptions.add(CliOption.newBoolean("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.", this.isHideGenerationTimestamp()));
        this.cliOptions.add(CliOption.newBoolean(WITH_XML, "whether to include support for application/xml content type and include XML annotations in the model (works with libraries that provide support for JSON and XML)"));
        this.cliOptions.add(CliOption.newBoolean(USE_ONE_OF_INTERFACES, "whether to use a java interface to describe a set of oneOf options, where each option is a class that implements the interface"));
        CliOption dateLibrary = new CliOption(DATE_LIBRARY, "Option. Date library to use").defaultValue(this.getDateLibrary());
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put("java8", "Java 8 native JSR310 (preferred for jdk 1.8+)");
        dateOptions.put("java8-localdatetime", "Java 8 using LocalDateTime (for legacy app only)");
        dateOptions.put("joda", "Joda (for legacy app only)");
        dateOptions.put("legacy", "Legacy java.util.Date");
        dateLibrary.setEnum(dateOptions);
        this.cliOptions.add(dateLibrary);
        this.cliOptions.add(CliOption.newBoolean(DISABLE_HTML_ESCAPING, "Disable HTML escaping of JSON strings when using gson (needed to avoid problems with byte[] fields)", this.disableHtmlEscaping));
        this.cliOptions.add(CliOption.newString(BOOLEAN_GETTER_PREFIX, "Set booleanGetterPrefix").defaultValue(this.getBooleanGetterPrefix()));
        this.cliOptions.add(CliOption.newBoolean(IGNORE_ANYOF_IN_ENUM, "Ignore anyOf keyword in enum", this.ignoreAnyOfInEnum));
        this.cliOptions.add(CliOption.newString(ADDITIONAL_ENUM_TYPE_ANNOTATIONS, "Additional annotations for enum type(class level annotations)"));
        this.cliOptions.add(CliOption.newString(ADDITIONAL_MODEL_TYPE_ANNOTATIONS, "Additional annotations for model type(class level annotations). List separated by semicolon(;) or new line (Linux or Windows)"));
        this.cliOptions.add(CliOption.newString(ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS, "Additional annotations for oneOf interfaces(class level annotations). List separated by semicolon(;) or new line (Linux or Windows)"));
        this.cliOptions.add(CliOption.newBoolean(OPENAPI_NULLABLE, "Enable OpenAPI Jackson Nullable library", this.openApiNullable));
        this.cliOptions.add(CliOption.newBoolean(IMPLICIT_HEADERS, "Skip header parameters in the generated API methods using @ApiImplicitParams annotation.", this.implicitHeaders));
        this.cliOptions.add(CliOption.newString(IMPLICIT_HEADERS_REGEX, "Skip header parameters that matches given regex in the generated API methods using @ApiImplicitParams annotation. Note: this parameter is ignored when implicitHeaders=true"));
        this.cliOptions.add(CliOption.newBoolean(CAMEL_CASE_DOLLAR_SIGN, "Fix camelCase when starting with $ sign. when true : $Value when false : $value"));
        this.cliOptions.add(CliOption.newBoolean(USE_JAKARTA_EE, "whether to use Jakarta EE namespace instead of javax"));
        this.cliOptions.add(CliOption.newBoolean(CONTAINER_DEFAULT_TO_NULL, "Set containers (array, set, map) default to null"));
        this.cliOptions.add(CliOption.newBoolean(GENERATE_CONSTRUCTOR_WITH_ALL_ARGS, "whether to generate a constructor for all arguments").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean(GENERATE_BUILDERS, "Whether to generate builders for models").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newString("parentGroupId", "parent groupId in generated pom N.B. parentGroupId, parentArtifactId and parentVersion must all be specified for any of them to take effect"));
        this.cliOptions.add(CliOption.newString("parentArtifactId", "parent artifactId in generated pom N.B. parentGroupId, parentArtifactId and parentVersion must all be specified for any of them to take effect"));
        this.cliOptions.add(CliOption.newString("parentVersion", "parent version in generated pom N.B. parentGroupId, parentArtifactId and parentVersion must all be specified for any of them to take effect"));
        CliOption snapShotVersion = CliOption.newString("snapshotVersion", "Uses a SNAPSHOT version.");
        HashMap<String, String> snapShotVersionOptions = new HashMap<String, String>();
        snapShotVersionOptions.put("true", "Use a SnapShot Version");
        snapShotVersionOptions.put("false", "Use a Release Version");
        snapShotVersion.setEnum(snapShotVersionOptions);
        this.cliOptions.add(snapShotVersion);
        this.cliOptions.add(CliOption.newString(TEST_OUTPUT, "Set output folder for models and APIs tests").defaultValue(DEFAULT_TEST_FOLDER));
        if (null != this.defaultDocumentationProvider()) {
            CliOption documentationProviderCliOption = new CliOption("documentationProvider", "Select the OpenAPI documentation provider.").defaultValue(this.defaultDocumentationProvider().toCliOptValue());
            this.supportedDocumentationProvider().forEach(dp -> documentationProviderCliOption.addEnum(dp.toCliOptValue(), dp.getDescription()));
            this.cliOptions.add(documentationProviderCliOption);
            CliOption annotationLibraryCliOption = new CliOption("annotationLibrary", "Select the complementary documentation annotation library.").defaultValue(this.defaultDocumentationProvider().getPreferredAnnotationLibrary().toCliOptValue());
            this.supportedAnnotationLibraries().forEach(al -> annotationLibraryCliOption.addEnum(al.toCliOptValue(), al.getDescription()));
            this.cliOptions.add(annotationLibraryCliOption);
        }
    }

    @Override
    public void processOpts() {
        this.useCodegenAsMustacheParentContext();
        super.processOpts();
        if (null != this.defaultDocumentationProvider()) {
            this.documentationProvider = DocumentationProviderFeatures.DocumentationProvider.ofCliOption(this.additionalProperties.getOrDefault("documentationProvider", this.defaultDocumentationProvider().toCliOptValue()));
            if (!this.supportedDocumentationProvider().contains((Object)this.documentationProvider)) {
                String msg = String.format(Locale.ROOT, "The [%s] Documentation Provider is not supported by this generator", this.documentationProvider.toCliOptValue());
                throw new IllegalArgumentException(msg);
            }
            this.annotationLibrary = DocumentationProviderFeatures.AnnotationLibrary.ofCliOption(this.additionalProperties.getOrDefault("annotationLibrary", this.documentationProvider.getPreferredAnnotationLibrary().toCliOptValue()));
            if (!this.supportedAnnotationLibraries().contains((Object)this.annotationLibrary)) {
                String msg = String.format(Locale.ROOT, "The Annotation Library [%s] is not supported by this generator", this.annotationLibrary.toCliOptValue());
                throw new IllegalArgumentException(msg);
            }
            if (!this.documentationProvider.supportedAnnotationLibraries().contains((Object)this.annotationLibrary)) {
                String msg = String.format(Locale.ROOT, "The [%s] documentation provider does not support [%s] as complementary annotation library", this.documentationProvider.toCliOptValue(), this.annotationLibrary.toCliOptValue());
                throw new IllegalArgumentException(msg);
            }
            this.additionalProperties.put("documentationProvider", this.documentationProvider.toCliOptValue());
            this.additionalProperties.put(this.documentationProvider.getPropertyName(), true);
            this.additionalProperties.put("annotationLibrary", this.annotationLibrary.toCliOptValue());
            this.additionalProperties.put(this.annotationLibrary.getPropertyName(), true);
        } else {
            this.additionalProperties.put("documentationProvider", DocumentationProviderFeatures.DocumentationProvider.NONE);
            this.additionalProperties.put("annotationLibrary", DocumentationProviderFeatures.AnnotationLibrary.NONE);
        }
        this.convertPropertyToBooleanAndWriteBack(GENERATE_CONSTRUCTOR_WITH_ALL_ARGS, this::setGenerateConstructorWithAllArgs);
        this.convertPropertyToBooleanAndWriteBack(GENERATE_BUILDERS, this::setGenerateBuilders);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("JAVA_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable JAVA_POST_PROCESS_FILE not defined so the Java code may not be properly formatted. To define it, try 'export JAVA_POST_PROCESS_FILE=\"/usr/local/bin/clang-format -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        this.convertPropertyToBooleanAndWriteBack("useBeanValidation", this::setUseBeanValidation);
        this.convertPropertyToBooleanAndWriteBack(DISABLE_HTML_ESCAPING, this::setDisableHtmlEscaping);
        this.convertPropertyToStringAndWriteBack(BOOLEAN_GETTER_PREFIX, this::setBooleanGetterPrefix);
        this.convertPropertyToBooleanAndWriteBack(IGNORE_ANYOF_IN_ENUM, this::setIgnoreAnyOfInEnum);
        this.convertPropertyToTypeAndWriteBack(ADDITIONAL_MODEL_TYPE_ANNOTATIONS, annotations -> Arrays.asList(annotations.trim().split("\\s*(;|\\r?\\n)\\s*")), this::setAdditionalModelTypeAnnotations);
        this.convertPropertyToTypeAndWriteBack(ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS, annotations -> Arrays.asList(annotations.trim().split("\\s*(;|\\r?\\n)\\s*")), this::setAdditionalOneOfTypeAnnotations);
        this.convertPropertyToTypeAndWriteBack(ADDITIONAL_ENUM_TYPE_ANNOTATIONS, annotations -> Arrays.asList(annotations.split(";")), this::setAdditionalEnumTypeAnnotations);
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        } else if (this.additionalProperties.containsKey("apiPackage")) {
            String derivedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("apiPackage"));
            this.setInvokerPackage(derivedInvokerPackage);
            this.LOGGER.info("Invoker Package Name, originally not set, is now derived from api package name: {}", (Object)derivedInvokerPackage);
        } else if (this.additionalProperties.containsKey("modelPackage")) {
            String derivedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("modelPackage"));
            this.setInvokerPackage(derivedInvokerPackage);
            this.LOGGER.info("Invoker Package Name, originally not set, is now derived from model package name: {}", (Object)derivedInvokerPackage);
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("artifactUrl")) {
            this.setArtifactUrl((String)this.additionalProperties.get("artifactUrl"));
        } else {
            this.additionalProperties.put("artifactUrl", this.artifactUrl);
        }
        if (this.additionalProperties.containsKey("artifactDescription")) {
            this.setArtifactDescription((String)this.additionalProperties.get("artifactDescription"));
        } else {
            this.additionalProperties.put("artifactDescription", this.artifactDescription);
        }
        if (this.additionalProperties.containsKey("scmConnection")) {
            this.setScmConnection((String)this.additionalProperties.get("scmConnection"));
        } else {
            this.additionalProperties.put("scmConnection", this.scmConnection);
        }
        if (this.additionalProperties.containsKey("scmDeveloperConnection")) {
            this.setScmDeveloperConnection((String)this.additionalProperties.get("scmDeveloperConnection"));
        } else {
            this.additionalProperties.put("scmDeveloperConnection", this.scmDeveloperConnection);
        }
        if (this.additionalProperties.containsKey("scmUrl")) {
            this.setScmUrl((String)this.additionalProperties.get("scmUrl"));
        } else {
            this.additionalProperties.put("scmUrl", this.scmUrl);
        }
        if (this.additionalProperties.containsKey("developerName")) {
            this.setDeveloperName((String)this.additionalProperties.get("developerName"));
        } else {
            this.additionalProperties.put("developerName", this.developerName);
        }
        if (this.additionalProperties.containsKey("developerEmail")) {
            this.setDeveloperEmail((String)this.additionalProperties.get("developerEmail"));
        } else {
            this.additionalProperties.put("developerEmail", this.developerEmail);
        }
        if (this.additionalProperties.containsKey("developerOrganization")) {
            this.setDeveloperOrganization((String)this.additionalProperties.get("developerOrganization"));
        } else {
            this.additionalProperties.put("developerOrganization", this.developerOrganization);
        }
        if (this.additionalProperties.containsKey("developerOrganizationUrl")) {
            this.setDeveloperOrganizationUrl((String)this.additionalProperties.get("developerOrganizationUrl"));
        } else {
            this.additionalProperties.put("developerOrganizationUrl", this.developerOrganizationUrl);
        }
        this.convertPropertyToStringAndWriteBack("modelPackage", this::setModelPackage);
        this.convertPropertyToStringAndWriteBack("apiPackage", this::setApiPackage);
        this.convertPropertyToStringAndWriteBack("groupId", this::setGroupId);
        this.convertPropertyToStringAndWriteBack("artifactId", this::setArtifactId);
        this.convertPropertyToStringAndWriteBack("artifactUrl", this::setArtifactUrl);
        this.convertPropertyToStringAndWriteBack("artifactDescription", this::setArtifactDescription);
        this.convertPropertyToStringAndWriteBack("scmConnection", this::setScmConnection);
        this.convertPropertyToStringAndWriteBack("scmDeveloperConnection", this::setScmDeveloperConnection);
        this.convertPropertyToStringAndWriteBack("scmUrl", this::setScmUrl);
        this.convertPropertyToStringAndWriteBack("developerName", this::setDeveloperName);
        this.convertPropertyToStringAndWriteBack("developerEmail", this::setDeveloperEmail);
        this.convertPropertyToStringAndWriteBack("developerOrganization", this::setDeveloperOrganization);
        this.convertPropertyToStringAndWriteBack("developerOrganizationUrl", this::setDeveloperOrganizationUrl);
        this.convertPropertyToStringAndWriteBack("licenseName", this::setLicenseName);
        this.convertPropertyToStringAndWriteBack("licenseUrl", this::setLicenseUrl);
        this.convertPropertyToStringAndWriteBack("sourceFolder", this::setSourceFolder);
        this.convertPropertyToBooleanAndWriteBack("serializableModel", this::setSerializableModel);
        this.convertPropertyToStringAndWriteBack("library", this::setLibrary);
        this.convertPropertyToBooleanAndWriteBack("bigDecimalAsString", this::setSerializeBigDecimalAsString);
        this.convertPropertyToBooleanAndWriteBack(DISCRIMINATOR_CASE_SENSITIVE, this::setDiscriminatorCaseSensitive);
        this.convertPropertyToBooleanAndWriteBack(WITH_XML, this::setWithXml);
        this.convertPropertyToBooleanAndWriteBack(OPENAPI_NULLABLE, this::setOpenApiNullable);
        this.convertPropertyToStringAndWriteBack("parentGroupId", this::setParentGroupId);
        this.convertPropertyToStringAndWriteBack("parentArtifactId", this::setParentArtifactId);
        this.convertPropertyToStringAndWriteBack("parentVersion", this::setParentVersion);
        this.convertPropertyToBooleanAndWriteBack(IMPLICIT_HEADERS, this::setImplicitHeaders);
        this.convertPropertyToStringAndWriteBack(IMPLICIT_HEADERS_REGEX, this::setImplicitHeadersRegex);
        this.convertPropertyToBooleanAndWriteBack(CAMEL_CASE_DOLLAR_SIGN, this::setCamelCaseDollarSign);
        this.convertPropertyToBooleanAndWriteBack(USE_ONE_OF_INTERFACES, this::setUseOneOfInterfaces);
        if (!(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.parentGroupId) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.parentArtifactId) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.parentVersion))) {
            this.additionalProperties.put("parentOverridden", true);
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.importMapping.put("List", "java.util.List");
        this.importMapping.put("Set", "java.util.Set");
        this.sanitizeConfig();
        this.importMapping.put("ToStringSerializer", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer");
        this.importMapping.put("JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonSerialize");
        this.importMapping.put("JsonDeserialize", "com.fasterxml.jackson.databind.annotation.JsonDeserialize");
        this.importMapping.put("ApiModelProperty", "io.swagger.annotations.ApiModelProperty");
        this.importMapping.put("ApiModel", "io.swagger.annotations.ApiModel");
        this.importMapping.put("Schema", "io.swagger.v3.oas.annotations.media.Schema");
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonSubTypes", "com.fasterxml.jackson.annotation.JsonSubTypes");
        this.importMapping.put("JsonTypeInfo", "com.fasterxml.jackson.annotation.JsonTypeInfo");
        this.importMapping.put("JsonTypeName", "com.fasterxml.jackson.annotation.JsonTypeName");
        this.importMapping.put("JsonCreator", "com.fasterxml.jackson.annotation.JsonCreator");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("JsonIgnore", "com.fasterxml.jackson.annotation.JsonIgnore");
        this.importMapping.put("JsonIgnoreProperties", "com.fasterxml.jackson.annotation.JsonIgnoreProperties");
        this.importMapping.put("JsonInclude", "com.fasterxml.jackson.annotation.JsonInclude");
        if (this.openApiNullable) {
            this.importMapping.put("JsonNullable", "org.openapitools.jackson.nullable.JsonNullable");
        }
        this.importMapping.put("SerializedName", "com.google.gson.annotations.SerializedName");
        this.importMapping.put("TypeAdapter", "com.google.gson.TypeAdapter");
        this.importMapping.put("JsonAdapter", "com.google.gson.annotations.JsonAdapter");
        this.importMapping.put("JsonReader", "com.google.gson.stream.JsonReader");
        this.importMapping.put("JsonWriter", "com.google.gson.stream.JsonWriter");
        this.importMapping.put("IOException", "java.io.IOException");
        this.importMapping.put("Arrays", "java.util.Arrays");
        this.importMapping.put("Objects", "java.util.Objects");
        this.importMapping.put("StringUtil", this.invokerPackage + ".StringUtil");
        this.importMapping.put("com.fasterxml.jackson.annotation.JsonProperty", "com.fasterxml.jackson.annotation.JsonCreator");
        this.convertPropertyToBooleanAndWriteBack(SUPPORT_ASYNC, this::setSupportAsync);
        this.convertPropertyToStringAndWriteBack(DATE_LIBRARY, this::setDateLibrary);
        if ("joda".equals(this.dateLibrary)) {
            this.additionalProperties.put("joda", "true");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "DateTime");
            this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
            this.importMapping.put("DateTime", "org.joda.time.DateTime");
        } else if (this.dateLibrary.startsWith("java8")) {
            this.additionalProperties.put("java8", "true");
            this.additionalProperties.put("jsr310", "true");
            this.typeMapping.put("date", "LocalDate");
            this.importMapping.put("LocalDate", "java.time.LocalDate");
            this.importMapping.put("LocalTime", "java.time.LocalTime");
            if ("java8-localdatetime".equals(this.dateLibrary)) {
                this.typeMapping.put("DateTime", "LocalDateTime");
                this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
            } else {
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
            }
        } else if (this.dateLibrary.equals("legacy")) {
            this.additionalProperties.put("legacyDates", "true");
        }
        this.convertPropertyToStringAndWriteBack(TEST_OUTPUT, this::setOutputTestFolder);
        this.convertPropertyToBooleanAndWriteBack(USE_JAKARTA_EE, this::setUseJakartaEe);
        if (this.useJakartaEe) {
            this.applyJakartaPackage();
        } else {
            this.applyJavaxPackage();
        }
        this.convertPropertyToBooleanAndWriteBack(CONTAINER_DEFAULT_TO_NULL, this::setContainerDefaultToNull);
        this.additionalProperties.put("sanitizeGeneric", (fragment, writer) -> {
            String content = fragment.execute();
            for (String s : List.of("<", ">", ",", " ")) {
                content = content.replace(s, "");
            }
            writer.write(content);
        });
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Object models;
        objs = super.postProcessAllModels(objs);
        objs = super.updateAllModels(objs);
        Map<String, CodegenModel> allModels = this.getAllModels(objs);
        if (!this.additionalModelTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                models = objs.get(modelName);
                models.put(ADDITIONAL_MODEL_TYPE_ANNOTATIONS, this.additionalModelTypeAnnotations);
            }
        }
        if (!this.additionalOneOfTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                models = objs.get(modelName);
                models.put(ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS, this.additionalOneOfTypeAnnotations);
            }
        }
        if (!this.additionalEnumTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                models = objs.get(modelName);
                models.put(ADDITIONAL_ENUM_TYPE_ANNOTATIONS, this.additionalEnumTypeAnnotations);
            }
        }
        for (ModelsMap modelsAttrs : objs.values()) {
            for (ModelMap mo : modelsAttrs.getModels()) {
                CodegenModel codegenModel = mo.getModel();
                HashSet<String> inheritedImports = new HashSet<String>();
                HashMap<String, CodegenProperty> propertyHash = new HashMap<String, CodegenProperty>(codegenModel.vars.size());
                for (CodegenProperty property : codegenModel.vars) {
                    propertyHash.put(property.name, property);
                }
                List<CodegenModel> parentModelList = this.getParentModelList(codegenModel);
                for (CodegenModel parentCodegenModel : parentModelList) {
                    for (CodegenProperty property : parentCodegenModel.vars) {
                        if (propertyHash.containsKey(property.name)) continue;
                        propertyHash.put(property.name, property);
                        CodegenProperty parentVar = property.clone();
                        parentVar.isInherited = true;
                        this.LOGGER.info("adding parent variable {} to {}", (Object)property.name, (Object)codegenModel.name);
                        codegenModel.parentVars.add(parentVar);
                        Set imports = parentVar.getImports(true, this.importBaseType, this.generatorMetadata.getFeatureSet()).stream().filter(Objects::nonNull).collect(Collectors.toSet());
                        for (String imp : imports) {
                            if (codegenModel.getImports().contains(imp)) continue;
                            inheritedImports.add(imp);
                            codegenModel.getImports().add(imp);
                        }
                    }
                }
                if (codegenModel.getParentModel() != null) {
                    codegenModel.parentRequiredVars = new ArrayList<CodegenProperty>(codegenModel.getParentModel().requiredVars);
                }
                for (String imp : inheritedImports) {
                    String qimp = this.importMapping().get(imp);
                    if (qimp == null) continue;
                    HashMap<String, String> toAdd = new HashMap<String, String>();
                    toAdd.put("import", qimp);
                    modelsAttrs.getImports().add(toAdd);
                }
            }
        }
        if (this.isGenerateConstructorWithAllArgs()) {
            for (CodegenModel cm : allModels.values()) {
                if (!this.isConstructorWithAllArgsAllowed(cm)) continue;
                cm.vendorExtensions.put("x-java-all-args-constructor", true);
                ArrayList<CodegenProperty> constructorArgs = new ArrayList<CodegenProperty>();
                cm.vendorExtensions.put("x-java-all-args-constructor-vars", constructorArgs);
                if (cm.vars.size() + cm.parentVars.size() != cm.allVars.size()) {
                    OnceLogger.once(this.LOGGER).warn("Unexpected allVars for {} expecting:{} vars. actual:{} vars", new Object[]{cm.name, cm.vars.size() + cm.parentVars.size(), cm.allVars.size()});
                }
                constructorArgs.addAll(cm.vars);
                constructorArgs.addAll(cm.parentVars);
            }
        }
        return objs;
    }

    private List<CodegenModel> getParentModelList(CodegenModel codegenModel) {
        CodegenModel parentCodegenModel = codegenModel.parentModel;
        ArrayList<CodegenModel> parentModelList = new ArrayList<CodegenModel>();
        while (parentCodegenModel != null) {
            parentModelList.add(parentCodegenModel);
            parentCodegenModel = parentCodegenModel.parentModel;
        }
        return parentModelList;
    }

    protected boolean isConstructorWithAllArgsAllowed(CodegenModel codegenModel) {
        return this.generateConstructorWithAllArgs && (!codegenModel.vars.isEmpty() || codegenModel.parentVars.isEmpty());
    }

    private void sanitizeConfig() {
        this.setApiPackage(AbstractJavaCodegen.sanitizePackageName(this.apiPackage));
        this.additionalProperties.remove("apiPackage");
        this.setModelPackage(AbstractJavaCodegen.sanitizePackageName(this.modelPackage));
        this.additionalProperties.remove("modelPackage");
        this.setInvokerPackage(AbstractJavaCodegen.sanitizePackageName(this.invokerPackage));
        this.additionalProperties.remove("invokerPackage");
    }

    protected void applyJavaxPackage() {
        this.writePropertyBack(JAVAX_PACKAGE, "javax");
    }

    protected void applyJakartaPackage() {
        this.writePropertyBack(JAVAX_PACKAGE, "jakarta");
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputTestFolder + File.separator + this.testFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return (this.outputTestFolder + File.separator + this.testFolder + File.separator + this.modelPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + File.separator + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + File.separator + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        if (((String)(name = this.sanitizeName((String)name, "\\W-[\\$]"))).toLowerCase(Locale.ROOT).matches("^_*class$")) {
            return "propertyClass";
        }
        if ("_".equals(name)) {
            name = "_u";
        }
        if (((String)name).matches("^\\d.*")) {
            name = "_" + (String)name;
        }
        if (((String)name).matches("^[A-Z0-9_]*$")) {
            return name;
        }
        if (this.startsWithTwoUppercaseLetters((String)name)) {
            name = ((String)name).substring(0, 2).toLowerCase(Locale.ROOT) + ((String)name).substring(2);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.containsKey(String.valueOf((char)character)))) {
            ArrayList<String> allowedCharacters = new ArrayList<String>();
            allowedCharacters.add("_");
            allowedCharacters.add("$");
            name = StringUtils.escape((String)name, this.specialCharReplacements, allowedCharacters, "_");
        }
        if (this.isReservedWord((String)(name = this.camelCaseDollarSign ? StringUtils.camelize((String)name, CamelizeOption.LOWERCASE_FIRST_CHAR) : StringUtils.camelize((String)name, CamelizeOption.LOWERCASE_FIRST_LETTER))) || ((String)name).matches("^\\d.*")) {
            name = this.escapeReservedWord((String)name);
        }
        return name;
    }

    private boolean startsWithTwoUppercaseLetters(String name) {
        boolean startsWithTwoUppercaseLetters = false;
        if (name.length() > 1) {
            startsWithTwoUppercaseLetters = name.substring(0, 2).equals(name.substring(0, 2).toUpperCase(Locale.ROOT));
        }
        return startsWithTwoUppercaseLetters;
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        if ("callback".equals(name)) {
            return "paramCallback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName;
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        if (this.schemaMapping.containsKey(name)) {
            return (String)this.schemaMapping.get(name);
        }
        String origName = name;
        if (this.schemaKeyToModelNameCache.containsKey(origName)) {
            return this.schemaKeyToModelNameCache.get(origName);
        }
        String sanitizedName = this.sanitizeName(name);
        Object nameWithPrefixSuffix = sanitizedName;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + (String)nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = (String)nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = StringUtils.camelize((String)nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            this.schemaKeyToModelNameCache.put(origName, modelName);
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            this.schemaKeyToModelNameCache.put(origName, modelName);
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        this.schemaKeyToModelNameCache.put(origName, camelizedName);
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = this.unaliasSchema(p);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema(target)) {
            Schema<?> items = ModelUtils.getSchemaItems(schema);
            return this.getSchemaType(target) + "<" + this.getBeanValidation(items) + this.getTypeDeclaration(items) + ">";
        }
        if (ModelUtils.isMapSchema(target)) {
            Schema inner = ModelUtils.getAdditionalProperties(target);
            if (inner == null) {
                this.LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return this.getSchemaType(target) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(target);
    }

    private String getBeanValidation(Schema<?> items) {
        if (!this.isUseBeanValidation()) {
            return "";
        }
        if (ModelUtils.isTypeObjectSchema(items)) {
            return "";
        }
        if (items.get$ref() != null) {
            Map shemas = this.openAPI.getComponents().getSchemas();
            String ref = ModelUtils.getSimpleRef(items.get$ref());
            if (ref != null) {
                Schema schema = (Schema)shemas.get(ref);
                if (schema == null || ModelUtils.isObjectSchema(schema)) {
                    return "@Valid ";
                }
                items = schema;
            }
        }
        if (ModelUtils.isStringSchema(items)) {
            return this.getStringBeanValidation(items);
        }
        if (ModelUtils.isNumberSchema(items)) {
            return this.getNumberBeanValidation(items);
        }
        if (ModelUtils.isLongSchema(items)) {
            return this.getLongBeanValidation(items);
        }
        if (ModelUtils.isIntegerSchema(items)) {
            return this.getIntegerBeanValidation(items);
        }
        return "";
    }

    private String getIntegerBeanValidation(Schema<?> items) {
        if (items.getMinimum() != null && items.getMaximum() != null) {
            return String.format(Locale.ROOT, "@Min(%s) @Max(%s)", items.getMinimum(), items.getMaximum());
        }
        if (items.getMinimum() != null) {
            return String.format(Locale.ROOT, "@Min(%s)", items.getMinimum());
        }
        if (items.getMaximum() != null) {
            return String.format(Locale.ROOT, "@Max(%s)", items.getMaximum());
        }
        return "";
    }

    private String getLongBeanValidation(Schema<?> items) {
        if (items.getMinimum() != null && items.getMaximum() != null) {
            return String.format(Locale.ROOT, "@Min(%sL) @Max(%sL)", items.getMinimum(), items.getMaximum());
        }
        if (items.getMinimum() != null) {
            return String.format(Locale.ROOT, "@Min(%sL)", items.getMinimum());
        }
        if (items.getMaximum() != null) {
            return String.format(Locale.ROOT, "@Max(%sL)", items.getMaximum());
        }
        return "";
    }

    private String getNumberBeanValidation(Schema<?> items) {
        if (items.getMinimum() != null && items.getMaximum() != null) {
            return String.format(Locale.ROOT, "@DecimalMin(value = \"%s\", inclusive = %s) @DecimalMax(value = \"%s\", inclusive = %s)", items.getMinimum(), Optional.ofNullable(items.getExclusiveMinimum()).orElse(Boolean.FALSE) == false, items.getMaximum(), Optional.ofNullable(items.getExclusiveMaximum()).orElse(Boolean.FALSE) == false);
        }
        if (items.getMinimum() != null) {
            return String.format(Locale.ROOT, "@DecimalMin( value = \"%s\", inclusive = %s)", items.getMinimum(), Optional.ofNullable(items.getExclusiveMinimum()).orElse(Boolean.FALSE) == false);
        }
        if (items.getMaximum() != null) {
            return String.format(Locale.ROOT, "@DecimalMax( value = \"%s\", inclusive = %s)", items.getMaximum(), Optional.ofNullable(items.getExclusiveMaximum()).orElse(Boolean.FALSE) == false);
        }
        return "";
    }

    private String getStringBeanValidation(Schema<?> items) {
        String validations = "";
        if (ModelUtils.shouldIgnoreBeanValidation(items)) {
            return validations;
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)items.getPattern())) {
            String pattern = this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)items.getPattern()).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
            validations = String.format(Locale.ROOT, "@Pattern(regexp = \"%s\")", pattern);
        }
        if (ModelUtils.isEmailSchema(items)) {
            return String.join((CharSequence)"", "@Email ");
        }
        if (ModelUtils.isDecimalSchema(items)) {
            return String.join((CharSequence)"", validations, this.getNumberBeanValidation(items));
        }
        if (items.getMinLength() != null && items.getMaxLength() != null) {
            return String.join((CharSequence)"", validations, String.format(Locale.ROOT, "@Size(min = %d, max = %d)", items.getMinLength(), items.getMaxLength()));
        }
        if (items.getMinLength() != null) {
            return String.join((CharSequence)"", validations, String.format(Locale.ROOT, "@Size(min = %d)", items.getMinLength()));
        }
        if (items.getMaxLength() != null) {
            return String.join((CharSequence)"", validations, String.format(Locale.ROOT, "@Size(max = %d)", items.getMaxLength()));
        }
        return validations;
    }

    public String toArrayDefaultValue(CodegenProperty cp, Schema schema) {
        if (schema.getDefault() != null) {
            if (cp.isArray) {
                ArrayList final_values;
                Object _default;
                List<Object> _values = new ArrayList();
                if (schema.getDefault() instanceof ArrayNode) {
                    _default = (ArrayNode)schema.getDefault();
                    if (_default.isEmpty()) {
                        return this.getDefaultCollectionType(schema);
                    }
                    final_values = _values;
                    _default.elements().forEachRemaining(element -> final_values.add(element.asText()));
                } else if (schema.getDefault() instanceof Collection) {
                    _default = (Collection)schema.getDefault();
                    final_values = _values;
                    _default.forEach(element -> final_values.add(String.valueOf(element)));
                } else {
                    _values = Collections.singletonList(String.valueOf(schema.getDefault()));
                }
                String defaultValue = "";
                if (cp.items.getIsEnumOrRef()) {
                    ArrayList<CallSite> defaultValues = new ArrayList<CallSite>();
                    for (String string : _values) {
                        defaultValues.add((CallSite)((Object)(cp.items.datatypeWithEnum + "." + this.toEnumVarName(string, cp.items.dataType))));
                    }
                    defaultValue = org.apache.commons.lang3.StringUtils.join(defaultValues, (String)", ");
                } else if (_values.size() > 0) {
                    defaultValue = cp.items.isString ? String.format(Locale.ROOT, "\"%s\"", org.apache.commons.lang3.StringUtils.join(_values, (String)"\", \"")) : (cp.items.isNumeric ? _values.stream().map(v -> {
                        if ("BigInteger".equals(cp.items.dataType)) {
                            return "new BigInteger(\"" + v + "\")";
                        }
                        if ("BigDecimal".equals(cp.items.dataType)) {
                            return "new BigDecimal(\"" + v + "\")";
                        }
                        if (cp.items.isFloat) {
                            return v + "f";
                        }
                        return v;
                    }).collect(Collectors.joining(", ")) : org.apache.commons.lang3.StringUtils.join(_values, (String)", "));
                } else {
                    return this.getDefaultCollectionType(schema);
                }
                return this.getDefaultCollectionType(schema, defaultValue);
            }
            if (cp.isMap) {
                return null;
            }
            throw new RuntimeException("Error. Codegen Property must be array/set/map: " + cp);
        }
        return null;
    }

    @Override
    public String toDefaultValue(CodegenProperty cp, Schema schema) {
        if (ModelUtils.isArraySchema(schema = ModelUtils.getReferencedSchema(this.openAPI, (Schema)schema))) {
            if (schema.getDefault() == null) {
                if (cp.isNullable || this.containerDefaultToNull) {
                    return null;
                }
                return this.getDefaultCollectionType(schema);
            }
            return this.toArrayDefaultValue(cp, schema);
        }
        if (ModelUtils.isMapSchema(schema) && !ModelUtils.isComposedSchema(schema)) {
            if (schema.getProperties() != null && schema.getProperties().size() > 0) {
                if (schema.getDefault() != null) {
                    return super.toDefaultValue(schema);
                }
                return null;
            }
            if (cp.isNullable || this.containerDefaultToNull) {
                return null;
            }
            if (ModelUtils.getAdditionalProperties(schema) == null) {
                return null;
            }
            return String.format(Locale.ROOT, "new %s<>()", this.instantiationTypes().getOrDefault("map", "HashMap"));
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            if (schema.getDefault() != null) {
                if ("int64".equals(schema.getFormat())) {
                    return schema.getDefault().toString() + "l";
                }
                return schema.getDefault().toString();
            }
            return null;
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (schema.getDefault() != null) {
                if ("float".equals(schema.getFormat())) {
                    return schema.getDefault().toString() + "f";
                }
                if ("double".equals(schema.getFormat())) {
                    return schema.getDefault().toString() + "d";
                }
                return "new BigDecimal(\"" + schema.getDefault().toString() + "\")";
            }
            return null;
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            if (schema.getDefault() != null) {
                return schema.getDefault().toString();
            }
            return null;
        }
        if (ModelUtils.isURISchema(schema)) {
            if (schema.getDefault() != null) {
                return "URI.create(\"" + this.escapeText(String.valueOf(schema.getDefault())) + "\")";
            }
            return null;
        }
        if (ModelUtils.isStringSchema(schema)) {
            if (schema.getDefault() != null) {
                if (schema.getDefault() instanceof Date) {
                    if ("java8".equals(this.getDateLibrary())) {
                        Date date = (Date)schema.getDefault();
                        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                        return String.format(Locale.ROOT, "LocalDate.parse(\"%s\")", localDate.toString());
                    }
                    return null;
                }
                if (schema.getDefault() instanceof OffsetDateTime) {
                    if ("java8".equals(this.getDateLibrary())) {
                        return String.format(Locale.ROOT, "OffsetDateTime.parse(\"%s\", %s)", ((OffsetDateTime)schema.getDefault()).atZoneSameInstant(ZoneId.systemDefault()), "java.time.format.DateTimeFormatter.ISO_ZONED_DATE_TIME.withZone(java.time.ZoneId.systemDefault())");
                    }
                    return null;
                }
                if (schema.getDefault() instanceof UUID) {
                    return "UUID.fromString(\"" + String.valueOf(schema.getDefault()) + "\")";
                }
                String _default = String.valueOf(schema.getDefault());
                if (schema.getEnum() == null) {
                    return "\"" + this.escapeText(_default) + "\"";
                }
                return _default;
            }
            return null;
        }
        if (ModelUtils.isObjectSchema(schema)) {
            if (schema.getDefault() != null) {
                return super.toDefaultValue(schema);
            }
            return null;
        }
        if (ModelUtils.isComposedSchema(schema)) {
            if (schema.getDefault() != null) {
                return super.toDefaultValue(schema);
            }
            return null;
        }
        return super.toDefaultValue(schema);
    }

    private String getDefaultCollectionType(Schema schema) {
        return this.getDefaultCollectionType(schema, null);
    }

    private String getDefaultCollectionType(Schema schema, String defaultValues) {
        String arrayFormat = "new %s<>(Arrays.asList(%s))";
        if (defaultValues == null || defaultValues.isEmpty()) {
            defaultValues = "";
            arrayFormat = "new %s<>()";
        }
        if (ModelUtils.isSet(schema)) {
            return String.format(Locale.ROOT, arrayFormat, this.instantiationTypes().getOrDefault("set", "LinkedHashSet"), defaultValues);
        }
        return String.format(Locale.ROOT, arrayFormat, this.instantiationTypes().getOrDefault("array", "ArrayList"), defaultValues);
    }

    @Override
    public String toDefaultParameterValue(Schema<?> schema) {
        Object defaultValue;
        Object object = defaultValue = schema.get$ref() != null ? ModelUtils.getReferencedSchema(this.openAPI, schema).getDefault() : schema.getDefault();
        if (defaultValue == null) {
            return null;
        }
        if (defaultValue instanceof Date) {
            Date date = (Date)schema.getDefault();
            LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return localDate.toString();
        }
        if (ModelUtils.isArraySchema(schema)) {
            if (defaultValue instanceof ArrayNode) {
                ArrayNode array = (ArrayNode)defaultValue;
                return StreamSupport.stream(array.spliterator(), false).map(JsonNode::toString).map(item -> org.apache.commons.lang3.StringUtils.removeStart((String)item, (String)"\"")).map(item -> org.apache.commons.lang3.StringUtils.removeEnd((String)item, (String)"\"")).collect(Collectors.joining(","));
            }
            if (defaultValue instanceof ArrayList) {
                ArrayList array = (ArrayList)defaultValue;
                return array.stream().map(Object::toString).collect(Collectors.joining(","));
            }
        }
        return defaultValue.toString().replace("\"", "\\\"");
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        Schema schema;
        Example example;
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
        }
        if (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && (example = (Example)parameter.getExamples().values().iterator().next()).getValue() != null) {
            codegenParameter.example = example.getValue().toString();
        }
        if ((schema = parameter.getSchema()) != null && schema.getExample() != null) {
            codegenParameter.example = schema.getExample().toString();
        }
        this.setParameterExampleValue(codegenParameter);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        Example example;
        MediaType mediaType;
        boolean isModel = codegenParameter.isModel || codegenParameter.isContainer && codegenParameter.getItems().isModel;
        Content content = requestBody.getContent();
        if (content.size() > 1) {
            this.LOGGER.debug("Multiple MediaTypes found, using only the first one");
        }
        if ((mediaType = (MediaType)content.values().iterator().next()).getExample() != null) {
            if (isModel) {
                this.LOGGER.warn("Ignoring complex example on request body");
            } else {
                codegenParameter.example = mediaType.getExample().toString();
                return;
            }
        }
        if (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && (example = (Example)mediaType.getExamples().values().iterator().next()).getValue() != null) {
            if (isModel) {
                this.LOGGER.warn("Ignoring complex example on request body");
            } else {
                codegenParameter.example = example.getValue().toString();
                return;
            }
        }
        this.setParameterExampleValue(codegenParameter);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        Object example;
        boolean hasAllowableValues;
        boolean bl = hasAllowableValues = p.allowableValues != null && !p.allowableValues.isEmpty();
        if (hasAllowableValues) {
            List values = (List)p.allowableValues.get("values");
            example = String.valueOf(values.get(0));
        } else {
            example = p.defaultValue == null ? p.example : p.defaultValue;
        }
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText((String)example) + "\"";
        } else if ("Integer".equals(type) || "Short".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Long".equals(type)) {
            if (example == null) {
                example = "56";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"L", (CharSequence[])new CharSequence[0]);
        } else if ("Float".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"F", (CharSequence[])new CharSequence[0]);
        } else if ("Double".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if ("Boolean".equals(type)) {
            if (example == null) {
                example = "true";
            }
        } else if ("File".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "new File(\"" + this.escapeText((String)example) + "\")";
        } else if ("Date".equals(type)) {
            example = "new Date()";
        } else if ("LocalDate".equals(type)) {
            example = example == null ? "LocalDate.now()" : "LocalDate.parse(\"" + (String)example + "\")";
        } else if ("OffsetDateTime".equals(type)) {
            example = example == null ? "OffsetDateTime.now()" : "OffsetDateTime.parse(\"" + (String)example + "\")";
        } else if ("BigDecimal".equals(type)) {
            example = example == null ? "new BigDecimal(78)" : "new BigDecimal(\"" + (String)example + "\")";
        } else if ("UUID".equals(type)) {
            example = example == null ? "UUID.randomUUID()" : "UUID.fromString(\"" + (String)example + "\")";
        } else if (hasAllowableValues) {
            example = type + ".fromValue(\"" + (String)example + "\")";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + type + "()";
        }
        if (example == null) {
            example = "null";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            if (p.items != null && p.items.defaultValue != null) {
                Object innerExample = "String".equals(p.items.dataType) ? "\"" + p.items.defaultValue + "\"" : p.items.defaultValue;
                example = "Arrays.asList(" + (String)innerExample + ")";
            } else {
                example = "Arrays.asList()";
            }
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = "new HashMap()";
        }
        p.example = example;
    }

    @Override
    public String toExampleValue(Schema p) {
        if (p.getExample() != null) {
            return this.escapeText(p.getExample().toString());
        }
        return null;
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (null == openAPIType) {
            this.LOGGER.error("No Type defined for Schema {}", (Object)p);
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), CamelizeOption.LOWERCASE_FIRST_LETTER))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize("call_" + operationId), (Object)true);
            operationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
        }
        return operationId;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        if (codegenModel.description != null && !DocumentationProviderFeatures.AnnotationLibrary.SWAGGER2.equals((Object)this.getAnnotationLibrary())) {
            codegenModel.imports.add("ApiModel");
        }
        if (codegenModel.discriminator != null && this.jackson) {
            codegenModel.imports.add("JsonSubTypes");
            codegenModel.imports.add("JsonTypeInfo");
            codegenModel.imports.add("JsonIgnoreProperties");
        }
        if (codegenModel.getIsClassnameSanitized() && this.jackson && !codegenModel.isEnum) {
            codegenModel.imports.add("JsonTypeName");
        }
        if (allDefinitions != null && codegenModel.parentSchema != null && codegenModel.hasEnums) {
            Schema parentModel = allDefinitions.get(codegenModel.parentSchema);
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            codegenModel = AbstractJavaCodegen.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        if ("BigDecimal".equals(codegenModel.dataType)) {
            codegenModel.imports.add("BigDecimal");
        }
        this.addAdditionalImports(codegenModel, codegenModel.getComposedSchemas());
        return codegenModel;
    }

    private void addAdditionalImports(CodegenModel model, CodegenComposedSchemas composedSchemas) {
        if (composedSchemas == null) {
            return;
        }
        List<List> propertyLists = Arrays.asList(composedSchemas.getAnyOf(), composedSchemas.getOneOf(), composedSchemas.getAllOf());
        for (List propertyList : propertyLists) {
            if (propertyList == null) continue;
            for (CodegenProperty cp : propertyList) {
                String dataType = cp.baseType;
                if (null == this.importMapping().get(dataType)) continue;
                model.imports.add(dataType);
            }
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (this.serializeBigDecimalAsString && this.jackson && ("decimal".equals(property.baseType) || "bigdecimal".equalsIgnoreCase(property.baseType))) {
            property.vendorExtensions.put("x-extra-annotation", "@JsonSerialize(using = ToStringSerializer.class)");
            model.imports.add("ToStringSerializer");
            model.imports.add("JsonSerialize");
        }
        if (this instanceof JavaClientCodegen && ("jersey2".equals(this.library) || "jersey3".equals(this.library) || "native".equals(this.library) || "okhttp-gson".equals(this.library))) {
            model.imports.add("Arrays");
        }
        if ("array".equals(property.containerType)) {
            model.imports.add("ArrayList");
            model.imports.add("Arrays");
        } else if ("set".equals(property.containerType)) {
            model.imports.add("LinkedHashSet");
            if (!(this.openApiNullable && property.isNullable || !this.jackson)) {
                model.imports.add("JsonDeserialize");
                property.vendorExtensions.put("x-setter-extra-annotation", "@JsonDeserialize(as = LinkedHashSet.class)");
            }
        } else if ("map".equals(property.containerType)) {
            model.imports.add("HashMap");
        }
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum) && !DocumentationProviderFeatures.AnnotationLibrary.SWAGGER2.equals((Object)this.getAnnotationLibrary())) {
            model.imports.add("ApiModelProperty");
            model.imports.add("ApiModel");
        }
        if (this.openApiNullable && Boolean.FALSE.equals(property.required) && Boolean.TRUE.equals(property.isNullable)) {
            model.imports.add("JsonNullable");
            model.getVendorExtensions().put("x-jackson-optional-nullable-helpers", true);
        }
        if (property.isReadOnly) {
            model.getVendorExtensions().put("x-has-readonly-properties", true);
        }
        if (property.dataType != null && property.dataType.equals(property.name) && property.dataType.toUpperCase(Locale.ROOT).equals(property.name)) {
            property.name = property.name.toLowerCase(Locale.ROOT);
        }
    }

    @Override
    public void postProcessResponseWithProperty(CodegenResponse response, CodegenProperty property) {
        if (response == null || property == null || response.dataType == null || property.dataType == null) {
            return;
        }
        if (property.dataType.contains("@")) {
            property.dataType = property.dataType.replaceAll("(?:(?i)@[a-z0-9]*+([(].*[)]|\\s*))*+", "");
        }
        if (response.dataType.contains("@")) {
            response.dataType = response.dataType.replaceAll("(?:(?i)@[a-z0-9]*+([(].*[)]|\\s*))*+", "");
        }
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        List<Map<String, String>> recursiveImports = objs.getImports();
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = recursiveImports.listIterator();
        while (listIterator.hasNext()) {
            String _import = listIterator.next().get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            HashMap<String, String> newImportMap = new HashMap<String, String>();
            newImportMap.put("import", (String)this.importMapping.get(_import));
            listIterator.add(newImportMap);
        }
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (!this.serializableModel.booleanValue()) continue;
            cm.getVendorExtensions().putIfAbsent("x-implements", new ArrayList());
            ((ArrayList)cm.getVendorExtensions().get("x-implements")).add("Serializable");
        }
        HashMap<String, Boolean> lombokOptions = new HashMap<String, Boolean>();
        String regexp = "@lombok.(\\w+\\.)*(?<ClassName>\\w+)(\\(.*?\\))?";
        Pattern pattern = Pattern.compile(regexp);
        for (String annotation : this.additionalModelTypeAnnotations) {
            Matcher matcher = pattern.matcher(annotation);
            if (!matcher.find()) continue;
            String className = matcher.group("ClassName");
            lombokOptions.put(className, true);
        }
        if (!lombokOptions.isEmpty()) {
            this.lombokAnnotations = lombokOptions;
            this.writePropertyBack(LOMBOK, lombokOptions);
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        List<Map<String, String>> imports = objs.getImports();
        Pattern pattern = Pattern.compile("java\\.util\\.(List|ArrayList|Map|HashMap)");
        Iterator<Map<String, String>> itr = imports.iterator();
        while (itr.hasNext()) {
            String itrImport = itr.next().get("import");
            if (!pattern.matcher(itrImport).matches()) continue;
            itr.remove();
        }
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            if (op.getHasFormParams()) {
                this.additionalProperties.put("hasFormParamsInSpec", true);
            }
            ConcurrentSkipListSet<String> operationImports = new ConcurrentSkipListSet<String>();
            for (CodegenParameter p : op.allParams) {
                if (!this.importMapping.containsKey(p.dataType)) continue;
                operationImports.add((String)this.importMapping.get(p.dataType));
            }
            op.vendorExtensions.put("x-java-import", operationImports);
            this.handleImplicitHeaders(op);
            this.handleConstantParams(op);
        }
        return objs;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI == null) {
            return;
        }
        if (openAPI.getPaths() != null) {
            for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
                String pathname = (String)openAPIGetPathsEntry.getKey();
                PathItem path = (PathItem)openAPIGetPathsEntry.getValue();
                if (path.readOperations() == null) continue;
                for (Operation operation : path.readOperations()) {
                    this.LOGGER.info("Processing operation {}", (Object)operation.getOperationId());
                    if (this.hasBodyParameter(operation) || this.hasFormParameter(operation)) {
                        String defaultContentType = this.hasFormParameter(operation) ? "application/x-www-form-urlencoded" : "application/json";
                        ArrayList<String> consumes = new ArrayList<String>(AbstractJavaCodegen.getConsumesInfo(openAPI, operation));
                        String contentType = consumes.isEmpty() ? defaultContentType : (String)consumes.get(0);
                        operation.addExtension("x-content-type", (Object)contentType);
                    }
                    String[] accepts = AbstractJavaCodegen.getAccepts(openAPI, operation);
                    operation.addExtension("x-accepts", (Object)accepts);
                }
            }
        }
        if (this.artifactVersion == null) {
            if (this.additionalProperties.containsKey("artifactVersion") && this.additionalProperties.get("artifactVersion") != null) {
                this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
            } else if (openAPI.getInfo() != null && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)openAPI.getInfo().getVersion())) {
                this.setArtifactVersion(openAPI.getInfo().getVersion());
            } else {
                this.setArtifactVersion(ARTIFACT_VERSION_DEFAULT_VALUE);
            }
        }
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        if (this.additionalProperties.containsKey("snapshotVersion") && this.convertPropertyToBooleanAndWriteBack("snapshotVersion")) {
            this.setArtifactVersion(this.buildSnapshotVersion(this.getArtifactVersion()));
        }
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        if (this.ignoreAnyOfInEnum) {
            Stream.concat(Stream.of(openAPI.getComponents().getSchemas()), openAPI.getComponents().getSchemas().values().stream().filter(schema -> schema.getProperties() != null).map(Schema::getProperties)).forEach(schemas -> schemas.replaceAll((name, s) -> Stream.of(s).filter(schema -> ModelUtils.isComposedSchema((Schema)schema)).filter(schema -> Objects.nonNull(((Schema)schema).getAnyOf())).flatMap(schema -> ((Schema)schema).getAnyOf().stream()).filter(schema -> Objects.nonNull(((Schema)schema).getEnum())).findFirst().orElse((Schema)s)));
        }
    }

    private static String[] getAccepts(OpenAPI openAPIArg, Operation operation) {
        Set<String> producesInfo = AbstractJavaCodegen.getProducesInfo(openAPIArg, operation);
        if (producesInfo != null && !producesInfo.isEmpty()) {
            return producesInfo.toArray(new String[0]);
        }
        return new String[]{"application/json"};
    }

    @Override
    protected boolean needToImport(String type) {
        return super.needToImport(type) && !type.contains(".");
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(StringUtils.camelize(property.name)) + "Enum";
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (this.enumNameMapping.containsKey(value)) {
            return (String)this.enumNameMapping.get(value);
        }
        if (value.length() == 0) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase(Locale.ROOT);
        }
        if (" ".equals(value)) {
            return "SPACE";
        }
        if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype) || "BigDecimal".equals(datatype)) {
            Object varName = "NUMBER_" + value;
            varName = ((String)varName).replaceAll("-", "MINUS_");
            varName = ((String)varName).replaceAll("\\+", "PLUS_");
            varName = ((String)varName).replaceAll("\\.", "_DOT_");
            return varName;
        }
        Object var = StringUtils.underscore(value.replaceAll("\\W+", "_")).toUpperCase(Locale.ROOT);
        if (((String)var).matches("\\d.*")) {
            var = "_" + (String)var;
        }
        return this.toVarName((String)var);
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Double".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "l";
        }
        if ("Float".equals(datatype)) {
            return value + "f";
        }
        if ("BigDecimal".equals(datatype)) {
            return "new BigDecimal(\"" + value + "\")";
        }
        if ("URI".equals(datatype)) {
            return "URI.create(\"" + this.escapeText(value) + "\")";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        op.path = this.sanitizePath(op.path);
        return op;
    }

    private static CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (!parentCodegenModel.hasEnums) {
            return codegenModel;
        }
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        boolean removedChildEnum = false;
        for (CodegenProperty parentModelCodegenProperty : parentModelCodegenProperties) {
            if (!parentModelCodegenProperty.isEnum) continue;
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenProperty)) continue;
                iterator.remove();
                removedChildEnum = true;
            }
        }
        if (removedChildEnum) {
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    private static String sanitizePackageName(String packageName) {
        packageName = packageName.trim();
        if (Strings.isNullOrEmpty((String)(packageName = packageName.replaceAll("[^a-zA-Z0-9_\\.]", "_")))) {
            return "invalidPackageName";
        }
        return packageName;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("\"", "%22");
    }

    @Override
    public void setOutputDir(String dir) {
        super.setOutputDir(dir);
        if (this.outputTestFolder.isEmpty()) {
            this.setOutputTestFolder(dir);
        }
    }

    public String getOutputTestFolder() {
        if (this.outputTestFolder.isEmpty()) {
            return DEFAULT_TEST_FOLDER;
        }
        return this.outputTestFolder;
    }

    @Override
    public DocumentationProviderFeatures.DocumentationProvider getDocumentationProvider() {
        return this.documentationProvider;
    }

    @Override
    public void setDocumentationProvider(DocumentationProviderFeatures.DocumentationProvider documentationProvider) {
        this.documentationProvider = documentationProvider;
    }

    @Override
    public DocumentationProviderFeatures.AnnotationLibrary getAnnotationLibrary() {
        return this.annotationLibrary;
    }

    @Override
    public void setAnnotationLibrary(DocumentationProviderFeatures.AnnotationLibrary annotationLibrary) {
        this.annotationLibrary = annotationLibrary;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private String deriveInvokerPackageName(String input) {
        String[] parts = input.split(Pattern.quote("."));
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String p : Arrays.copyOf(parts, parts.length - 1)) {
            sb.append(delim).append(p);
            delim = ".";
        }
        return sb.toString();
    }

    private String buildSnapshotVersion(String version) {
        if (version.endsWith("-SNAPSHOT")) {
            return version;
        }
        return version + "-SNAPSHOT";
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public String toBooleanGetter(String name) {
        return this.booleanGetterPrefix + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String sanitizeTag(String tag) {
        if (((String)(tag = StringUtils.camelize(StringUtils.underscore(this.sanitizeName((String)tag))))).matches("^\\d.*")) {
            tag = "Class" + (String)tag;
        }
        return tag;
    }

    @Override
    public String getterAndSetterCapitalize(String name) {
        CamelizeOption camelizeOption = CamelizeOption.UPPERCASE_FIRST_CHAR;
        if (name == null || name.length() == 0) {
            return name;
        }
        if ((name = this.toVarName(name)).length() > 1 && Character.isLowerCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            camelizeOption = CamelizeOption.LOWERCASE_FIRST_LETTER;
        }
        return StringUtils.camelize(name, camelizeOption);
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String javaPostProcessFile = System.getenv("JAVA_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)javaPostProcessFile)) {
            return;
        }
        if ("java".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = javaPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema s;
        if (!this.supportsAdditionalPropertiesWithComposedSchema) {
            super.addAdditionPropertiesToCodeGenModel(codegenModel, schema);
        }
        if ((s = ModelUtils.getAdditionalProperties(schema)) != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(s);
            this.addImport(codegenModel, codegenModel.additionalPropertiesType);
        }
    }

    protected Optional<CodegenProperty> findByName(String name, List<CodegenProperty> properties) {
        if (properties == null || properties.isEmpty()) {
            return Optional.empty();
        }
        return properties.stream().filter(p -> p.name.equals(name)).findFirst();
    }

    protected void handleImplicitHeaders(CodegenOperation operation) {
        if (operation.allParams.isEmpty()) {
            return;
        }
        ArrayList<CodegenParameter> copy = new ArrayList<CodegenParameter>(operation.allParams);
        operation.allParams.clear();
        for (CodegenParameter p : copy) {
            if (p.isHeaderParam && (this.implicitHeaders || this.shouldBeImplicitHeader(p))) {
                operation.implicitHeadersParams.add(p);
                operation.headerParams.removeIf(header -> header.baseName.equals(p.baseName));
                this.LOGGER.info("Update operation [{}]. Remove header [{}] because it's marked to be implicit", (Object)operation.operationId, (Object)p.baseName);
                continue;
            }
            operation.allParams.add(p);
        }
        operation.hasParams = !operation.allParams.isEmpty();
    }

    private boolean shouldBeImplicitHeader(CodegenParameter parameter) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.implicitHeadersRegex) && parameter.baseName.matches(this.implicitHeadersRegex);
    }

    @Override
    public void addImportsToOneOfInterface(List<Map<String, String>> imports) {
        if (this.jackson) {
            for (String i : Arrays.asList("JsonSubTypes", "JsonTypeInfo")) {
                HashMap<String, String> oneImport = new HashMap<String, String>();
                oneImport.put("import", (String)this.importMapping.get(i));
                if (imports.contains(oneImport)) continue;
                imports.add(oneImport);
            }
        }
    }

    @Override
    public List<VendorExtension> getSupportedVendorExtensions() {
        List<VendorExtension> extensions = super.getSupportedVendorExtensions();
        extensions.add(VendorExtension.X_DISCRIMINATOR_VALUE);
        extensions.add(VendorExtension.X_IMPLEMENTS);
        extensions.add(VendorExtension.X_SETTER_EXTRA_ANNOTATION);
        extensions.add(VendorExtension.X_TAGS);
        extensions.add(VendorExtension.X_ACCEPTS);
        extensions.add(VendorExtension.X_CONTENT_TYPE);
        extensions.add(VendorExtension.X_CLASS_EXTRA_ANNOTATION);
        extensions.add(VendorExtension.X_FIELD_EXTRA_ANNOTATION);
        return extensions;
    }

    public boolean isAddNullableImports(CodegenModel cm, boolean addImports, CodegenProperty var) {
        if (this.openApiNullable) {
            boolean isOptionalNullable = Boolean.FALSE.equals(var.required) && Boolean.TRUE.equals(var.isNullable);
            addImports |= isOptionalNullable;
            var.getVendorExtensions().put("x-is-jackson-optional-nullable", isOptionalNullable);
            this.findByName(var.name, cm.readOnlyVars).ifPresent(p -> p.getVendorExtensions().put("x-is-jackson-optional-nullable", isOptionalNullable));
        }
        return addImports;
    }

    public static void addImports(List<Map<String, String>> imports, CodegenModel cm, Map<String, String> imports2Classnames) {
        for (Map.Entry<String, String> entry : imports2Classnames.entrySet()) {
            cm.imports.add(entry.getKey());
            HashMap<String, String> importsItem = new HashMap<String, String>();
            importsItem.put("import", entry.getValue());
            imports.add(importsItem);
        }
    }

    @Override
    public boolean isTypeErasedGenerics() {
        return true;
    }

    public String getDateLibrary() {
        return this.dateLibrary;
    }

    public void setDateLibrary(String dateLibrary) {
        this.dateLibrary = dateLibrary;
    }

    public void setSupportAsync(boolean supportAsync) {
        this.supportAsync = supportAsync;
    }

    public void setWithXml(boolean withXml) {
        this.withXml = withXml;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public String getArtifactUrl() {
        return this.artifactUrl;
    }

    public void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
    }

    public String getArtifactDescription() {
        return this.artifactDescription;
    }

    public void setArtifactDescription(String artifactDescription) {
        this.artifactDescription = artifactDescription;
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public String getDeveloperEmail() {
        return this.developerEmail;
    }

    public void setDeveloperEmail(String developerEmail) {
        this.developerEmail = developerEmail;
    }

    public String getDeveloperOrganization() {
        return this.developerOrganization;
    }

    public void setDeveloperOrganization(String developerOrganization) {
        this.developerOrganization = developerOrganization;
    }

    public String getDeveloperOrganizationUrl() {
        return this.developerOrganizationUrl;
    }

    public void setDeveloperOrganizationUrl(String developerOrganizationUrl) {
        this.developerOrganizationUrl = developerOrganizationUrl;
    }

    public String getScmConnection() {
        return this.scmConnection;
    }

    public void setScmConnection(String scmConnection) {
        this.scmConnection = scmConnection;
    }

    public String getScmDeveloperConnection() {
        return this.scmDeveloperConnection;
    }

    public void setScmDeveloperConnection(String scmDeveloperConnection) {
        this.scmDeveloperConnection = scmDeveloperConnection;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getTestFolder() {
        return this.testFolder;
    }

    public void setTestFolder(String testFolder) {
        this.testFolder = testFolder;
    }

    public void setDiscriminatorCaseSensitive(boolean discriminatorCaseSensitive) {
        this.discriminatorCaseSensitive = discriminatorCaseSensitive;
    }

    public Boolean getSerializableModel() {
        return this.serializableModel;
    }

    public void setSerializableModel(Boolean serializableModel) {
        this.serializableModel = serializableModel;
    }

    public void setSerializeBigDecimalAsString(boolean serializeBigDecimalAsString) {
        this.serializeBigDecimalAsString = serializeBigDecimalAsString;
    }

    public void setDisableHtmlEscaping(boolean disableHtmlEscaping) {
        this.disableHtmlEscaping = disableHtmlEscaping;
    }

    public String getBooleanGetterPrefix() {
        return this.booleanGetterPrefix;
    }

    public void setBooleanGetterPrefix(String booleanGetterPrefix) {
        this.booleanGetterPrefix = booleanGetterPrefix;
    }

    public void setIgnoreAnyOfInEnum(boolean ignoreAnyOfInEnum) {
        this.ignoreAnyOfInEnum = ignoreAnyOfInEnum;
    }

    public void setParentGroupId(String parentGroupId) {
        this.parentGroupId = parentGroupId;
    }

    public void setParentArtifactId(String parentArtifactId) {
        this.parentArtifactId = parentArtifactId;
    }

    public void setParentVersion(String parentVersion) {
        this.parentVersion = parentVersion;
    }

    public void setParentOverridden(boolean parentOverridden) {
        this.parentOverridden = parentOverridden;
    }

    public List<String> getAdditionalModelTypeAnnotations() {
        return this.additionalModelTypeAnnotations;
    }

    public void setAdditionalModelTypeAnnotations(List<String> additionalModelTypeAnnotations) {
        this.additionalModelTypeAnnotations = additionalModelTypeAnnotations;
    }

    public List<String> getAdditionalOneOfTypeAnnotations() {
        return this.additionalOneOfTypeAnnotations;
    }

    public void setAdditionalOneOfTypeAnnotations(List<String> additionalOneOfTypeAnnotations) {
        this.additionalOneOfTypeAnnotations = additionalOneOfTypeAnnotations;
    }

    public void setAdditionalEnumTypeAnnotations(List<String> additionalEnumTypeAnnotations) {
        this.additionalEnumTypeAnnotations = additionalEnumTypeAnnotations;
    }

    public boolean isOpenApiNullable() {
        return this.openApiNullable;
    }

    public void setOpenApiNullable(boolean openApiNullable) {
        this.openApiNullable = openApiNullable;
    }

    public void setOutputTestFolder(String outputTestFolder) {
        this.outputTestFolder = outputTestFolder;
    }

    public void setImplicitHeaders(boolean implicitHeaders) {
        this.implicitHeaders = implicitHeaders;
    }

    public void setImplicitHeadersRegex(String implicitHeadersRegex) {
        this.implicitHeadersRegex = implicitHeadersRegex;
    }

    public void setCamelCaseDollarSign(boolean camelCaseDollarSign) {
        this.camelCaseDollarSign = camelCaseDollarSign;
    }

    public void setUseJakartaEe(boolean useJakartaEe) {
        this.useJakartaEe = useJakartaEe;
    }

    public void setContainerDefaultToNull(boolean containerDefaultToNull) {
        this.containerDefaultToNull = containerDefaultToNull;
    }

    public boolean isGenerateConstructorWithAllArgs() {
        return this.generateConstructorWithAllArgs;
    }

    public void setGenerateConstructorWithAllArgs(boolean generateConstructorWithAllArgs) {
        this.generateConstructorWithAllArgs = generateConstructorWithAllArgs;
    }

    public boolean isJackson() {
        return this.jackson;
    }

    public void setJackson(boolean jackson) {
        this.jackson = jackson;
    }

    public boolean isGenerateBuilders() {
        return this.generateBuilders;
    }

    public void setGenerateBuilders(boolean generateBuilders) {
        this.generateBuilders = generateBuilders;
    }

    public boolean isUseBeanValidation() {
        return this.useBeanValidation;
    }

    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }
}

