/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCSharpCodegen;
import org.openapitools.codegen.languages.AspNetServerCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpFunctionsServerCodegen
extends AbstractCSharpCodegen {
    public static final String NET_CORE_VERSION = "netCoreVersion";
    public static final String AZURE_FUNCTIONS_VERSION = "azureFunctionsVersion";
    public static final String CLASS_MODIFIER = "classModifier";
    public static final String OPERATION_MODIFIER = "operationModifier";
    public static final String OPERATION_IS_ASYNC = "operationIsAsync";
    public static final String OPERATION_RESULT_TASK = "operationResultTask";
    public static final String GENERATE_BODY = "generateBody";
    public static final String BUILD_TARGET = "buildTarget";
    public static final String MODEL_CLASS_MODIFIER = "modelClassModifier";
    public static final String TARGET_FRAMEWORK = "targetFramework";
    public static final String FUNCTIONS_SDK_VERSION = "functionsSDKVersion";
    public static final String COMPATIBILITY_VERSION = "compatibilityVersion";
    public static final String USE_NEWTONSOFT = "useNewtonsoft";
    public static final String NEWTONSOFT_VERSION = "newtonsoftVersion";
    public static final String NET_60_OR_LATER = "net60OrLater";
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    private String userSecretsGuid = UUID.randomUUID().toString();
    protected final Logger LOGGER = LoggerFactory.getLogger(AspNetServerCodegen.class);
    protected int serverPort = 8080;
    protected String serverHost = "0.0.0.0";
    protected CliOption netCoreVersion = new CliOption("netCoreVersion", ".NET Core version: 6.0, 5.0, 3.1, 3.0");
    protected CliOption azureFunctionsVersion = new CliOption("azureFunctionsVersion", "Azure functions version: v4, v3");
    private CliOption classModifier = new CliOption("classModifier", "Class Modifier for function classes: Empty string or abstract.");
    private CliOption operationModifier = new CliOption("operationModifier", "Operation Modifier can be virtual or abstract");
    private CliOption modelClassModifier = new CliOption("modelClassModifier", "Model Class Modifier can be nothing or partial");
    private boolean generateBody = true;
    private CliOption buildTarget = new CliOption("buildTarget", "Target to build an application or library");
    private String projectSdk = "Microsoft.NET.Sdk";
    private boolean operationIsAsync = false;
    private boolean operationResultTask = false;
    private boolean isLibrary = false;
    private boolean useFrameworkReference = false;
    private boolean useNewtonsoft = true;
    private String newtonsoftVersion = "3.0.0";

    public CSharpFunctionsServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).excludeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.PROTOBUF}).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, SecurityFeature.BasicAuth, SecurityFeature.BearerToken)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.MultiServer}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("function.mustache", ".cs");
        this.templateDir = "csharp-functions";
        this.embeddedTemplateDir = "csharp-functions";
        this.reservedWords.addAll(Arrays.asList("var", "async", "await", "dynamic", "yield"));
        this.cliOptions.clear();
        this.setSupportNullable(Boolean.TRUE);
        this.addOption("packageDescription", "Specifies a AssemblyDescription for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageDescription);
        this.addOption("licenseUrl", "The URL of the license", this.licenseUrl);
        this.addOption("licenseName", "The name of the license", this.licenseName);
        this.addOption("packageCopyright", "Specifies an AssemblyCopyright for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageCopyright);
        this.addOption("packageAuthors", "Specifies Authors property in the .NET Core project file.", this.packageAuthors);
        this.addOption("packageTitle", "Specifies an AssemblyTitle for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageTitle);
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.netCoreVersion.addEnum("3.0", ".NET Core 3.0");
        this.netCoreVersion.addEnum("3.1", ".NET Core 3.1");
        this.netCoreVersion.addEnum("5.0", ".NET Core 5.0");
        this.netCoreVersion.addEnum("6.0", ".NET Core 6.0");
        this.netCoreVersion.setDefault("3.1");
        this.netCoreVersion.setOptValue(this.netCoreVersion.getDefault());
        this.cliOptions.add(this.netCoreVersion);
        this.azureFunctionsVersion.addEnum("v4", "Azure Functions v4");
        this.azureFunctionsVersion.addEnum("v3", "Azure Functions v3");
        this.azureFunctionsVersion.setDefault("v4");
        this.azureFunctionsVersion.setOptValue(this.azureFunctionsVersion.getDefault());
        this.cliOptions.add(this.azureFunctionsVersion);
        this.addSwitch("nullableReferenceTypes", "Use nullable annotations in the project. Only supported on C# 8 / ASP.NET Core 3.1 or newer.", this.nullReferenceTypesFlag);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useDateTimeForDate", "Use DateTime to model date properties even if DateOnly supported. (.net 6.0+ only)", this.useDateTimeForDateFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch(USE_NEWTONSOFT, "Uses the Newtonsoft JSON library.", this.useNewtonsoft);
        this.addOption(NEWTONSOFT_VERSION, "Version for Newtonsoft.Json for .NET Core 3.0+", this.newtonsoftVersion);
        this.addOption("enumNameSuffix", "Suffix that will be appended to all enum names.", this.enumNameSuffix);
        this.addOption("enumValueSuffix", "Suffix that will be appended to all enum values.", this.enumValueSuffix);
        this.classModifier.addEnum("", "Keep class default with no modifier");
        this.classModifier.addEnum("abstract", "Make class abstract");
        this.classModifier.setDefault("");
        this.classModifier.setOptValue(this.classModifier.getDefault());
        this.addOption(this.classModifier.getOpt(), this.classModifier.getDescription(), this.classModifier.getOptValue());
        this.operationModifier.addEnum("virtual", "Keep method virtual");
        this.operationModifier.addEnum("abstract", "Make method abstract");
        this.operationModifier.setDefault("virtual");
        this.operationModifier.setOptValue(this.operationModifier.getDefault());
        this.cliOptions.add(this.operationModifier);
        this.buildTarget.addEnum("program", "Generate code for a standalone server");
        this.buildTarget.addEnum("library", "Generate code for a server abstract class library");
        this.buildTarget.setDefault("program");
        this.buildTarget.setOptValue(this.buildTarget.getDefault());
        this.cliOptions.add(this.buildTarget);
        this.addSwitch(GENERATE_BODY, "Generates method body.", this.generateBody);
        this.addSwitch(OPERATION_IS_ASYNC, "Set methods to async or sync (default).", this.operationIsAsync);
        this.addSwitch(OPERATION_RESULT_TASK, "Set methods result to Task<>.", this.operationResultTask);
        this.modelClassModifier.setType("String");
        this.modelClassModifier.addEnum("", "Keep model class default with no modifier");
        this.modelClassModifier.addEnum("partial", "Make model class partial");
        this.modelClassModifier.setDefault("partial");
        this.modelClassModifier.setOptValue(this.modelClassModifier.getDefault());
        this.addOption(this.modelClassModifier.getOpt(), this.modelClassModifier.getDescription(), this.modelClassModifier.getOptValue());
    }

    @Override
    @Deprecated
    protected Set<String> getNullableTypes() {
        return new HashSet<String>(Arrays.asList("decimal", "bool", "int", "uint", "long", "ulong", "float", "double", "DateTime", "DateTimeOffset", "Guid"));
    }

    @Override
    protected Set<String> getValueTypes() {
        return new HashSet<String>(Arrays.asList("decimal", "bool", "int", "uint", "long", "ulong", "float", "double"));
    }

    @Override
    protected boolean useNet60OrLater() {
        return this.additionalProperties.containsKey(NET_60_OR_LATER);
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        if (!parameter.dataType.endsWith("?") && !parameter.required && (this.nullReferenceTypesFlag || this.getNullableTypes().contains(parameter.dataType))) {
            parameter.dataType = parameter.dataType + "?";
        }
    }

    @Override
    protected void patchProperty(Map<String, CodegenModel> enumRefs, CodegenModel model, CodegenProperty property) {
        super.patchProperty(enumRefs, model, property);
        if (!property.isContainer && (this.getNullableTypes().contains(property.dataType) || property.isEnum)) {
            property.vendorExtensions.put("x-csharp-value-type", true);
        }
    }

    @Override
    protected void updateCodegenParameterEnum(CodegenParameter parameter, CodegenModel model) {
        super.updateCodegenParameterEnumLegacy(parameter, model);
        if (!parameter.required && parameter.vendorExtensions.get("x-csharp-value-type") != null) {
            parameter.dataType = parameter.dataType + "?";
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "csharp-functions";
    }

    @Override
    public String getHelp() {
        return "Creates Azure function templates on top of the models/converters created by the C# codegens. This function is contained in a partial class. Default Get/Create/Patch/Post etc. methods are created with an underscore prefix. The assumption is that when the function is implemented, the partial class will be completed with another partial class. The implementing code should be located in a method of the same name, only without the underscore prefix. If no such method is found then the function will throw a Not Implemented exception. This setup allows the endpoints to be specified in the schema at build time, and separated from the implementing function.";
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
        this.additionalProperties.put("serverHost", url.getHost());
        this.additionalProperties.put("serverPort", URLPathUtils.getPort(url, 8080));
        this.setApiBasePath();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        if (!this.additionalProperties.containsKey("userSecretsGuid")) {
            this.additionalProperties.put("userSecretsGuid", this.userSecretsGuid);
        } else {
            this.userSecretsGuid = (String)this.additionalProperties.get("userSecretsGuid");
        }
        if (!this.additionalProperties.containsKey(NEWTONSOFT_VERSION)) {
            this.additionalProperties.put(NEWTONSOFT_VERSION, this.newtonsoftVersion);
        } else {
            this.newtonsoftVersion = (String)this.additionalProperties.get(NEWTONSOFT_VERSION);
        }
        this.setClassModifier();
        this.setOperationModifier();
        this.setModelClassModifier();
        this.setOperationIsAsync();
        this.additionalProperties.put("dockerTag", this.packageName.toLowerCase(Locale.ROOT));
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = this.packageName + ".Functions";
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.modelPackage = this.packageName + ".Models";
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        this.setAzureFunctionsVersion();
        this.setNetCoreVersion(packageFolder);
        this.setUseNewtonsoft();
        this.supportingFiles.add(new SupportingFile("build.sh.mustache", "", "build.sh"));
        this.supportingFiles.add(new SupportingFile("build.bat.mustache", "", "build.bat"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
        this.supportingFiles.add(new SupportingFile("gitignore", packageFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("OpenApi" + File.separator + "TypeExtensions.mustache", packageFolder + File.separator + "OpenApi", "TypeExtensions.cs"));
        this.supportingFiles.add(new SupportingFile("Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
        this.supportingFiles.add(new SupportingFile("typeConverter.mustache", packageFolder + File.separator + "Converters", "CustomEnumConverter.cs"));
        this.supportingFiles.add(new SupportingFile("host.json.mustache", packageFolder, "host.json"));
        this.supportingFiles.add(new SupportingFile("local.settings.json.mustache", packageFolder, "local.settings.json"));
        this.setTypeMapping();
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Functions";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Models";
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateJSONSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (operation.path != null) {
            if (operation.path.startsWith("/")) {
                operation.path = operation.path.substring(1);
            }
            String original = operation.path;
            operation.path = operation.path.replace("?", "/");
            if (!original.equals(operation.path)) {
                this.LOGGER.warn("Normalized {} to {}. Please verify generated source.", (Object)original, (Object)operation.path);
            }
        }
        operation.httpMethod = operation.httpMethod.charAt(0) + operation.httpMethod.substring(1).toLowerCase(Locale.ROOT);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations;
        super.postProcessOperationsWithModels(objs, allModels);
        if (objs != null && (operations = objs.getOperations()) != null) {
            List<CodegenOperation> ops = operations.getOperation();
            for (CodegenOperation operation : ops) {
                if (operation.consumes == null || operation.consumes.size() == 0) continue;
                StringBuilder consumesString = new StringBuilder();
                for (Map<String, String> consume : operation.consumes) {
                    if (!consume.containsKey("mediaType")) continue;
                    if (consumesString.toString().isEmpty()) {
                        consumesString = new StringBuilder("\"" + consume.get("mediaType") + "\"");
                    } else {
                        consumesString.append(", \"").append(consume.get("mediaType")).append("\"");
                    }
                    if (!consume.get("mediaType").equals("multipart/form-data")) continue;
                    for (CodegenParameter param : operation.formParams) {
                        if (!param.isBinary) continue;
                        param.dataType = "IFormFile";
                        param.baseType = "IFormFile";
                    }
                    for (CodegenParameter param : operation.allParams) {
                        if (!param.isBinary || !param.isFormParam) continue;
                        param.dataType = "IFormFile";
                        param.baseType = "IFormFile";
                    }
                }
                if (consumesString.toString().isEmpty()) continue;
                operation.vendorExtensions.put("x-aspnetcore-consumes", consumesString.toString());
            }
        }
        return objs;
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public String getNullableType(Schema p, String type) {
        if (this.languageSpecificPrimitives.contains(type)) {
            if (this.isSupportNullable() && ModelUtils.isNullable(p) && (this.getNullableTypes().contains(type) || this.nullReferenceTypesFlag)) {
                return type + "?";
            }
            return type;
        }
        return null;
    }

    @Override
    protected void patchVendorExtensionNullableValueType(CodegenParameter parameter) {
        super.patchVendorExtensionNullableValueTypeLegacy(parameter);
    }

    private void setCliOption(CliOption cliOption) throws IllegalArgumentException {
        if (this.additionalProperties.containsKey(cliOption.getOpt())) {
            Object obj = this.additionalProperties.get(cliOption.getOpt());
            if (!"boolean".equals(cliOption.getType()) && obj instanceof Boolean) {
                obj = "";
                this.additionalProperties.put(cliOption.getOpt(), obj);
            }
            cliOption.setOptValue(obj.toString());
        } else {
            this.additionalProperties.put(cliOption.getOpt(), cliOption.getOptValue());
        }
        if (cliOption.getOptValue() == null) {
            cliOption.setOptValue(cliOption.getDefault());
            throw new IllegalArgumentException(cliOption.getOpt() + ": Invalid value '" + this.additionalProperties.get(cliOption.getOpt()).toString() + "'. " + cliOption.getDescription());
        }
    }

    private void setClassModifier() {
        this.setCliOption(this.classModifier);
        if ("abstract".equals(this.classModifier.getOptValue())) {
            this.operationModifier.setOptValue(this.classModifier.getOptValue());
            this.additionalProperties.put(OPERATION_MODIFIER, this.operationModifier.getOptValue());
            this.LOGGER.warn("classModifier is {} so forcing operationModifier to {}", (Object)this.classModifier.getOptValue(), (Object)this.operationModifier.getOptValue());
        }
    }

    private void setOperationModifier() {
        this.setCliOption(this.operationModifier);
        if ("abstract".equals(this.operationModifier.getOptValue())) {
            this.generateBody = false;
            this.additionalProperties.put(GENERATE_BODY, this.generateBody);
            this.LOGGER.warn("operationModifier is {} so forcing generateBody to {}", (Object)this.operationModifier.getOptValue(), (Object)this.generateBody);
        } else if (this.additionalProperties.containsKey(GENERATE_BODY)) {
            this.generateBody = this.convertPropertyToBooleanAndWriteBack(GENERATE_BODY);
        } else {
            this.additionalProperties.put(GENERATE_BODY, this.generateBody);
        }
    }

    private void setModelClassModifier() {
        this.setCliOption(this.modelClassModifier);
        if (this.isLibrary) {
            this.modelClassModifier.setOptValue("");
            this.additionalProperties.put(MODEL_CLASS_MODIFIER, this.modelClassModifier.getOptValue());
            this.LOGGER.warn("buildTarget is {} so removing any modelClassModifier ", (Object)this.buildTarget.getOptValue());
        }
    }

    private void setNetCoreVersion(String packageFolder) {
        this.setCliOption(this.netCoreVersion);
        this.LOGGER.info("ASP.NET core version: {}", (Object)this.netCoreVersion.getOptValue());
    }

    private void setAzureFunctionsVersion() {
        this.setCliOption(this.azureFunctionsVersion);
        String functionsSDKVersion = "3.0.13";
        if ("v4".equals(this.azureFunctionsVersion.getOptValue())) {
            functionsSDKVersion = "4.0.1";
            if (!this.netCoreVersion.getOptValue().startsWith("6.")) {
                this.LOGGER.warn("ASP.NET core version: {} is not compatible with Azure functions v4. Using version 6.0.", (Object)this.netCoreVersion.getOptValue());
                this.netCoreVersion.setOptValue("6.0");
            }
        }
        this.additionalProperties.put(FUNCTIONS_SDK_VERSION, functionsSDKVersion);
        String targetFrameworkVersion = "net" + this.netCoreVersion.getOptValue();
        this.additionalProperties.put(TARGET_FRAMEWORK, targetFrameworkVersion);
        this.setAddititonalPropertyForFramework();
    }

    private void setAddititonalPropertyForFramework() {
        if (((String)this.additionalProperties.get(TARGET_FRAMEWORK)).startsWith("net6.0")) {
            this.additionalProperties.put(NET_60_OR_LATER, true);
        }
    }

    private void setOperationIsAsync() {
        if (this.isLibrary) {
            this.operationIsAsync = false;
            this.additionalProperties.put(OPERATION_IS_ASYNC, this.operationIsAsync);
        } else if (this.additionalProperties.containsKey(OPERATION_IS_ASYNC)) {
            this.operationIsAsync = this.convertPropertyToBooleanAndWriteBack(OPERATION_IS_ASYNC);
        } else {
            this.additionalProperties.put(OPERATION_IS_ASYNC, this.operationIsAsync);
        }
    }

    private void setUseNewtonsoft() {
        if (this.additionalProperties.containsKey(USE_NEWTONSOFT)) {
            this.useNewtonsoft = this.convertPropertyToBooleanAndWriteBack(USE_NEWTONSOFT);
        } else {
            this.additionalProperties.put(USE_NEWTONSOFT, this.useNewtonsoft);
        }
    }

    private void setApiBasePath() {
        URL url = URLPathUtils.getServerURL(this.openAPI, this.serverVariableOverrides());
        String apiBasePath = this.encodePath(url.getPath()).replaceAll("/$", "");
        if (apiBasePath != null && apiBasePath.length() > 0) {
            if (apiBasePath.startsWith("/")) {
                apiBasePath = apiBasePath.substring(1);
            }
            if (apiBasePath.endsWith("/")) {
                apiBasePath = apiBasePath.substring(0, apiBasePath.lastIndexOf("/"));
            }
        }
        this.additionalProperties.put("apiBasePath", apiBasePath);
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }
}

