/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCppCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CppPistacheServerCodegen
extends AbstractCppCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(CppPistacheServerCodegen.class);
    protected String implFolder = "impl";
    protected boolean isAddExternalLibs = true;
    protected boolean isUseStructModel = false;
    public static final String OPTIONAL_EXTERNAL_LIB = "addExternalLibs";
    public static final String OPTIONAL_EXTERNAL_LIB_DESC = "Add the Possibility to fetch and compile external Libraries needed by this Framework.";
    public static final String OPTION_USE_STRUCT_MODEL = "useStructModel";
    public static final String OPTION_USE_STRUCT_MODEL_DESC = "Use struct-based model template instead of get/set-based model template";
    public static final String HELPERS_PACKAGE_NAME = "helpersPackage";
    public static final String HELPERS_PACKAGE_NAME_DESC = "Specify the package name to be used for the helpers (e.g. org.openapitools.server.helpers).";
    protected final String PREFIX = "";
    protected String helpersPackage = "";
    private final Set<String> openAPITypesWithoutModelNamespace = new HashSet<String>();
    private static final String INT32_T = "int32_t";
    private static final String INT64_T = "int64_t";
    private static final String NLOHMANN_JSON = "nlohmann::json";
    private static final String STD_STRING = "std::string";
    private static final String STD_MAP = "std::map";
    private static final String STD_SET = "std::set";
    private static final String STD_VECTOR = "std::vector";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "cpp-pistache-server";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ API server (based on Pistache)";
    }

    public CppPistacheServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.MultiServer}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            this.modelNamePrefix = "";
        }
        this.helpersPackage = "org.openapitools.server.helpers";
        this.apiPackage = "org.openapitools.server.api";
        this.modelPackage = "org.openapitools.server.model";
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-impl-header.mustache", ".h");
        this.apiTemplateFiles.put("api-impl-source.mustache", ".cpp");
        this.templateDir = "cpp-pistache-server";
        this.embeddedTemplateDir = "cpp-pistache-server";
        this.cliOptions.clear();
        this.addSwitch(OPTIONAL_EXTERNAL_LIB, OPTIONAL_EXTERNAL_LIB_DESC, this.isAddExternalLibs);
        this.addOption(HELPERS_PACKAGE_NAME, HELPERS_PACKAGE_NAME_DESC, this.helpersPackage);
        this.addOption("reservedWordPrefix", "Prefix to prepend to reserved words in order to avoid conflicts", this.reservedWordPrefix);
        this.addSwitch(OPTION_USE_STRUCT_MODEL, OPTION_USE_STRUCT_MODEL_DESC, this.isUseStructModel);
        this.addOption("variableNameFirstCharacterUppercase", "Make first character of variable name uppercase (eg. value -> Value)", Boolean.toString(this.variableNameFirstCharacterUppercase));
        this.setupSupportingFiles();
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "char", "bool", "long", "float", "double", INT32_T, INT64_T));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", STD_STRING);
        this.typeMapping.put("DateTime", STD_STRING);
        this.typeMapping.put("string", STD_STRING);
        this.typeMapping.put("integer", INT32_T);
        this.typeMapping.put("long", INT64_T);
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", STD_VECTOR);
        this.typeMapping.put("map", STD_MAP);
        this.typeMapping.put("set", STD_SET);
        this.typeMapping.put("file", STD_STRING);
        this.typeMapping.put("object", NLOHMANN_JSON);
        this.typeMapping.put("binary", STD_STRING);
        this.typeMapping.put("number", "double");
        this.typeMapping.put("UUID", STD_STRING);
        this.typeMapping.put("URI", STD_STRING);
        this.typeMapping.put("ByteArray", STD_STRING);
        this.typeMapping.put("AnyType", NLOHMANN_JSON);
        this.importMapping = new HashMap();
        this.importMapping.put(STD_VECTOR, "#include <vector>");
        this.importMapping.put(STD_MAP, "#include <map>");
        this.importMapping.put(STD_SET, "#include <set>");
        this.importMapping.put(STD_STRING, "#include <string>");
        this.importMapping.put(NLOHMANN_JSON, "#include <nlohmann/json.hpp>");
        this.openAPITypesWithoutModelNamespace.add(NLOHMANN_JSON);
    }

    private void setupSupportingFiles() {
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("api-base-header.mustache", "api", "ApiBase.h"));
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", "model", this.modelNamePrefix + "Helpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-source.mustache", "model", this.modelNamePrefix + "Helpers.cpp"));
        this.supportingFiles.add(new SupportingFile("main-api-server.mustache", "", this.modelNamePrefix + "main-api-server.cpp"));
        this.supportingFiles.add(new SupportingFile("cmake.mustache", "", "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(HELPERS_PACKAGE_NAME)) {
            this.helpersPackage = (String)this.additionalProperties.get(HELPERS_PACKAGE_NAME);
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.additionalProperties().put("prefix", this.modelNamePrefix);
            this.setupSupportingFiles();
        }
        if (this.additionalProperties.containsKey("reservedWordPrefix")) {
            this.reservedWordPrefix = (String)this.additionalProperties.get("reservedWordPrefix");
        }
        this.additionalProperties.put("modelNamespaceDeclarations", this.modelPackage.split("\\."));
        this.additionalProperties.put("modelNamespace", this.modelPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("apiNamespaceDeclarations", this.apiPackage.split("\\."));
        this.additionalProperties.put("apiNamespace", this.apiPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("helpersNamespaceDeclarations", this.helpersPackage.split("\\."));
        this.additionalProperties.put("helpersNamespace", this.helpersPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("reservedWordPrefix", this.reservedWordPrefix);
        if (this.additionalProperties.containsKey(OPTIONAL_EXTERNAL_LIB)) {
            this.setAddExternalLibs(this.convertPropertyToBooleanAndWriteBack(OPTIONAL_EXTERNAL_LIB));
        } else {
            this.additionalProperties.put(OPTIONAL_EXTERNAL_LIB, this.isAddExternalLibs);
        }
        this.setupModelTemplate();
    }

    private void setupModelTemplate() {
        if (this.additionalProperties.containsKey(OPTION_USE_STRUCT_MODEL)) {
            this.isUseStructModel = this.convertPropertyToBooleanAndWriteBack(OPTION_USE_STRUCT_MODEL);
        }
        if (this.isUseStructModel) {
            this.LOGGER.info("Using struct-based model template");
            this.modelTemplateFiles.put("model-struct-header.mustache", ".h");
            this.modelTemplateFiles.put("model-struct-source.mustache", ".cpp");
        } else {
            this.LOGGER.info("Using get/set-based model template");
            this.modelTemplateFiles.put("model-header.mustache", ".h");
            this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        }
    }

    @Override
    public String toModelImport(String name) {
        if (name.startsWith("#include")) {
            return null;
        }
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        Set<String> oldImports = codegenModel.imports;
        codegenModel.imports = new HashSet<String>();
        for (String imp : oldImports) {
            String newImp = this.toModelImport(imp);
            if (newImp == null || newImp.isEmpty()) continue;
            codegenModel.imports.add(newImp);
        }
        if (!codegenModel.isEnum && codegenModel.anyOf.size() > 1 && codegenModel.anyOf.contains(STD_STRING) && !codegenModel.anyOf.contains("AnyType") && codegenModel.interfaces.size() == 1) {
            codegenModel.vendorExtensions.put("x-is-string-enum-container", true);
        }
        return codegenModel;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        Schema response;
        ApiResponse apiResponse;
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (apiResponse = this.findMethodResponse(operation.getResponses())) != null && (response = ModelUtils.getSchemaFromResponse(this.openAPI, apiResponse)) != null) {
            CodegenProperty cm = this.fromProperty("response", response, false);
            op.vendorExtensions.put("x-codegen-response", cm);
            if ("HttpContent".equals(cm.dataType)) {
                op.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
            }
        }
        String pathForPistache = path.replaceAll("\\{(.*?)}", ":$1");
        op.vendorExtensions.put("x-codegen-pistache-path", pathForPistache);
        return op;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        String classname = operations.getClassname();
        operations.put("classnameSnakeUpperCase", StringUtils.underscore(classname).toUpperCase(Locale.ROOT));
        operations.put("classnameSnakeLowerCase", StringUtils.underscore(classname).toLowerCase(Locale.ROOT));
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            this.postProcessSingleOperation(operations, op);
        }
        return objs;
    }

    private void postProcessSingleOperation(OperationMap operations, CodegenOperation op) {
        if (op.vendorExtensions == null) {
            op.vendorExtensions = new HashMap<String, Object>();
        }
        if (op.bodyParam != null) {
            if (op.bodyParam.vendorExtensions == null) {
                op.bodyParam.vendorExtensions = new HashMap<String, Object>();
            }
            boolean isStringOrDate = op.bodyParam.isString || op.bodyParam.isDate;
            op.bodyParam.vendorExtensions.put("x-codegen-pistache-is-string-or-date", isStringOrDate);
        }
        boolean consumeJson = false;
        if (op.consumes != null) {
            Predicate<Map> isMediaTypeJson = consume -> consume.get("mediaType") != null && ((String)consume.get("mediaType")).equals("application/json");
            consumeJson = op.consumes.stream().anyMatch(isMediaTypeJson);
        }
        op.vendorExtensions.put("x-codegen-pistache-consumes-json", consumeJson);
        op.httpMethod = op.httpMethod.substring(0, 1).toUpperCase(Locale.ROOT) + op.httpMethod.substring(1).toLowerCase(Locale.ROOT);
        boolean isParsingSupported = true;
        for (CodegenParameter param : op.allParams) {
            boolean paramSupportsParsing = !param.isFormParam && !param.isFile && !param.isCookieParam;
            isParsingSupported = isParsingSupported && paramSupportsParsing;
            this.postProcessSingleParam(param);
        }
        op.vendorExtensions.put("x-codegen-pistache-is-parsing-supported", isParsingSupported);
        Predicate<String> importNotInImportMapping = hdr -> !this.importMapping.containsKey(hdr);
        if (op.imports.stream().anyMatch(importNotInImportMapping)) {
            operations.put("hasModelImport", true);
        }
    }

    private void postProcessSingleParam(CodegenParameter param) {
        if (param.isHeaderParam) {
            param.dataType = "std::optional<Pistache::Http::Header::Raw>";
            param.baseType = "std::optional<Pistache::Http::Header::Raw>";
        } else if (param.isQueryParam) {
            String dataTypeWithNamespace = param.isPrimitiveType ? param.dataType : this.prefixWithNameSpaceIfNeeded(param.dataType);
            param.dataType = "std::optional<" + dataTypeWithNamespace + ">";
            param.isOptional = true;
            if (!param.isPrimitiveType) {
                param.baseType = "std::optional<" + param.baseType + ">";
            }
        }
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("impl-header.mustache")) {
            result = this.implFilenameFromApiFilename(result, ".h");
        } else if (templateName.endsWith("impl-source.mustache")) {
            result = this.implFilenameFromApiFilename(result, ".cpp");
        }
        return result;
    }

    private String implFilenameFromApiFilename(String filename, String suffix) {
        Object result = filename.substring(0, filename.length() - suffix.length()) + "Impl" + suffix;
        result = ((String)result).replace(this.apiFileFolder(), this.implFileFolder());
        return result;
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (ModelUtils.isArraySchema(p)) {
            Schema<?> inner = ModelUtils.getSchemaItems(p);
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<std::string, " + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isByteArraySchema(p)) {
            return STD_STRING;
        }
        if (ModelUtils.isStringSchema(p) || ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p) || ModelUtils.isFileSchema(p) || this.languageSpecificPrimitives.contains(openAPIType)) {
            return this.toModelName(openAPIType);
        }
        return this.prefixWithNameSpaceIfNeeded(openAPIType);
    }

    private String prefixWithNameSpaceIfNeeded(String openAPIType) {
        if (this.openAPITypesWithoutModelNamespace.contains(openAPIType) || openAPIType.startsWith("std::")) {
            return openAPIType;
        }
        String namespace = (String)this.additionalProperties.get("modelNamespace");
        return namespace + "::" + openAPIType;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
            return "\"\"";
        }
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "false";
        }
        if (ModelUtils.isDateSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
            return "\"\"";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
            return "\"\"";
        }
        if (ModelUtils.isNumberSchema(p)) {
            if (ModelUtils.isFloatSchema(p)) {
                if (p.getDefault() != null) {
                    String defaultStr = p.getDefault().toString();
                    if (defaultStr.indexOf(46) < 0) {
                        return defaultStr + ".0f";
                    }
                    return defaultStr + "f";
                }
                return "0.0f";
            }
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "0.0";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (ModelUtils.isLongSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString() + "L";
                }
                return "0L";
            }
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "0";
        }
        if (ModelUtils.isByteArraySchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
            return "\"\"";
        }
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(ModelUtils.getAdditionalProperties(p));
            return "std::map<std::string, " + inner + ">()";
        }
        if (ModelUtils.isArraySchema(p)) {
            Object inner = this.getSchemaType(ModelUtils.getSchemaItems(p));
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = "std::shared_ptr<" + (String)inner + ">";
            }
            return "std::vector<" + (String)inner + ">()";
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return "std::make_shared<" + this.toModelName(ModelUtils.getSimpleRef(p.get$ref())) + ">()";
        }
        return "nullptr";
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/model").replace("/", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/api").replace("/", File.separator);
    }

    private String implFileFolder() {
        return (this.outputFolder + "/" + this.implFolder).replace("/", File.separator);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(String str) {
        return this.toModelName(str);
    }

    public void setAddExternalLibs(boolean value) {
        this.isAddExternalLibs = value;
    }
}

