/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.templating.mustache.CamelCaseLambda;
import org.openapitools.codegen.templating.mustache.LowercaseLambda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinServerCodegen
extends AbstractKotlinCodegen
implements BeanValidationFeatures {
    public static final String DEFAULT_LIBRARY = "ktor";
    private final Logger LOGGER = LoggerFactory.getLogger(KotlinServerCodegen.class);
    private Boolean autoHeadFeatureEnabled = true;
    private Boolean conditionalHeadersFeatureEnabled = false;
    private Boolean hstsFeatureEnabled = true;
    private Boolean corsFeatureEnabled = false;
    private Boolean compressionFeatureEnabled = true;
    private Boolean resourcesFeatureEnabled = true;
    private Boolean metricsFeatureEnabled = true;
    private boolean interfaceOnly = false;
    private boolean useBeanValidation = false;
    private boolean useCoroutines = false;
    private boolean useMutiny = false;
    private boolean returnResponse = false;
    private boolean omitGradleWrapper = false;
    private Map<String, List<String>> optionsSupportedPerFramework = new ImmutableMap.Builder().put((Object)"ktor", Arrays.asList("featureAutoHead", "featureConditionalHeaders", "featureHSTS", "featureCORS", "featureCompression", "featureResources", "featureMetrics", "omitGradleWrapper")).put((Object)"jaxrs-spec", Arrays.asList("useBeanValidation", "useCoroutines", "useMutiny", "returnResponse", "interfaceOnly")).build();

    public KotlinServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.artifactId = "kotlin-server";
        this.packageName = "org.openapitools.server";
        this.typeMapping.put("array", "kotlin.collections.List");
        this.updateOption("artifactId", this.artifactId);
        this.updateOption("packageName", this.packageName);
        this.outputFolder = "generated-code" + File.separator + "kotlin-server";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.templateDir = "kotlin-server";
        this.embeddedTemplateDir = "kotlin-server";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.supportedLibraries.put(DEFAULT_LIBRARY, "ktor framework");
        this.supportedLibraries.put("jaxrs-spec", "JAX-RS spec only");
        this.supportedLibraries.put("javalin5", "Javalin 5");
        this.supportedLibraries.put("javalin6", "Javalin 6");
        this.addOption("library", "library template (sub-template)", DEFAULT_LIBRARY, this.supportedLibraries);
        this.addSwitch("featureAutoHead", "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.", this.getAutoHeadFeatureEnabled());
        this.addSwitch("featureConditionalHeaders", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getConditionalHeadersFeatureEnabled());
        this.addSwitch("featureHSTS", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getHstsFeatureEnabled());
        this.addSwitch("featureCORS", "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.", this.getCorsFeatureEnabled());
        this.addSwitch("featureCompression", "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.", this.getCompressionFeatureEnabled());
        this.addSwitch("featureResources", "Generates routes in a typed way, for both: constructing URLs and reading the parameters.", this.getResourcesFeatureEnabled());
        this.addSwitch("featureMetrics", "Enables metrics feature.", this.getMetricsFeatureEnabled());
        this.addSwitch("interfaceOnly", "Whether to generate only API interface stubs without the server files. This option is currently supported only when using jaxrs-spec library.", this.interfaceOnly);
        this.addSwitch("useBeanValidation", "Use BeanValidation API annotations. This option is currently supported only when using jaxrs-spec library.", this.useBeanValidation);
        this.addSwitch("useCoroutines", "Whether to use the Coroutines. This option is currently supported only when using jaxrs-spec library.", this.useCoroutines);
        this.addSwitch("useMutiny", "Whether to use Mutiny (should not be used with useCoroutines). This option is currently supported only when using jaxrs-spec library.", this.useMutiny);
        this.addSwitch("returnResponse", "Whether generate API interface should return javax.ws.rs.core.Response instead of a deserialized entity. Only useful if interfaceOnly is true. This option is currently supported only when using jaxrs-spec library.", this.returnResponse);
        this.addSwitch("omitGradleWrapper", "Whether to omit Gradle wrapper for creating a sub project.", this.omitGradleWrapper);
        this.addSwitch("useJakartaEe", "whether to use Jakarta EE namespace instead of javax", this.useJakartaEe);
    }

    @Override
    public String getHelp() {
        return "Generates a Kotlin server.";
    }

    public boolean getOmitGradleWrapper() {
        return this.omitGradleWrapper;
    }

    @Override
    public String getName() {
        return "kotlin-server";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.isModelMutable()) {
            this.typeMapping.put("array", "kotlin.collections.MutableList");
        }
        if (this.additionalProperties.containsKey("library")) {
            this.setLibrary((String)this.additionalProperties.get("library"));
        }
        if (this.additionalProperties.containsKey("interfaceOnly")) {
            this.interfaceOnly = Boolean.parseBoolean(this.additionalProperties.get("interfaceOnly").toString());
            if (!this.interfaceOnly) {
                this.additionalProperties.remove("interfaceOnly");
            }
        }
        if (this.additionalProperties.containsKey("useCoroutines")) {
            this.useCoroutines = Boolean.parseBoolean(this.additionalProperties.get("useCoroutines").toString());
            if (!this.useCoroutines) {
                this.additionalProperties.remove("useCoroutines");
            }
        }
        if (this.additionalProperties.containsKey("useMutiny")) {
            this.useMutiny = Boolean.parseBoolean(this.additionalProperties.get("useMutiny").toString());
            if (!this.useMutiny) {
                this.additionalProperties.remove("useMutiny");
            }
        }
        if (this.additionalProperties.containsKey("returnResponse")) {
            this.returnResponse = Boolean.parseBoolean(this.additionalProperties.get("returnResponse").toString());
            if (!this.returnResponse) {
                this.additionalProperties.remove("returnResponse");
            }
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        if (this.additionalProperties.containsKey("omitGradleWrapper")) {
            this.setOmitGradleWrapper(Boolean.parseBoolean(this.additionalProperties.get("omitGradleWrapper").toString()));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (StringUtils.isEmpty((CharSequence)this.library)) {
            this.setLibrary(DEFAULT_LIBRARY);
            this.additionalProperties.put("library", DEFAULT_LIBRARY);
            this.LOGGER.info("`library` option is empty. Default to {}", (Object)DEFAULT_LIBRARY);
        }
        if (this.additionalProperties.containsKey("featureAutoHead")) {
            this.setAutoHeadFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureAutoHead"));
        } else {
            this.additionalProperties.put("featureAutoHead", this.getAutoHeadFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureConditionalHeaders")) {
            this.setConditionalHeadersFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureConditionalHeaders"));
        } else {
            this.additionalProperties.put("featureConditionalHeaders", this.getConditionalHeadersFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureHSTS")) {
            this.setHstsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureHSTS"));
        } else {
            this.additionalProperties.put("featureHSTS", this.getHstsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCORS")) {
            this.setCorsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCORS"));
        } else {
            this.additionalProperties.put("featureCORS", this.getCorsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCompression")) {
            this.setCompressionFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCompression"));
        } else {
            this.additionalProperties.put("featureCompression", this.getCompressionFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureResources")) {
            this.setResourcesFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureResources"));
        } else {
            this.additionalProperties.put("featureResources", this.getResourcesFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureMetrics")) {
            this.setMetricsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureMetrics"));
        } else {
            this.additionalProperties.put("featureMetrics", this.getMetricsFeatureEnabled());
        }
        boolean generateApis = this.additionalProperties.containsKey("generateApis") && (Boolean)this.additionalProperties.get("generateApis") != false;
        String packageFolder = (this.sourceFolder + File.separator + this.packageName).replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (this.library.equals(DEFAULT_LIBRARY)) {
            this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        }
        String gradleBuildFile = "build.gradle";
        if (this.isJavalin()) {
            gradleBuildFile = "build.gradle.kts";
        }
        this.supportingFiles.add(new SupportingFile(gradleBuildFile + ".mustache", "", gradleBuildFile));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.supportingFiles.add(new SupportingFile("gradle.properties", "", "gradle.properties"));
        if (this.library.equals(DEFAULT_LIBRARY)) {
            this.supportingFiles.add(new SupportingFile("AppMain.kt.mustache", packageFolder, "AppMain.kt"));
            this.supportingFiles.add(new SupportingFile("Configuration.kt.mustache", packageFolder, "Configuration.kt"));
            if (generateApis && this.resourcesFeatureEnabled.booleanValue()) {
                this.supportingFiles.add(new SupportingFile("Paths.kt.mustache", packageFolder, "Paths.kt"));
            }
            this.supportingFiles.add(new SupportingFile("application.conf.mustache", this.resourcesFolder, "application.conf"));
            this.supportingFiles.add(new SupportingFile("logback.xml", this.resourcesFolder, "logback.xml"));
            String infrastructureFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "infrastructure").replace(".", File.separator);
            this.supportingFiles.add(new SupportingFile("ApiKeyAuth.kt.mustache", infrastructureFolder, "ApiKeyAuth.kt"));
        } else if (this.isJavalin()) {
            this.supportingFiles.add(new SupportingFile("Main.kt.mustache", packageFolder, "Main.kt"));
            this.apiTemplateFiles.put("service.mustache", "Service.kt");
            this.apiTemplateFiles.put("serviceImpl.mustache", "ServiceImpl.kt");
            this.additionalProperties.put("lowercase", new LowercaseLambda());
            this.additionalProperties.put("camelcase", new CamelCaseLambda());
            this.typeMapping.put("file", "io.javalin.http.UploadedFile");
            this.importMapping.put("io.javalin.http.UploadedFile", "io.javalin.http.UploadedFile");
        }
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator's contributed by Jim Schubert (https://github.com/jimschubert)#");
        System.out.println("# Please support his work directly via https://patreon.com/jimschubert \ud83d\ude4f     #");
        System.out.println("################################################################################");
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        if (operations != null && !Objects.equals(this.library, "jaxrs-spec")) {
            List<CodegenOperation> ops = operations.getOperation();
            ops.forEach(operation -> {
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    responses.forEach(resp -> {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        this.doDataTypeAssignment(resp.dataType, new AbstractKotlinCodegen.DataTypeAssigner((CodegenResponse)resp){
                            final /* synthetic */ CodegenResponse val$resp;
                            {
                                this.val$resp = codegenResponse;
                            }

                            @Override
                            public void setReturnType(String returnType) {
                                this.val$resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                this.val$resp.containerType = returnContainer;
                            }
                        });
                    });
                }
                this.doDataTypeAssignment(operation.returnType, new AbstractKotlinCodegen.DataTypeAssigner((CodegenOperation)operation){
                    final /* synthetic */ CodegenOperation val$operation;
                    {
                        this.val$operation = codegenOperation;
                    }

                    @Override
                    public void setReturnType(String returnType) {
                        this.val$operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        this.val$operation.returnContainer = returnContainer;
                    }
                });
            });
        }
        return objs;
    }

    private boolean isJavalin() {
        return "javalin5".equals(this.library) || "javalin6".equals(this.library);
    }

    public Boolean getAutoHeadFeatureEnabled() {
        return this.autoHeadFeatureEnabled;
    }

    public void setAutoHeadFeatureEnabled(Boolean autoHeadFeatureEnabled) {
        this.autoHeadFeatureEnabled = autoHeadFeatureEnabled;
    }

    public Boolean getConditionalHeadersFeatureEnabled() {
        return this.conditionalHeadersFeatureEnabled;
    }

    public void setConditionalHeadersFeatureEnabled(Boolean conditionalHeadersFeatureEnabled) {
        this.conditionalHeadersFeatureEnabled = conditionalHeadersFeatureEnabled;
    }

    public Boolean getHstsFeatureEnabled() {
        return this.hstsFeatureEnabled;
    }

    public void setHstsFeatureEnabled(Boolean hstsFeatureEnabled) {
        this.hstsFeatureEnabled = hstsFeatureEnabled;
    }

    public Boolean getCorsFeatureEnabled() {
        return this.corsFeatureEnabled;
    }

    public void setCorsFeatureEnabled(Boolean corsFeatureEnabled) {
        this.corsFeatureEnabled = corsFeatureEnabled;
    }

    public Boolean getCompressionFeatureEnabled() {
        return this.compressionFeatureEnabled;
    }

    public void setCompressionFeatureEnabled(Boolean compressionFeatureEnabled) {
        this.compressionFeatureEnabled = compressionFeatureEnabled;
    }

    public Boolean getResourcesFeatureEnabled() {
        return this.resourcesFeatureEnabled;
    }

    public void setResourcesFeatureEnabled(Boolean resourcesFeatureEnabled) {
        this.resourcesFeatureEnabled = resourcesFeatureEnabled;
    }

    public Boolean getMetricsFeatureEnabled() {
        return this.metricsFeatureEnabled;
    }

    public void setMetricsFeatureEnabled(Boolean metricsFeatureEnabled) {
        this.metricsFeatureEnabled = metricsFeatureEnabled;
    }

    public void setOmitGradleWrapper(boolean omitGradleWrapper) {
        this.omitGradleWrapper = omitGradleWrapper;
    }

    public static class Constants {
        public static final String KTOR = "ktor";
        public static final String JAXRS_SPEC = "jaxrs-spec";
        public static final String JAVALIN5 = "javalin5";
        public static final String JAVALIN6 = "javalin6";
        public static final String AUTOMATIC_HEAD_REQUESTS = "featureAutoHead";
        public static final String AUTOMATIC_HEAD_REQUESTS_DESC = "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.";
        public static final String CONDITIONAL_HEADERS = "featureConditionalHeaders";
        public static final String CONDITIONAL_HEADERS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String HSTS = "featureHSTS";
        public static final String HSTS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String CORS = "featureCORS";
        public static final String CORS_DESC = "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.";
        public static final String COMPRESSION = "featureCompression";
        public static final String COMPRESSION_DESC = "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.";
        public static final String RESOURCES = "featureResources";
        public static final String RESOURCES_DESC = "Generates routes in a typed way, for both: constructing URLs and reading the parameters.";
        public static final String METRICS = "featureMetrics";
        public static final String METRICS_DESC = "Enables metrics feature.";
        public static final String INTERFACE_ONLY = "interfaceOnly";
        public static final String INTERFACE_ONLY_DESC = "Whether to generate only API interface stubs without the server files. This option is currently supported only when using jaxrs-spec library.";
        public static final String USE_BEANVALIDATION_DESC = "Use BeanValidation API annotations. This option is currently supported only when using jaxrs-spec library.";
        public static final String USE_COROUTINES = "useCoroutines";
        public static final String USE_COROUTINES_DESC = "Whether to use the Coroutines. This option is currently supported only when using jaxrs-spec library.";
        public static final String RETURN_RESPONSE = "returnResponse";
        public static final String RETURN_RESPONSE_DESC = "Whether generate API interface should return javax.ws.rs.core.Response instead of a deserialized entity. Only useful if interfaceOnly is true. This option is currently supported only when using jaxrs-spec library.";
        public static final String USE_JAKARTA_EE_DESC = "whether to use Jakarta EE namespace instead of javax";
        public static final String USE_MUTINY = "useMutiny";
        public static final String USE_MUTINY_DESC = "Whether to use Mutiny (should not be used with useCoroutines). This option is currently supported only when using jaxrs-spec library.";
        public static final String OMIT_GRADLE_WRAPPER = "omitGradleWrapper";
        public static final String OMIT_GRADLE_WRAPPER_DESC = "Whether to omit Gradle wrapper for creating a sub project.";
    }
}

