/*
 * Copyright (c) Neo4j Sweden AB (http://neo4j.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.opencypher.v9_0.util

sealed trait NameId {
  def id: Int
}

final case class LabelId(id: Int) extends NameId
final case class RelTypeId(id: Int) extends NameId
final case class PropertyKeyId(id: Int) extends NameId

object NameId {
  val WILDCARD: Int = -1

  implicit def toKernelEncode(nameId: NameId): Int = nameId.id
  implicit def toKernelEncode(nameId: Option[NameId]): Int = nameId.map(toKernelEncode).getOrElse(WILDCARD)
}
