/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.concepts.ObjectRegistration;

@ThreadSafe
public class ListenerRegistry<T extends EventListener>
implements Iterable<ListenerRegistration<T>>,
Mutable {
    private final Set<ListenerRegistration<? extends T>> listeners = ConcurrentHashMap.newKeySet();
    private final Set<ListenerRegistration<T>> unmodifiableView = Collections.unmodifiableSet(this.listeners);
    private final String name;

    private ListenerRegistry(String name) {
        this.name = name;
    }

    @Deprecated
    public ListenerRegistry() {
        this(null);
    }

    public static <T extends EventListener> ListenerRegistry<T> create() {
        return new ListenerRegistry<T>(null);
    }

    public static <T extends EventListener> ListenerRegistry<T> create(@NonNull String name) {
        return new ListenerRegistry<T>(Objects.requireNonNull(name));
    }

    public Iterable<ListenerRegistration<T>> getListeners() {
        return this.unmodifiableView;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public Stream<? extends T> streamListeners() {
        return this.listeners.stream().map(ObjectRegistration::getInstance);
    }

    public ListenerRegistration<T> register(T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null.");
        }
        return this.registerWithType(listener);
    }

    public <L extends T> ListenerRegistration<L> registerWithType(L listener) {
        ListenerRegistrationImpl ret = new ListenerRegistrationImpl(listener, this.listeners::remove);
        this.listeners.add((ListenerRegistration<T>)ret);
        return ret;
    }

    @Override
    public Iterator<ListenerRegistration<T>> iterator() {
        return this.unmodifiableView.iterator();
    }

    public String toString() {
        return this.name == null ? super.toString() : MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("size", this.listeners.size()).toString();
    }

    private static final class ListenerRegistrationImpl<T extends EventListener>
    extends AbstractListenerRegistration<T> {
        private Consumer<ListenerRegistration<? super T>> removeCall;

        ListenerRegistrationImpl(T instance, Consumer<ListenerRegistration<? super T>> removeCall) {
            super(instance);
            this.removeCall = Objects.requireNonNull(removeCall);
        }

        protected void removeRegistration() {
            this.removeCall.accept((ListenerRegistration<ListenerRegistrationImpl>)this);
            this.removeCall = null;
        }
    }
}

