/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.adaptor;

import java.lang.reflect.Method;
import java.math.BigInteger;
import org.openeuler.adaptor.AdapterBase;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class DerOutputStreamAdapter
extends AdapterBase {
    private static final String IMPL_CLASS = "sun.security.util.DerOutputStream";
    private static final Class<?> proxyClass;
    private static Method putOID;
    private static Method putInteger_BigInteger;

    public DerOutputStreamAdapter(DerOutputStream out) {
        this.proxy = out;
    }

    private static void init() throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        if (proxyClass == null) {
            return;
        }
        putOID = proxyClass.getDeclaredMethod("putOID", ObjectIdentifier.class);
        putInteger_BigInteger = proxyClass.getDeclaredMethod("putInteger", BigInteger.class);
    }

    public void putOID(ObjectIdentifier oid) {
        this.ensureAvailable();
        if (putOID != null) {
            this.invoke(putOID, oid);
        }
    }

    public void putInteger(BigInteger var1) {
        this.ensureAvailable();
        if (putInteger_BigInteger != null) {
            this.invoke(putInteger_BigInteger, var1);
        }
    }

    static {
        try {
            proxyClass = Class.forName(IMPL_CLASS, true, null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            DerOutputStreamAdapter.init();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            exception = e;
        }
    }
}

