/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.adaptor;

import java.lang.reflect.Method;
import org.openeuler.adaptor.AdapterBase;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.X509CertInfo;

public class X509CertInfoAdapter
extends AdapterBase {
    private static final String EXTENSIONS = "extensions";
    private static final String IMPL_CLASS = "sun.security.x509.X509CertInfo";
    private static Method get;
    private static Method getExtensions;
    private static final Class<?> proxyClass;

    public X509CertInfoAdapter(X509CertInfo cert) {
        this.proxy = cert;
    }

    private static void init() throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        if (proxyClass == null) {
            return;
        }
        try {
            get = proxyClass.getDeclaredMethod("get", String.class);
        }
        catch (NoSuchMethodException e) {
            getExtensions = proxyClass.getDeclaredMethod("getExtensions", new Class[0]);
        }
    }

    public CertificateExtensions getExtensions() {
        this.ensureAvailable();
        if (get != null) {
            return (CertificateExtensions)this.invoke(get, EXTENSIONS);
        }
        return (CertificateExtensions)this.invoke(getExtensions, new Object[0]);
    }

    static {
        try {
            proxyClass = Class.forName(IMPL_CLASS, true, null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            X509CertInfoAdapter.init();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            exception = e;
        }
    }
}

