/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.provider;

import java.security.Provider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class AbstractEntries {
    private final LinkedHashSet<Provider.Service> services = new LinkedHashSet();

    protected AbstractEntries(Provider provider) {
        this.putServices(provider);
    }

    protected static List<String> createAliases(String ... aliases) {
        return Arrays.asList(aliases);
    }

    protected static List<String> createAliasesWithOid(String ... oids) {
        String[] result = Arrays.copyOf(oids, oids.length + 1);
        result[result.length - 1] = "OID." + oids[0];
        return Arrays.asList(result);
    }

    Iterator<Provider.Service> iterator() {
        return this.services.iterator();
    }

    protected void add(Provider provider, String type, String algo, String className, List<String> aliases, HashMap<String, String> attrs) {
        this.services.add(new Provider.Service(provider, type, algo, className, aliases, attrs));
    }

    protected void add(Provider provider, String type, String algo, String className, List<String> aliases) {
        this.add(provider, type, algo, className, aliases, null);
    }

    protected void add(Provider provider, String type, String algo, String className) {
        this.add(provider, type, algo, className, null);
    }

    protected void add(Provider.Service service) {
        this.services.add(service);
    }

    protected void add(AbstractEntries entries) {
        Iterator<Provider.Service> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Provider.Service service = iterator.next();
            this.add(service);
        }
    }

    protected abstract void putServices(Provider var1);
}

