/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.Iterator;
import org.openeuler.adaptor.CompatibleOracleJdkHandler;
import org.openeuler.provider.AbstractEntries;

public abstract class AbstractProvider
extends Provider {
    protected AbstractProvider(String name, double version, String info) {
        super(name, version, info);
        this.putEntries(this);
        CompatibleOracleJdkHandler.skipJarVerify(this);
    }

    protected void putEntries(AbstractEntries entries) {
        final Iterator<Provider.Service> iterator = entries.iterator();
        if (System.getSecurityManager() == null) {
            this.putEntries(iterator);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    AbstractProvider.this.putEntries(iterator);
                    return null;
                }
            });
        }
    }

    protected void putEntries(Provider provider) {
        AbstractEntries entries = this.createEntries(provider);
        this.putEntries(entries);
    }

    protected abstract AbstractEntries createEntries(Provider var1);

    private void putEntries(Iterator<Provider.Service> iterator) {
        while (iterator.hasNext()) {
            this.putService(iterator.next());
        }
    }
}

