/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.spec;

import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.openeuler.constant.GMConstants;

public class SM2KeyExchangeParameterSpec
implements AlgorithmParameterSpec {
    private byte[] localId;
    private ECPublicKey localPublicKey;
    private ECPrivateKey localTempPrivateKey;
    private ECPublicKey localTempPublicKey;
    private byte[] peerId;
    private ECPublicKey peerTempPublicKey;
    private int secretLen;
    private boolean useClientMode;

    public SM2KeyExchangeParameterSpec(byte[] localId, ECPublicKey localPublicKey, ECPrivateKey localTempPrivateKey, ECPublicKey localTempPublicKey, byte[] peerId, ECPublicKey peerTempPublicKey, int secretLen, boolean useClientMode) {
        this.localId = localId;
        this.localPublicKey = localPublicKey;
        this.localTempPrivateKey = localTempPrivateKey;
        this.localTempPublicKey = localTempPublicKey;
        this.peerId = peerId;
        this.peerTempPublicKey = peerTempPublicKey;
        this.secretLen = secretLen;
        this.useClientMode = useClientMode;
    }

    public SM2KeyExchangeParameterSpec(ECPublicKey localPublicKey, ECPrivateKey localTempPrivateKey, ECPublicKey localTempPublicKey, ECPublicKey peerTempPublicKey, int secretLen, boolean useClientMode) {
        this(GMConstants.DEFAULT_ID, localPublicKey, localTempPrivateKey, localTempPublicKey, GMConstants.DEFAULT_ID, peerTempPublicKey, secretLen, useClientMode);
    }

    public SM2KeyExchangeParameterSpec(byte[] localId, ECPrivateKey localTempPrivateKey, ECPublicKey localTempPublicKey, byte[] peerId, ECPublicKey peerTempPublicKey, int secretLen, boolean useClientMode) {
        this(localId, null, localTempPrivateKey, localTempPublicKey, peerId, peerTempPublicKey, secretLen, useClientMode);
    }

    public byte[] getLocalId() {
        return this.localId;
    }

    public void setLocalId(byte[] localId) {
        this.localId = localId;
    }

    public ECPublicKey getLocalPublicKey() {
        return this.localPublicKey;
    }

    public void setLocalPublicKey(ECPublicKey localPublicKey) {
        this.localPublicKey = localPublicKey;
    }

    public ECPrivateKey getLocalTempPrivateKey() {
        return this.localTempPrivateKey;
    }

    public void setLocalTempPrivateKey(ECPrivateKey localTempPrivateKey) {
        this.localTempPrivateKey = localTempPrivateKey;
    }

    public ECPublicKey getLocalTempPublicKey() {
        return this.localTempPublicKey;
    }

    public void setLocalTempPublicKey(ECPublicKey localTempPublicKey) {
        this.localTempPublicKey = localTempPublicKey;
    }

    public byte[] getPeerId() {
        return this.peerId;
    }

    public void setPeerId(byte[] peerId) {
        this.peerId = peerId;
    }

    public ECPublicKey getPeerTempPublicKey() {
        return this.peerTempPublicKey;
    }

    public void setPeerTempPublicKey(ECPublicKey peerTempPublicKey) {
        this.peerTempPublicKey = peerTempPublicKey;
    }

    public int getSecretLen() {
        return this.secretLen;
    }

    public void setSecretLen(int secretLen) {
        this.secretLen = secretLen;
    }

    public boolean isUseClientMode() {
        return this.useClientMode;
    }

    public void setUseClientMode(boolean useClientMode) {
        this.useClientMode = useClientMode;
    }
}

