/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.internal.spec;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;

@Deprecated
public class TlsECCKeyAgreementParameterSpec
implements AlgorithmParameterSpec {
    private final byte[] encryptedSecret;
    private static final String PROP_NAME = "com.sun.net.ssl.eccPreMasterSecretFix";
    private static final boolean eccPreMasterSecretFix = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String value = System.getProperty(TlsECCKeyAgreementParameterSpec.PROP_NAME);
            if (value != null && value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    });
    private final int clientVersion;
    private final int serverVersion;
    private final boolean isClient;

    public TlsECCKeyAgreementParameterSpec(int clientVersion, int serverVersion) {
        this.clientVersion = this.checkVersion(clientVersion);
        this.serverVersion = this.checkVersion(serverVersion);
        this.encryptedSecret = null;
        this.isClient = true;
    }

    public TlsECCKeyAgreementParameterSpec(int clientVersion, int serverVersion, byte[] encryptedSecret) {
        this.clientVersion = this.checkVersion(clientVersion);
        this.serverVersion = this.checkVersion(serverVersion);
        if (encryptedSecret == null) {
            throw new IllegalArgumentException("Encrypted secret cannot be null");
        }
        this.encryptedSecret = (byte[])encryptedSecret.clone();
        this.isClient = true;
    }

    public TlsECCKeyAgreementParameterSpec(byte[] encryptedSecret, int clientVersion, int serverVersion, boolean isClient) {
        this.clientVersion = this.checkVersion(clientVersion);
        this.serverVersion = this.checkVersion(serverVersion);
        if (encryptedSecret == null) {
            throw new IllegalArgumentException("Encrypted secret cannot be null");
        }
        this.encryptedSecret = (byte[])encryptedSecret.clone();
        this.isClient = isClient;
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public int getMajorVersion() {
        if (eccPreMasterSecretFix || this.clientVersion >= 770) {
            return this.clientVersion >>> 8 & 0xFF;
        }
        return this.serverVersion >>> 8 & 0xFF;
    }

    public int getMinorVersion() {
        if (eccPreMasterSecretFix || this.clientVersion >= 770) {
            return this.clientVersion & 0xFF;
        }
        return this.serverVersion & 0xFF;
    }

    private int checkVersion(int version) {
        if (version < 0 || version > 65535) {
            throw new IllegalArgumentException("Version must be between 0 and 65,535");
        }
        return version;
    }

    public byte[] getEncryptedSecret() {
        return this.encryptedSecret == null ? null : (byte[])this.encryptedSecret.clone();
    }

    public boolean isClient() {
        return this.isClient;
    }
}

