/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class JavaVersionUtil {
    private static String getCurrentJavaVendor() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.vendor");
            }
        });
    }

    public static boolean isJava17PlusSpec() {
        return JavaVersionUtil.current().majorVersion >= 17;
    }

    public static boolean isJava8() {
        return JavaVersionUtil.current().majorVersion == 8;
    }

    public static boolean isJava11() {
        return JavaVersionUtil.current().majorVersion == 11;
    }

    public static boolean isJava17() {
        return JavaVersionUtil.current().majorVersion == 17;
    }

    public static boolean isJava12PlusSpec() {
        return JavaVersionUtil.current().majorVersion >= 12;
    }

    public static boolean isJava11PlusSpec() {
        return JavaVersionUtil.current().majorVersion >= 11;
    }

    public static boolean isOracleJdk() {
        return JavaVersionHolder.CURRENT_VENDOR != null && JavaVersionHolder.CURRENT_VENDOR.startsWith("Oracle");
    }

    public static JavaVersion current() {
        return JavaVersionHolder.CURRENT_VERSION;
    }

    public static boolean higherThanOrEquals(JavaVersion javaVersion) {
        return JavaVersionUtil.current().compare(javaVersion) >= 0;
    }

    public static boolean lowerThanOrEquals(JavaVersion javaVersion) {
        return JavaVersionUtil.current().compare(javaVersion) <= 0;
    }

    public static boolean equals(JavaVersion javaVersion) {
        return JavaVersionUtil.current().compare(javaVersion) == 0;
    }

    private static class JavaVersion {
        private final int majorVersion;
        private final int minorVersion;
        private final int[] versions;

        private JavaVersion(int majorVersion, int minorVersion, int[] versions) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.versions = versions;
        }

        private JavaVersion(int majorVersion, int minorVersion) {
            this(majorVersion, minorVersion, new int[]{majorVersion, 0, minorVersion, 0});
        }

        public int compare(JavaVersion javaVersion) {
            for (int i = 0; i < this.versions.length; ++i) {
                if (this.versions[i] > javaVersion.versions[i]) {
                    return 1;
                }
                if (this.versions[i] >= javaVersion.versions[i]) continue;
                return -1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.majorVersion <= 8) {
                stringBuilder.append("1");
                for (int i = 0; i < this.versions.length - 2; ++i) {
                    stringBuilder.append(".");
                    stringBuilder.append(this.versions[i]);
                }
                stringBuilder.append("_");
                stringBuilder.append(this.versions[this.versions.length - 2]);
                return stringBuilder.toString();
            }
            for (int i = 0; i < this.versions.length - 1; ++i) {
                stringBuilder.append(".");
                stringBuilder.append(this.versions[i]);
            }
            if (this.versions[this.versions.length - 1] != 0) {
                stringBuilder.append(".");
                stringBuilder.append(this.versions[this.versions.length - 1]);
            }
            return stringBuilder.substring(1);
        }
    }

    private static class JavaVersionHolder {
        private static final JavaVersion CURRENT_VERSION = JavaVersionHolder.getCurrentJavaVersion();
        private static final String CURRENT_VENDOR = JavaVersionUtil.access$000();

        private JavaVersionHolder() {
        }

        private static JavaVersion getCurrentJavaVersion() {
            String versionStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.version");
                }
            });
            if (versionStr == null) {
                return new JavaVersion(8, 302);
            }
            versionStr = versionStr.split("-")[0];
            int[] newVersions = new int[4];
            String ch = "_";
            if (versionStr.contains(ch)) {
                String[] items = versionStr.split(ch);
                int[] versions = JavaVersionHolder.getVersions(items[0]);
                System.arraycopy(versions, 1, newVersions, 0, 2);
                newVersions[2] = Integer.parseInt(items[1]);
            } else {
                int[] versions = JavaVersionHolder.getVersions(versionStr);
                System.arraycopy(versions, 0, newVersions, 0, versions.length);
            }
            return new JavaVersion(newVersions[0], newVersions[2], newVersions);
        }

        private static int[] getVersions(String versionStr) {
            String[] components = versionStr.split("\\.");
            int[] version = new int[components.length];
            for (int i = 0; i < components.length; ++i) {
                version[i] = Integer.parseInt(components[i]);
            }
            return version;
        }

        private static boolean isOracleJdk() {
            String currentJavaVendor = JavaVersionUtil.getCurrentJavaVendor();
            return currentJavaVendor != null && currentJavaVendor.startsWith("Oracle");
        }
    }
}

