/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4.mode;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.openeuler.BGMJCEProvider;
import org.openeuler.sm4.SM4Util;
import org.openeuler.sm4.StreamModeBaseCipher;

public class CTR
extends StreamModeBaseCipher {
    @Override
    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec = null;
        String paramType = null;
        if (params != null) {
            try {
                paramType = "IV";
                spec = params.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: " + paramType + " expected");
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key);
        if (params == null) {
            if (this.opmode == 1) {
                if (random == null) {
                    random = BGMJCEProvider.getRandom();
                }
                this.iv = new byte[16];
                random.nextBytes(this.iv);
            } else if (this.opmode == 2) {
                throw new InvalidAlgorithmParameterException("need an IV");
            }
        } else {
            if (!(params instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
            IvParameterSpec param = (IvParameterSpec)params;
            if (param.getIV().length < 8 || param.getIV().length > 16) {
                throw new InvalidAlgorithmParameterException("IV must be 8-16 bytes long.");
            }
            this.iv = param.getIV();
        }
        SM4Util.copyArray(this.iv, 0, this.iv.length, this.counter, 0);
        this.isInitialized = true;
    }

    @Override
    public int engineGetOutputSize(int inputLen) {
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            return inputLen;
        }
        if (this.opmode == 1) {
            if (inputLen % 16 == 0) {
                return inputLen + 16;
            }
            return inputLen + 16 - inputLen % 16;
        }
        if (this.opmode == 2) {
            if (inputLen % 16 != 0) {
                return 0;
            }
            return inputLen;
        }
        return 0;
    }

    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        if (input == null || inputLen == 0) {
            return null;
        }
        this.inputUpdate = input;
        this.inputLenUpdate = inputLen;
        this.inputOffsetUpdate = inputOffset;
        byte[] res = null;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            if (inputLen < 16) {
                this.len = 0;
                return null;
            }
            this.len = inputLen - inputLen % 16;
        } else {
            if (inputLen <= 16) {
                this.len = 0;
                return null;
            }
            this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
        }
        res = new byte[this.len];
        this.processCTR(input, inputOffset, this.len, res, 0);
        return res;
    }

    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        if (input == null || inputLen == 0) {
            return 0;
        }
        this.inputUpdate = input;
        this.inputLenUpdate = inputLen;
        this.inputOffsetUpdate = inputOffset;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            if (inputLen < 16) {
                this.len = 0;
                return 0;
            }
            this.len = inputLen - inputLen % 16;
        } else {
            if (inputLen <= 16) {
                this.len = 0;
                return 0;
            }
            this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
        }
        if (outputOffset + this.len > output.length) {
            throw new ShortBufferException();
        }
        this.processCTR(input, inputOffset, this.len, output, outputOffset);
        return this.len;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        byte[] res = null;
        int restLen = this.inputLenUpdate - this.len;
        if (this.opmode == 1) {
            int length = this.engineGetOutputSize(restLen + inputLen);
            res = new byte[length];
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, res, 0);
            } else if (restLen == 16) {
                this.processCTR(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, res, 0);
                this.encrypt(input, inputOffset, inputLen, res, 16);
            } else if (16 - restLen > inputLen) {
                byte[] block = new byte[inputLen + restLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, block, restLen);
                this.encrypt(block, 0, block.length, res, 0);
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                this.processCTR(block, 0, 16, res, 0);
                this.encrypt(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, res, 16);
            }
        } else if (this.opmode == 2) {
            byte[] tem = new byte[inputLen + this.inputLenUpdate - this.len];
            if (restLen == 0) {
                if (inputLen == 0) {
                    this.reset();
                    return res;
                }
                this.decrypt(input, inputOffset, inputLen, tem, 0);
            } else if (restLen == 16) {
                if (inputLen == 0) {
                    this.decrypt(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, tem, 0);
                } else {
                    this.processCTR(this.inputUpdate, this.inputOffsetUpdate + this.len, 16, tem, 0);
                    this.decrypt(input, inputOffset, inputLen, tem, 16);
                }
            } else if (inputLen <= 16 - restLen) {
                byte[] block = new byte[inputLen + restLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, block, restLen);
                this.decrypt(block, 0, block.length, tem, 0);
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                this.processCTR(block, 0, 16, tem, 0);
                this.decrypt(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, tem, 16);
            }
            res = this.padding.getPadding().toUpperCase().equals("NOPADDING") ? tem : this.padding.recover(tem);
        }
        this.reset();
        return res;
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        byte[] bytes = this.engineDoFinal(input, inputOffset, inputLen);
        if (bytes != null) {
            if (outputOffset + bytes.length > output.length) {
                throw new ShortBufferException("buffer is too short.");
            }
            SM4Util.copyArray(bytes, 0, bytes.length, output, outputOffset);
            return bytes.length;
        }
        return 0;
    }

    private void encrypt(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            byte[] xor;
            byte[] encrypt;
            int i = inputOffset;
            while (i + 16 <= inputOffset + inputLen) {
                encrypt = null;
                xor = null;
                encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.incrementCount();
                xor = this.sm4.xor(encrypt, 0, 16, input, i, 16);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
                i += 16;
            }
            if (inputLen % 16 != 0) {
                encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.incrementCount();
                xor = this.sm4.xor(encrypt, 0, 16, input, i, inputLen % 16);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
            }
        } else {
            byte[] xor;
            byte[] encrypt;
            int i = inputOffset;
            while (i + 16 <= inputOffset + inputLen) {
                byte[] encrypt2 = null;
                byte[] xor2 = null;
                encrypt2 = this.sm4.encrypt(this.rk, this.counter, 0);
                this.incrementCount();
                xor2 = this.sm4.xor(encrypt2, 0, 16, input, i, 16);
                SM4Util.copyArray(xor2, 0, xor2.length, output, outputOffset + i - inputOffset);
                i += 16;
            }
            if (inputLen % 16 != 0) {
                byte[] fill = this.padding.fill(input, i, inputLen % 16);
                encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.incrementCount();
                xor = this.sm4.xor(encrypt, 0, 16, fill, 0, 16);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
            }
            if (inputLen % 16 == 0 && !this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
                byte[] block = new byte[16];
                Arrays.fill(block, (byte)16);
                encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.incrementCount();
                xor = this.sm4.xor(encrypt, block);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
            }
        }
    }

    private void decrypt(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            byte[] xor;
            byte[] encrypt;
            int i = inputOffset;
            while (i + 16 <= inputOffset + inputLen) {
                encrypt = null;
                xor = null;
                encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.incrementCount();
                xor = this.sm4.xor(encrypt, 0, 16, input, i, 16);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
                i += 16;
            }
            if (inputLen % 16 != 0) {
                encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.incrementCount();
                xor = this.sm4.xor(encrypt, 0, 16, input, i, inputLen % 16);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
            }
        } else {
            this.processCTR(input, inputOffset, inputLen, output, outputOffset);
        }
    }

    private void incrementCount() {
        int r;
        for (r = this.counter.length - 1; r >= 0; --r) {
            try {
                this.counter[r] = this.increment(r);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (r == -1) {
            for (int i = 0; i < this.counter.length; ++i) {
                this.counter[i] = 0;
            }
        }
    }

    private byte increment(int index) throws Exception {
        int i;
        for (i = 0; i < 8 && (1 << i & this.counter[index]) != 0; ++i) {
        }
        if (i == 8) {
            throw new Exception();
        }
        this.counter[index] = (byte)(1 << i | this.counter[index]);
        int t = 0;
        for (int j = 7; j >= i; --j) {
            t |= 1 << j;
        }
        for (int k = index + 1; k < this.counter.length; ++k) {
            this.counter[k] = 0;
        }
        return (byte)(t & this.counter[index]);
    }

    private void processCTR(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int i = inputOffset;
        while (i + 16 <= inputLen + inputOffset) {
            byte[] encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
            this.incrementCount();
            byte[] xor = this.sm4.xor(encrypt, 0, 16, input, i, 16);
            SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
            i += 16;
        }
    }

    @Override
    public void reset() {
        this.inputUpdate = null;
        this.inputLenUpdate = 0;
        this.len = 0;
        System.arraycopy(this.iv, 0, this.counter, 0, this.iv.length);
        for (int i = this.iv.length; i < this.counter.length; ++i) {
            this.counter[i] = 0;
        }
    }
}

