/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.util.Arrays;
import java.util.List;
import org.openeuler.com.sun.crypto.provider.SymmetricCipher;

public class OCBHash {
    private byte[] l_sterisk;
    private List<byte[]> l;
    private byte[] sumBlock;
    private byte[] offsetBlock;
    private byte[] aadBlock;
    private int aadBlockPos;
    private int aadBlockCount;
    private SymmetricCipher embeddedCipher;
    private int blockSize;
    private byte[] sumBlockSave;
    private byte[] offsetBlockSave;
    private byte[] aadBlockSave;
    private int aadBlockPosSave;
    private int aadBlockCountSave;

    OCBHash(SymmetricCipher embeddedCipher) {
        this.embeddedCipher = embeddedCipher;
    }

    void init(byte[] l_sterisk, List<byte[]> l) {
        this.l_sterisk = l_sterisk;
        this.l = l;
        this.blockSize = this.embeddedCipher.getBlockSize();
        this.sumBlock = new byte[this.blockSize];
        this.offsetBlock = new byte[this.blockSize];
        this.aadBlock = new byte[this.blockSize];
        this.aadBlockPos = 0;
        this.aadBlockCount = 0;
    }

    void update(byte[] src, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            this.aadBlock[this.aadBlockPos++] = src[offset + i];
            if (this.aadBlockPos != this.aadBlock.length) continue;
            this.processHash();
        }
    }

    byte[] digest() {
        if (this.aadBlockPos == 0) {
            return this.sumBlock;
        }
        OCBHash.ocb_extend(this.aadBlock, this.aadBlockPos);
        this.updateHash(this.l_sterisk);
        return this.sumBlock;
    }

    void save() {
        this.sumBlockSave = Arrays.copyOf(this.sumBlock, this.sumBlock.length);
        this.offsetBlockSave = Arrays.copyOf(this.offsetBlock, this.offsetBlock.length);
        this.aadBlockSave = Arrays.copyOf(this.aadBlock, this.aadBlock.length);
        this.aadBlockPosSave = this.aadBlockPos;
        this.aadBlockCountSave = this.aadBlockCount;
    }

    void restore() {
        System.arraycopy(this.sumBlockSave, 0, this.sumBlock, 0, this.sumBlock.length);
        System.arraycopy(this.offsetBlockSave, 0, this.offsetBlock, 0, this.offsetBlock.length);
        System.arraycopy(this.aadBlockSave, 0, this.aadBlock, 0, this.aadBlock.length);
        this.aadBlockPos = this.aadBlockPosSave;
        this.aadBlockCount = this.aadBlockCountSave;
    }

    void reset() {
        Arrays.fill(this.sumBlock, (byte)0);
        Arrays.fill(this.offsetBlock, (byte)0);
        Arrays.fill(this.aadBlock, (byte)0);
        this.aadBlockPos = 0;
        this.aadBlockCount = 0;
    }

    private void processHash() {
        ++this.aadBlockCount;
        byte[] lSub = OCBHash.getLSub(this.l, OCBHash.ocb_ntz(this.aadBlockCount));
        this.updateHash(lSub);
        this.aadBlockPos = 0;
    }

    private void updateHash(byte[] lSub) {
        OCBHash.xor(this.offsetBlock, lSub);
        OCBHash.xor(this.aadBlock, this.offsetBlock);
        this.embeddedCipher.encryptBlock(this.aadBlock, 0, this.aadBlock, 0);
        OCBHash.xor(this.sumBlock, this.aadBlock);
    }

    static byte[] getLSub(List<byte[]> list, int index) {
        for (int limit = list.size() - 1; index > limit; ++limit) {
            byte[] l_size = OCBHash.ocb_double(list.get(limit));
            list.add(l_size);
        }
        return list.get(index);
    }

    static int ocb_ntz(int n) {
        return Integer.numberOfTrailingZeros(n);
    }

    static byte[] ocb_double(byte[] block) {
        byte[] result = new byte[block.length];
        int bit = 0;
        for (int i = block.length - 1; i >= 0; --i) {
            int b = block[i] & 0xFF;
            result[i] = (byte)(b << 1 | bit);
            bit = b >>> 7 & 1;
        }
        int n = result.length - 1;
        result[n] = (byte)(result[n] ^ (byte)(135 >>> (1 - bit << 3)));
        return result;
    }

    static void xor(byte[] block, byte[] values) {
        int len = Math.min(block.length, values.length);
        for (int i = 0; i < len; ++i) {
            int n = i;
            block[n] = (byte)(block[n] ^ values[i]);
        }
    }

    static void ocb_extend(byte[] block, int pos) {
        block[pos] = -128;
        while (++pos < block.length) {
            block[pos] = 0;
        }
    }
}

