/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.legacy;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.GMCipherSpi;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.openeuler.com.sun.crypto.provider.ConstructKeys;

public class SM2Cipher
extends GMCipherSpi {
    private static final boolean DEBUG = false;

    public SM2Cipher() {
        super((SM2Engine)new DerSM2Engine());
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
        }
        try {
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Wrapping failed", e);
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] unWrappedKey;
        if (wrappedKey == null || wrappedKey.length == 0) {
            throw new InvalidKeyException("The wrappedKey cannot be null or empty");
        }
        try {
            unWrappedKey = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
        return ConstructKeys.constructKey((byte[])unWrappedKey, (String)wrappedKeyAlgorithm, (int)wrappedKeyType);
    }

    public int engineGetOutputSize(int i) {
        throw new UnsupportedOperationException("engineGetOutputSize");
    }

    private static class DerSM2Engine
    extends SM2Engine {
        private boolean forEncryption;
        private final int digestLength;
        private ECDomainParameters ecDomainParameters;

        public DerSM2Engine() {
            this((Digest)new SM3Digest());
        }

        public DerSM2Engine(Digest digest) {
            super(digest, SM2Engine.Mode.C1C3C2);
            this.digestLength = digest.getDigestSize();
        }

        public void init(boolean forEncryption, CipherParameters param) {
            ECKeyParameters ecKeyParameters;
            super.init(forEncryption, param);
            this.forEncryption = forEncryption;
            if (this.forEncryption) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                ecKeyParameters = (ECKeyParameters)rParam.getParameters();
            } else {
                ecKeyParameters = (ECKeyParameters)param;
            }
            this.ecDomainParameters = ecKeyParameters.getParameters();
        }

        public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
            if (this.forEncryption) {
                return this.encrypt(in, inOff, inLen);
            }
            return this.decrypt(in, inOff, inLen);
        }

        private byte[] encrypt(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
            byte[] bytes = super.processBlock(in, inOff, inLen);
            int curveLength = (this.ecDomainParameters.getCurve().getFieldSize() + 7) / 8;
            byte[] c1 = new byte[curveLength * 2 + 1];
            System.arraycopy(bytes, 0, c1, 0, c1.length);
            ECPoint c1Point = this.ecDomainParameters.getCurve().decodePoint(c1);
            byte[] c2 = new byte[bytes.length - c1.length - this.digestLength];
            System.arraycopy(bytes, c1.length + this.digestLength, c2, 0, c2.length);
            byte[] c3 = new byte[this.digestLength];
            System.arraycopy(bytes, c1.length, c3, 0, c3.length);
            DERSequence derSequence = new DERSequence(new ASN1Encodable[]{new ASN1Integer(c1Point.getAffineXCoord().toBigInteger()), new ASN1Integer(c1Point.getAffineYCoord().toBigInteger()), new DEROctetString(c3), new DEROctetString(c2)});
            try {
                return derSequence.getEncoded();
            }
            catch (IOException e) {
                throw new InvalidCipherTextException("DERSequence getEncoded failed", (Throwable)e);
            }
        }

        private byte[] decrypt(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
            byte[] bytes = new byte[inLen];
            System.arraycopy(in, inOff, bytes, 0, inLen);
            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)bytes);
            this.check(asn1Sequence);
            BigInteger x = ((ASN1Integer)asn1Sequence.getObjectAt(0)).getPositiveValue();
            BigInteger y = ((ASN1Integer)asn1Sequence.getObjectAt(1)).getPositiveValue();
            ECPoint c1Point = this.ecDomainParameters.getCurve().createPoint(x, y);
            byte[] c1 = c1Point.getEncoded(false);
            byte[] c2 = ((ASN1OctetString)asn1Sequence.getObjectAt(3)).getOctets();
            byte[] c3 = ((ASN1OctetString)asn1Sequence.getObjectAt(2)).getOctets();
            byte[] concatenate = Arrays.concatenate((byte[])c1, (byte[])c3, (byte[])c2);
            return super.processBlock(concatenate, 0, concatenate.length);
        }

        private void check(ASN1Sequence asn1Sequence) throws InvalidCipherTextException {
            if (asn1Sequence.size() != 4) {
                throw new InvalidCipherTextException("ASN1Sequence size is not equal 4");
            }
            if (!(asn1Sequence.getObjectAt(0) instanceof ASN1Integer)) {
                throw new InvalidCipherTextException("The c1.x object type is not ASN1Integer");
            }
            if (!(asn1Sequence.getObjectAt(1) instanceof ASN1Integer)) {
                throw new InvalidCipherTextException("The c1.y object type is not ASN1Integer");
            }
            if (!(asn1Sequence.getObjectAt(2) instanceof ASN1OctetString)) {
                throw new InvalidCipherTextException("The c3 object type is not ASN1OctetString");
            }
            if (!(asn1Sequence.getObjectAt(3) instanceof ASN1OctetString)) {
                throw new InvalidCipherTextException("The c2 object type is not ASN1OctetString");
            }
        }
    }
}

