/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4;

import org.openeuler.util.Util;

public class SM4Util {
    private static final byte[] S_BOX = new byte[]{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5, 43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103, -100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98, -28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90, 71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88, 104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53, 30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121, -44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98, -22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95, -32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29, 29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111, -43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81, -115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40, 10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80, -119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124, 24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72};
    private static final int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};
    private static final int[] FK = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
    private final int BLOCK_SIZE = 16;

    private int tau(int input) {
        int lowest8bit = S_BOX[input & 0xFF] & 0xFF;
        int second8bit = S_BOX[input >> 8 & 0xFF] & 0xFF;
        int third8bit = S_BOX[input >> 16 & 0xFF] & 0xFF;
        int highest8bit = S_BOX[input >> 24 & 0xFF] & 0xFF;
        return lowest8bit | (second8bit <<= 8) | (third8bit <<= 16) | (highest8bit <<= 24);
    }

    private int l(int input) {
        return input ^ (input << 2 | input >>> 30) ^ (input << 10 | input >>> 22) ^ (input << 18 | input >>> 14) ^ (input << 24 | input >>> 8);
    }

    private int _l(int input) {
        return input ^ (input << 13 | input >>> 19) ^ (input << 23 | input >>> 9);
    }

    private int t(int input) {
        return this.l(this.tau(input));
    }

    private int _t(int input) {
        return this._l(this.tau(input));
    }

    private int f(int x0, int x1, int x2, int x3, int rk0) {
        return x0 ^ this.t(x1 ^ x2 ^ x3 ^ rk0);
    }

    private byte[] reverse(int x32, int x33, int x34, int x35) {
        byte[] output = new byte[16];
        this.reverse(x32, x33, x34, x35, output, 0);
        return output;
    }

    private void reverse(int x32, int x33, int x34, int x35, byte[] output, int outputOffset) {
        this.intToBigEndian(output, x35, outputOffset);
        this.intToBigEndian(output, x34, 4 + outputOffset);
        this.intToBigEndian(output, x33, 8 + outputOffset);
        this.intToBigEndian(output, x32, 12 + outputOffset);
    }

    public void intToBigEndian(byte[] output, int x, int start) {
        Util.intToBigEndian(x, output, start);
    }

    public int bigEndianToInt(byte[] bytes, int start) {
        return Util.bigEndianToInt(bytes, start);
    }

    public int[] expandKey(byte[] key) {
        int[] rk = new int[32];
        int K0 = this.bigEndianToInt(key, 0) ^ FK[0];
        int K1 = this.bigEndianToInt(key, 4) ^ FK[1];
        int K2 = this.bigEndianToInt(key, 8) ^ FK[2];
        int K3 = this.bigEndianToInt(key, 12) ^ FK[3];
        for (int i = 0; i < rk.length; ++i) {
            rk[i] = K0 ^ this._t(K1 ^ K2 ^ K3 ^ CK[i]);
            K0 = K1;
            K1 = K2;
            K2 = K3;
            K3 = rk[i];
        }
        return rk;
    }

    public byte[] encrypt(int[] rk, byte[] input) {
        byte[] res = new byte[16];
        this.encrypt(rk, input, 0, res, 0);
        return res;
    }

    public byte[] encrypt(int[] rk, byte[] input, int inputOffset) {
        byte[] res = new byte[16];
        this.encrypt(rk, input, inputOffset, res, 0);
        return res;
    }

    public void encrypt(int[] rk, byte[] input, int inputOffset, byte[] output, int outputOffset) {
        int x0 = this.bigEndianToInt(input, inputOffset);
        int x1 = this.bigEndianToInt(input, 4 + inputOffset);
        int x2 = this.bigEndianToInt(input, 8 + inputOffset);
        int x3 = this.bigEndianToInt(input, 12 + inputOffset);
        for (int i = 0; i < rk.length; ++i) {
            int res = this.f(x0, x1, x2, x3, rk[i]);
            x0 = x1;
            x1 = x2;
            x2 = x3;
            x3 = res;
        }
        this.reverse(x0, x1, x2, x3, output, outputOffset);
    }

    public byte[] decrypt(int[] rk, byte[] cipherText) {
        byte[] res = new byte[16];
        this.decrypt(rk, cipherText, 0, res, 0);
        return res;
    }

    public byte[] decrypt(int[] rk, byte[] input, int inputOffset) {
        byte[] res = new byte[16];
        this.decrypt(rk, input, inputOffset, res, 0);
        return res;
    }

    public void decrypt(int[] rk, byte[] input, int inputOffset, byte[] output, int outputOffset) {
        int x0 = this.bigEndianToInt(input, inputOffset);
        int x1 = this.bigEndianToInt(input, 4 + inputOffset);
        int x2 = this.bigEndianToInt(input, 8 + inputOffset);
        int x3 = this.bigEndianToInt(input, 12 + inputOffset);
        for (int i = rk.length - 1; i >= 0; --i) {
            int res = this.f(x0, x1, x2, x3, rk[i]);
            x0 = x1;
            x1 = x2;
            x2 = x3;
            x3 = res;
        }
        this.reverse(x0, x1, x2, x3, output, outputOffset);
    }

    public byte[] xor(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null) {
            return null;
        }
        byte[] res = new byte[Math.min(b1.length, b2.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(b1[i] ^ b2[i]);
        }
        return res;
    }

    public byte[] xor(byte[] b1, int from1, int len1, byte[] b2, int from2, int len2) {
        if (b1 == null || b2 == null) {
            return null;
        }
        byte[] res = new byte[Math.min(len1, len2)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(b1[i + from1] ^ b2[i + from2]);
        }
        return res;
    }

    public byte[] xor16Byte(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null) {
            return null;
        }
        if (b1.length != 16 && b2.length != 16) {
            return null;
        }
        byte[] res = new byte[16];
        int len = Math.min(b1.length, b2.length);
        for (int i = 0; i < len; ++i) {
            res[i] = (byte)(b1[i] ^ b2[i]);
        }
        if (b1.length != b2.length) {
            int longLen = len == b1.length ? b2.length : b1.length;
            byte[] longArr = longLen == b1.length ? b1 : b2;
            System.arraycopy(longArr, len, res, len, longLen - len);
        }
        return res;
    }

    public static void copyArray(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        System.arraycopy(input, inputOffset, output, outputOffset, inputLen);
    }
}

