/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLKeyAgreementGenerator;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLMasterKeyDerivation;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLPossessionGenerator;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.util.KeyUtil;

final class ECCKeyExchange {
    static final SSLPossessionGenerator poGenerator = new ECCPossessionGenerator();
    static final SSLKeyAgreementGenerator kaGenerator = new ECCKAGenerator();

    ECCKeyExchange() {
    }

    private static final class ECCKAGenerator
    implements SSLKeyAgreementGenerator {
        private ECCKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            ECCPremasterSecret premaster = null;
            if (context instanceof ClientHandshakeContext) {
                for (SSLPossession possession : context.handshakePossessions) {
                    if (!(possession instanceof ECCPremasterSecret)) continue;
                    premaster = (ECCPremasterSecret)possession;
                    break;
                }
            } else {
                for (SSLCredentials credential : context.handshakeCredentials) {
                    if (!(credential instanceof ECCPremasterSecret)) continue;
                    premaster = (ECCPremasterSecret)credential;
                    break;
                }
            }
            if (premaster == null) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient ECC key agreement parameters negotiated");
            }
            return new ECCKAKeyDerivation(context, premaster.premasterSecret);
        }

        private static final class ECCKAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final SecretKey preMasterSecret;

            ECCKAKeyDerivation(HandshakeContext context, SecretKey preMasterSecret) {
                this.context = context;
                this.preMasterSecret = preMasterSecret;
            }

            @Override
            public SecretKey deriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
                SSLMasterKeyDerivation mskd = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (mskd == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation kd = mskd.createKeyDerivation(this.context, this.preMasterSecret);
                return kd.deriveKey("MasterSecret", params);
            }
        }
    }

    static final class ECCPremasterSecret
    implements SSLPossession,
    SSLCredentials {
        final SecretKey premasterSecret;

        ECCPremasterSecret(SecretKey premasterSecret) {
            this.premasterSecret = premasterSecret;
        }

        byte[] getEncoded(PublicKey publicKey, SecureRandom secureRandom) throws GeneralSecurityException {
            Cipher cipher = JsseJce.getCipher("SM2");
            cipher.init(3, (Key)publicKey, secureRandom);
            return cipher.wrap(this.premasterSecret);
        }

        static ECCPremasterSecret createPremasterSecret(ClientHandshakeContext chc) throws GeneralSecurityException {
            String algorithm = "SunTlsRsaPremasterSecret";
            KeyGenerator kg = JsseJce.getKeyGenerator(algorithm);
            TlsRsaPremasterSecretParameterSpec spec = new TlsRsaPremasterSecretParameterSpec(chc.clientHelloVersion, chc.negotiatedProtocol.id);
            kg.init(spec, chc.sslContext.getSecureRandom());
            return new ECCPremasterSecret(kg.generateKey());
        }

        static ECCPremasterSecret decode(ServerHandshakeContext shc, PrivateKey privateKey, byte[] encrypted) throws GeneralSecurityException {
            SecretKey preMaster;
            byte[] encoded = null;
            boolean needFailover = false;
            Cipher cipher = JsseJce.getCipher("SM2");
            try {
                cipher.init(4, (Key)privateKey, new TlsRsaPremasterSecretParameterSpec(shc.clientHelloVersion, shc.negotiatedProtocol.id), shc.sslContext.getSecureRandom());
                String providerName = cipher.getProvider().getName();
                needFailover = !KeyUtil.isOracleJCEProvider(providerName) && !providerName.equals("BGMJCEProvider");
            }
            catch (UnsupportedOperationException | InvalidKeyException iue) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("The Cipher provider " + ECCPremasterSecret.safeProviderName(cipher) + " caused exception: " + iue.getMessage(), new Object[0]);
                }
                needFailover = true;
            }
            if (needFailover) {
                cipher = JsseJce.getCipher("SM2");
                cipher.init(2, privateKey);
                boolean failed = false;
                try {
                    encoded = cipher.doFinal(encrypted);
                }
                catch (BadPaddingException bpe) {
                    failed = true;
                }
                encoded = KeyUtil.checkTlsPreMasterSecretKey(shc.clientHelloVersion, shc.negotiatedProtocol.id, shc.sslContext.getSecureRandom(), encoded, failed);
                preMaster = ECCPremasterSecret.generatePremasterSecret(shc.clientHelloVersion, shc.negotiatedProtocol.id, encoded, shc.sslContext.getSecureRandom());
            } else {
                preMaster = (SecretKey)cipher.unwrap(encrypted, "TlsRsaPremasterSecret", 3);
            }
            return new ECCPremasterSecret(preMaster);
        }

        private static String safeProviderName(Cipher cipher) {
            try {
                return cipher.getProvider().toString();
            }
            catch (Exception e) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Retrieving The Cipher provider name caused exception ", e);
                }
                try {
                    return ((Object)cipher).toString() + " (provider name not available)";
                }
                catch (Exception e2) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("Retrieving The Cipher name caused exception ", e2);
                    }
                    return "(cipher/provider names not available)";
                }
            }
        }

        private static SecretKey generatePremasterSecret(int clientVersion, int serverVersion, byte[] encodedSecret, SecureRandom generator) throws GeneralSecurityException {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Generating a premaster secret", new Object[0]);
            }
            try {
                String s = clientVersion >= ProtocolVersion.TLS12.id ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
                KeyGenerator kg = JsseJce.getKeyGenerator(s);
                kg.init(new TlsRsaPremasterSecretParameterSpec(clientVersion, serverVersion, encodedSecret), generator);
                return kg.generateKey();
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException iae) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("ECC premaster secret generation error:", new Object[0]);
                    iae.printStackTrace(System.out);
                }
                throw new GeneralSecurityException("Could not generate premaster secret", iae);
            }
        }
    }

    private static final class ECCPossessionGenerator
    implements SSLPossessionGenerator {
        private ECCPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            return null;
        }
    }
}

