/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import org.openeuler.sun.misc.HexDumpEncoder;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.ConnectionContext;
import org.openeuler.sun.security.ssl.GMX509Authentication;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.HandshakeOutStream;
import org.openeuler.sun.security.ssl.HandshakeProducer;
import org.openeuler.sun.security.ssl.Record;
import org.openeuler.sun.security.ssl.SSLConsumer;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLHandshake;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;
import org.openeuler.sun.security.ssl.SignatureScheme;
import org.openeuler.sun.security.ssl.Utilities;

final class ECCServerKeyExchange {
    static final SSLConsumer eccHandshakeConsumer = new ECCServerKeyExchangeConsumer();
    static final HandshakeProducer eccHandshakeProducer = new ECCServerKeyExchangeProducer();

    ECCServerKeyExchange() {
    }

    private static final class ECCServerKeyExchangeConsumer
    implements SSLConsumer {
        private ECCServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            ECCServerKeyExchangeMessage skem = new ECCServerKeyExchangeMessage((HandshakeContext)chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECC ServerKeyExchange handshake message", skem);
            }
        }
    }

    private static final class ECCServerKeyExchangeProducer
    implements HandshakeProducer {
        private ECCServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            SSLPossession possession;
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            GMX509Authentication.GMX509Possession gmx509Possession = null;
            Iterator iterator = shc.handshakePossessions.iterator();
            while (iterator.hasNext() && (!((possession = (SSLPossession)iterator.next()) instanceof GMX509Authentication.GMX509Possession) || (gmx509Possession = (GMX509Authentication.GMX509Possession)possession) == null)) {
            }
            if (gmx509Possession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No ECC certificate negotiated for server key exchange");
            }
            ECCServerKeyExchangeMessage skem = new ECCServerKeyExchangeMessage(shc, gmx509Possession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECC ServerKeyExchange handshake message", skem);
            }
            skem.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class ECCServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] paramsSignature;
        private final boolean useExplicitSigAlgorithm;
        private final SignatureScheme signatureScheme;

        private ECCServerKeyExchangeMessage(HandshakeContext handshakeContext, GMX509Authentication.GMX509Possession gmx509Possession) throws IOException {
            super(handshakeContext);
            byte[] signature;
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            this.useExplicitSigAlgorithm = shc.t12WithGMCipherSuite;
            if (this.useExplicitSigAlgorithm) {
                if (shc.peerRequestedSignatureSchemes == null || !shc.peerRequestedSignatureSchemes.contains((Object)SignatureScheme.ECDSA_SM3)) {
                    throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No supported signature algorithm");
                }
                this.signatureScheme = SignatureScheme.ECDSA_SM3;
            } else {
                this.signatureScheme = null;
            }
            try {
                Signature signer = Signature.getInstance("SM3withSM2");
                signer.initSign(gmx509Possession.popSignPrivateKey, shc.sslContext.getSecureRandom());
                this.updateSignature(signer, shc.clientHelloRandom.randomBytes, shc.serverHelloRandom.randomBytes, gmx509Possession.popEncCerts[0]);
                signature = signer.sign();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign ECC parameters", ex);
            }
            this.paramsSignature = signature;
        }

        ECCServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            ClientHandshakeContext chc = (ClientHandshakeContext)handshakeContext;
            GMX509Authentication.GMX509Credentials gmx509Credentials = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof GMX509Authentication.GMX509Credentials)) continue;
                gmx509Credentials = (GMX509Authentication.GMX509Credentials)cd;
                break;
            }
            if (gmx509Credentials == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No ECC credentials negotiated for server key exchange");
            }
            this.useExplicitSigAlgorithm = chc.t12WithGMCipherSuite;
            if (this.useExplicitSigAlgorithm) {
                int ssid = Record.getInt16(m);
                this.signatureScheme = SignatureScheme.valueOf(ssid);
                if (this.signatureScheme == null || this.signatureScheme != SignatureScheme.ECDSA_SM3) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + ssid + ") used in ECC ServerKeyExchange handshake message");
                }
                if (!chc.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in ECC ServerKeyExchange handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            this.paramsSignature = Record.getBytes16(m);
            try {
                Signature signer = Signature.getInstance("SM3withSM2");
                signer.initVerify(gmx509Credentials.popSignPublicKey);
                this.updateSignature(signer, chc.clientHelloRandom.randomBytes, chc.serverHelloRandom.randomBytes, gmx509Credentials.popEncCerts[0]);
                if (!signer.verify(this.paramsSignature)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature of ECC ServerKeyExchange message");
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign ECC parameters", ex);
            }
        }

        @Override
        SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        int messageLength() {
            int sigLen = 2 + this.paramsSignature.length;
            if (this.useExplicitSigAlgorithm) {
                sigLen += SignatureScheme.sizeInRecord();
            }
            return sigLen;
        }

        @Override
        void send(HandshakeOutStream hos) throws IOException {
            if (this.useExplicitSigAlgorithm) {
                hos.putInt16(this.signatureScheme.id);
            }
            hos.putBytes16(this.paramsSignature);
        }

        public String toString() {
            if (this.useExplicitSigAlgorithm) {
                MessageFormat messageFormat = new MessageFormat("\"ECDH ServerKeyExchange\": '{'\n  \"digital signature\":  '{'\n    \"signature algorithm\": \"{0}\"\n    \"signature\": '{'\n{1}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{this.signatureScheme.name, Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "      ")};
                return messageFormat.format(messageFields);
            }
            MessageFormat messageFormat = new MessageFormat("\"ECC ServerKeyExchange\": '{'\n  \"digital signature\":  '{'\n    \"signature\": '{'\n{0}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "      ")};
            return messageFormat.format(messageFields);
        }

        private void updateSignature(Signature signature, byte[] clntNonce, byte[] svrNonce, X509Certificate enc) throws SignatureException {
            byte[] encoded;
            signature.update(clntNonce);
            signature.update(svrNonce);
            try {
                encoded = enc.getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new SignatureException(e);
            }
            int len = encoded.length;
            signature.update((byte)(len >> 16 & 0xFF));
            signature.update((byte)(len >> 8 & 0xFF));
            signature.update((byte)(len & 0xFF));
            signature.update(encoded);
        }
    }
}

