/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.openeuler.SM2KeyExchangeUtil;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.ConnectionContext;
import org.openeuler.sun.security.ssl.GMX509Authentication;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLKeyAgreementGenerator;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLMasterKeyDerivation;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLPossessionGenerator;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;
import org.openeuler.sun.security.ssl.SupportedGroupsExtension;
import sun.security.util.ECUtil;

final class SM2KeyExchange {
    static final SSLPossessionGenerator poGenerator = new SM2PossessionGenerator();
    static final SSLKeyAgreementGenerator sm2KAGenerator = new SM2KAGenerator();

    SM2KeyExchange() {
    }

    private static final class SM2KAKeyDerivation
    implements SSLKeyDerivation {
        private final HandshakeContext context;
        private final PrivateKey localPrivateKey;
        private final PublicKey peerPublicKey;

        SM2KAKeyDerivation(HandshakeContext context, PrivateKey localPrivateKey, PublicKey peerPublicKey) {
            this.context = context;
            this.localPrivateKey = localPrivateKey;
            this.peerPublicKey = peerPublicKey;
        }

        @Override
        public SecretKey deriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
            return this.gmtlsDeriveKey(algorithm, params);
        }

        private SecretKey gmtlsDeriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
            try {
                KeyAgreement ka = JsseJce.getKeyAgreement("SM2");
                ka.init(this.localPrivateKey, params, null);
                ka.doPhase(this.peerPublicKey, true);
                SecretKey preMasterSecret = ka.generateSecret("TlsPremasterSecret");
                SSLMasterKeyDerivation mskd = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (mskd == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation kd = mskd.createKeyDerivation(this.context, preMasterSecret);
                return kd.deriveKey("MasterSecret", params);
            }
            catch (GeneralSecurityException gse) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(gse);
            }
        }
    }

    private static final class SM2KAGenerator
    implements SSLKeyAgreementGenerator {
        private SM2KAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            SM2Possession sm2Possession = null;
            SM2Credentials sm2Credentials = null;
            for (SSLPossession poss : context.handshakePossessions) {
                if (!(poss instanceof SM2Possession)) continue;
                SupportedGroupsExtension.NamedGroup ng = ((SM2Possession)poss).namedGroup;
                for (SSLCredentials cred : context.handshakeCredentials) {
                    if (!(cred instanceof SM2Credentials) || !ng.equals((Object)((SM2Credentials)cred).namedGroup)) continue;
                    sm2Credentials = (SM2Credentials)cred;
                    break;
                }
                if (sm2Credentials == null) continue;
                sm2Possession = (SM2Possession)poss;
                break;
            }
            if (sm2Possession == null || sm2Credentials == null) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient sm2 key agreement parameters negotiated");
            }
            return new SM2KAKeyDerivation(context, sm2Possession.privateKey, sm2Credentials.popPublicKey);
        }
    }

    private static final class SM2PossessionGenerator
    implements SSLPossessionGenerator {
        private SM2PossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            SupportedGroupsExtension.NamedGroup preferableNamedGroup = null;
            ProtocolVersion protocolVersion = context.t12WithGMCipherSuite ? ProtocolVersion.GMTLS : context.negotiatedProtocol;
            preferableNamedGroup = context.clientRequestedNamedGroups != null && !context.clientRequestedNamedGroups.isEmpty() ? SupportedGroupsExtension.SupportedGroups.getPreferredGroup(protocolVersion, context.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE, context.clientRequestedNamedGroups) : SupportedGroupsExtension.SupportedGroups.getPreferredGroup(protocolVersion, context.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE);
            if (preferableNamedGroup != null) {
                return new SM2Possession(preferableNamedGroup, context.sslContext.getSecureRandom(), (ConnectionContext)context);
            }
            return null;
        }
    }

    static final class SM2Possession
    implements SSLPossession {
        final PrivateKey privateKey;
        final BCECPublicKey publicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;
        final BigInteger randomNum;

        SM2Possession(SupportedGroupsExtension.NamedGroup namedGroup, SecureRandom random, ConnectionContext context) {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            GMX509Authentication.GMX509Possession gmx509Possession = null;
            if (shc.interimAuthn instanceof GMX509Authentication.GMX509Possession) {
                gmx509Possession = (GMX509Authentication.GMX509Possession)shc.interimAuthn;
            }
            if (gmx509Possession != null) {
                this.publicKey = (BCECPublicKey)gmx509Possession.popEncCerts[0].getPublicKey();
                this.privateKey = gmx509Possession.popEncPrivateKey;
                this.randomNum = SM2KeyExchangeUtil.generateRandom((BigInteger)this.publicKey.getParameters().getN(), (SecureRandom)random);
            } else {
                this.publicKey = null;
                this.privateKey = null;
                this.randomNum = null;
            }
            this.namedGroup = namedGroup;
        }

        SM2Possession(SM2Credentials credentials, SecureRandom random, ConnectionContext context) {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            GMX509Authentication.GMX509Possession gmx509Possession = null;
            for (SSLPossession possession : chc.handshakePossessions) {
                if (!(possession instanceof GMX509Authentication.GMX509Possession)) continue;
                gmx509Possession = (GMX509Authentication.GMX509Possession)possession;
                break;
            }
            if (gmx509Possession != null) {
                this.publicKey = (BCECPublicKey)gmx509Possession.popEncCerts[0].getPublicKey();
                this.privateKey = gmx509Possession.popEncPrivateKey;
                this.randomNum = SM2KeyExchangeUtil.generateRandom((BigInteger)this.publicKey.getParameters().getN(), (SecureRandom)random);
            } else {
                this.publicKey = null;
                this.privateKey = null;
                this.randomNum = null;
            }
            this.namedGroup = credentials.namedGroup;
        }

        @Override
        public byte[] encode() {
            return ECUtil.encodePoint(this.publicKey.getW(), this.publicKey.getParams().getCurve());
        }
    }

    static final class SM2Credentials
    implements SSLCredentials {
        final ECPublicKey popPublicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;
        final byte[] peerEncodePoint;

        SM2Credentials(ECPublicKey popPublicKey, SupportedGroupsExtension.NamedGroup namedGroup, byte[] encodePoint) {
            this.popPublicKey = popPublicKey;
            this.namedGroup = namedGroup;
            this.peerEncodePoint = encodePoint;
        }
    }
}

