/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import org.openeuler.sun.security.ssl.CipherSuite;
import org.openeuler.sun.security.ssl.ClientAuthType;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.SSLConfiguration;
import org.openeuler.sun.security.ssl.SSLContextImpl;
import org.openeuler.sun.security.ssl.SSLSocketImpl;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private final SSLContextImpl sslContext;
    private final SSLConfiguration sslConfig;

    SSLServerSocketImpl(SSLContextImpl sslContext) throws IOException {
        this.sslContext = sslContext;
        this.sslConfig = new SSLConfiguration(sslContext, false);
    }

    SSLServerSocketImpl(SSLContextImpl sslContext, int port, int backlog) throws IOException {
        super(port, backlog);
        this.sslContext = sslContext;
        this.sslConfig = new SSLConfiguration(sslContext, false);
    }

    SSLServerSocketImpl(SSLContextImpl sslContext, int port, int backlog, InetAddress address) throws IOException {
        super(port, backlog, address);
        this.sslContext = sslContext;
        this.sslConfig = new SSLConfiguration(sslContext, false);
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return CipherSuite.namesOf(this.sslConfig.enabledCipherSuites);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslConfig.enabledCipherSuites = CipherSuite.validValuesOf(suites);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.sslContext.getSupportedCipherSuites());
    }

    @Override
    public String[] getSupportedProtocols() {
        return ProtocolVersion.toStringArray(this.sslContext.getSupportedProtocolVersions());
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return ProtocolVersion.toStringArray(this.sslConfig.enabledProtocols);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException("Protocols cannot be null");
        }
        this.sslConfig.enabledProtocols = ProtocolVersion.namesOf(protocols);
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslConfig.clientAuthType = need ? ClientAuthType.CLIENT_AUTH_REQUIRED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED;
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslConfig.clientAuthType = want ? ClientAuthType.CLIENT_AUTH_REQUESTED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUESTED;
    }

    @Override
    public synchronized void setUseClientMode(boolean useClientMode) {
        if (this.sslConfig.isClientMode != useClientMode) {
            if (this.sslContext.isDefaultProtocolVesions(this.sslConfig.enabledProtocols)) {
                this.sslConfig.enabledProtocols = this.sslContext.getDefaultProtocolVersions(!useClientMode);
            }
            if (this.sslContext.isDefaultCipherSuiteList(this.sslConfig.enabledCipherSuites)) {
                this.sslConfig.enabledCipherSuites = this.sslContext.getDefaultCipherSuites(!useClientMode);
            }
            this.sslConfig.toggleClientMode();
        }
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.sslConfig.isClientMode;
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.sslConfig.enableSessionCreation = flag;
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.sslConfig.enableSessionCreation;
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return this.sslConfig.getSSLParameters();
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters params) {
        this.sslConfig.setSSLParameters(params);
    }

    @Override
    public Socket accept() throws IOException {
        SSLSocketImpl s = new SSLSocketImpl(this.sslContext, this.sslConfig);
        this.implAccept(s);
        s.doneConnect();
        return s;
    }

    @Override
    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

