/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.SecretKey;
import org.openeuler.sun.misc.HexDumpEncoder;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.ConnectionContext;
import org.openeuler.sun.security.ssl.ECCKeyExchange;
import org.openeuler.sun.security.ssl.GMX509Authentication;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.HandshakeOutStream;
import org.openeuler.sun.security.ssl.HandshakeProducer;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.Record;
import org.openeuler.sun.security.ssl.SSLConsumer;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLHandshake;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLKeyExchange;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLTrafficKeyDerivation;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;
import org.openeuler.sun.security.ssl.Utilities;

final class ECCClientKeyExchange {
    static final SSLConsumer eccHandshakeConsumer = new ECCClientKeyExchangeConsumer();
    static final HandshakeProducer eccHandshakeProducer = new ECCClientKeyExchangeProducer();

    ECCClientKeyExchange() {
    }

    private static final class ECCClientKeyExchangeConsumer
    implements SSLConsumer {
        private ECCClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            GMX509Authentication.GMX509Possession gmx509Possession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof GMX509Authentication.GMX509Possession)) continue;
                gmx509Possession = (GMX509Authentication.GMX509Possession)possession;
                break;
            }
            if (gmx509Possession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No ECC possessions negotiated for client key exchange");
            }
            PrivateKey privateKey = gmx509Possession.popEncPrivateKey;
            if (!privateKey.getAlgorithm().equals("EC")) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not ECC private key for client key exchange");
            }
            ECCClientKeyExchangeMessage ckem = new ECCClientKeyExchangeMessage(shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECC ClientKeyExchange handshake message", ckem);
            }
            try {
                ECCKeyExchange.ECCPremasterSecret premaster = ECCKeyExchange.ECCPremasterSecret.decode(shc, privateKey, ckem.encrypted);
                shc.handshakeCredentials.add(premaster);
            }
            catch (GeneralSecurityException gse) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot decode ECC premaster secret", gse);
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class ECCClientKeyExchangeProducer
    implements HandshakeProducer {
        private ECCClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ECCClientKeyExchangeMessage ckem;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            GMX509Authentication.GMX509Credentials gmx509Credentials = null;
            for (SSLCredentials credential : chc.handshakeCredentials) {
                if (!(credential instanceof GMX509Authentication.GMX509Credentials)) continue;
                gmx509Credentials = (GMX509Authentication.GMX509Credentials)credential;
                break;
            }
            if (gmx509Credentials == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No ECC credentials negotiated for client key exchange");
            }
            PublicKey publicKey = gmx509Credentials.popEncPublicKey;
            if (!publicKey.getAlgorithm().equals("EC")) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not ECC public key for client key exchange");
            }
            try {
                ECCKeyExchange.ECCPremasterSecret premaster = ECCKeyExchange.ECCPremasterSecret.createPremasterSecret(publicKey, chc);
                chc.handshakePossessions.add(premaster);
                ckem = new ECCClientKeyExchangeMessage(chc, premaster, publicKey);
            }
            catch (GeneralSecurityException gse) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot generate ECC premaster secret", gse);
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECC ClientKeyExchange handshake message", ckem);
            }
            ckem.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            SSLKeyExchange ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
            if (ke == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class ECCClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        final int protocolVersion;
        final byte[] encrypted;

        ECCClientKeyExchangeMessage(HandshakeContext context, ECCKeyExchange.ECCPremasterSecret premaster, PublicKey publicKey) throws GeneralSecurityException {
            super(context);
            this.protocolVersion = context.clientHelloVersion;
            this.encrypted = premaster.getEncoded(publicKey, context.sslContext.getSecureRandom());
        }

        ECCClientKeyExchangeMessage(HandshakeContext context, ByteBuffer m) throws IOException {
            super(context);
            if (m.remaining() < 2) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid ECC ClientKeyExchange message: insufficient data");
            }
            this.protocolVersion = context.clientHelloVersion;
            this.encrypted = Record.getBytes16(m);
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            return this.encrypted.length + 2;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putBytes16(this.encrypted);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"ECC ClientKeyExchange\": '{'\n  \"client_version\":  {0}\n  \"encncrypted\": '{'\n{1}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{ProtocolVersion.nameOf(this.protocolVersion), Utilities.indent(hexEncoder.encodeBuffer(this.encrypted), "    ")};
            return messageFormat.format(messageFields);
        }
    }
}

