/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public final class Krb5Helper {
    private static final String IMPL_CLASS = "sun.security.ssl.krb5.Krb5ProxyImpl";
    private static final Class<?> proxyClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

        @Override
        public Class<?> run() {
            try {
                return Class.forName(Krb5Helper.IMPL_CLASS, true, null);
            }
            catch (ClassNotFoundException cnf) {
                return null;
            }
        }
    });
    private static Object proxy;
    private static Method getClientSubject;
    private static Method getServerSubject;
    private static Method getServiceCreds;
    private static Method getServerPrincipalName;
    private static Method getPrincipalHostName;
    private static Method getServicePermission;
    private static Method isRelated;
    private static Exception exception;

    private Krb5Helper() {
    }

    private static void init() throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        if (proxyClass == null) {
            return;
        }
        proxy = proxyClass.newInstance();
        getClientSubject = proxyClass.getDeclaredMethod("getClientSubject", AccessControlContext.class);
        getServerSubject = proxyClass.getDeclaredMethod("getServerSubject", AccessControlContext.class);
        getServiceCreds = proxyClass.getDeclaredMethod("getServiceCreds", AccessControlContext.class);
        getServerPrincipalName = proxyClass.getDeclaredMethod("getServerPrincipalName", Object.class);
        getPrincipalHostName = proxyClass.getDeclaredMethod("getPrincipalHostName", Principal.class);
        getServicePermission = proxyClass.getDeclaredMethod("getServicePermission", String.class, String.class);
        isRelated = proxyClass.getDeclaredMethod("isRelated", Subject.class, Principal.class);
    }

    private static void ensureAvailable() {
        if (exception != null) {
            throw new AssertionError((Object)exception);
        }
        if (proxy == null) {
            throw new AssertionError((Object)"Kerberos should be available");
        }
    }

    private static Object invoke(Method method, Object ... args) {
        try {
            return method.invoke(proxy, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Subject getClientSubject(AccessControlContext acc) throws LoginException {
        Krb5Helper.ensureAvailable();
        return (Subject)Krb5Helper.invoke(getClientSubject, acc);
    }

    public static Subject getServerSubject(AccessControlContext acc) throws LoginException {
        Krb5Helper.ensureAvailable();
        return (Subject)Krb5Helper.invoke(getServerSubject, acc);
    }

    public static Object getServiceCreds(AccessControlContext acc) throws LoginException {
        Krb5Helper.ensureAvailable();
        return Krb5Helper.invoke(getServiceCreds, acc);
    }

    public static String getServerPrincipalName(Object serviceCreds) {
        Krb5Helper.ensureAvailable();
        return (String)Krb5Helper.invoke(getServerPrincipalName, serviceCreds);
    }

    public static String getPrincipalHostName(Principal principal) {
        Krb5Helper.ensureAvailable();
        return (String)Krb5Helper.invoke(getPrincipalHostName, principal);
    }

    public static Permission getServicePermission(String principalName, String action) {
        Krb5Helper.ensureAvailable();
        return (Permission)Krb5Helper.invoke(getServicePermission, principalName, action);
    }

    public static boolean isRelated(Subject subject, Principal princ) {
        Krb5Helper.ensureAvailable();
        return (Boolean)Krb5Helper.invoke(isRelated, subject, princ);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Krb5Helper.init();
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                    exception = e;
                }
                return null;
            }
        });
    }
}

