/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import org.openeuler.spec.SM2KeyExchangeParameterSpec;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.GMX509Authentication;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLKeyAgreementGenerator;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLMasterKeyDerivation;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLPossessionGenerator;
import org.openeuler.sun.security.ssl.SupportedGroupsExtension;
import sun.security.util.ECUtil;

final class SM2KeyExchange {
    static final SSLPossessionGenerator poGenerator = new SM2PossessionGenerator();
    static final SSLKeyAgreementGenerator sm2KAGenerator = new SM2KAGenerator();

    SM2KeyExchange() {
    }

    private static final class SM2KAKeyDerivation
    implements SSLKeyDerivation {
        private final HandshakeContext context;
        private final ECPrivateKey localPrivateKey;
        private final ECPublicKey localPublicKey;
        private final ECPrivateKey localTempPrivateKey;
        private final ECPublicKey localTempPublicKey;
        private final ECPublicKey peerPublicKey;
        private final ECPublicKey peerTempPublicKey;

        SM2KAKeyDerivation(HandshakeContext context, ECPrivateKey localPrivateKey, ECPublicKey localPublicKey, ECPrivateKey localTempPrivateKey, ECPublicKey localTempPublicKey, ECPublicKey peerPublicKey, ECPublicKey peerTempPublicKey) {
            this.context = context;
            this.localPrivateKey = localPrivateKey;
            this.localPublicKey = localPublicKey;
            this.localTempPrivateKey = localTempPrivateKey;
            this.localTempPublicKey = localTempPublicKey;
            this.peerPublicKey = peerPublicKey;
            this.peerTempPublicKey = peerTempPublicKey;
        }

        @Override
        public SecretKey deriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
            return this.gmtlsDeriveKey(algorithm, params);
        }

        private SecretKey gmtlsDeriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
            try {
                if (params == null) {
                    params = new SM2KeyExchangeParameterSpec(this.localPublicKey, this.localTempPrivateKey, this.localTempPublicKey, this.peerTempPublicKey, 48, this.context.sslConfig.isClientMode);
                }
                KeyAgreement ka = JsseJce.getKeyAgreement("SM2");
                ka.init(this.localPrivateKey, params, null);
                ka.doPhase(this.peerPublicKey, true);
                SecretKey preMasterSecret = ka.generateSecret("TlsPremasterSecret");
                SSLMasterKeyDerivation mskd = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (mskd == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation kd = mskd.createKeyDerivation(this.context, preMasterSecret);
                return kd.deriveKey("MasterSecret", params);
            }
            catch (GeneralSecurityException gse) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(gse);
            }
        }
    }

    private static final class SM2KAGenerator
    implements SSLKeyAgreementGenerator {
        private SM2KAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            SM2Possession sm2Possession = null;
            GMX509Authentication.GMX509Possession gmx509Possession = null;
            for (SSLPossession poss : context.handshakePossessions) {
                if (poss instanceof SM2Possession) {
                    sm2Possession = (SM2Possession)poss;
                } else if (poss instanceof GMX509Authentication.GMX509Possession) {
                    gmx509Possession = (GMX509Authentication.GMX509Possession)poss;
                }
                if (sm2Possession == null || gmx509Possession == null) continue;
                break;
            }
            if (sm2Possession == null || gmx509Possession == null) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient sm2 key agreement parameters negotiated");
            }
            SM2Credentials sm2Credentials = null;
            GMX509Authentication.GMX509Credentials gmx509Credentials = null;
            for (SSLCredentials cred : context.handshakeCredentials) {
                if (cred instanceof SM2Credentials) {
                    sm2Credentials = (SM2Credentials)cred;
                } else if (cred instanceof GMX509Authentication.GMX509Credentials) {
                    gmx509Credentials = (GMX509Authentication.GMX509Credentials)cred;
                }
                if (sm2Credentials == null || gmx509Credentials == null) continue;
                break;
            }
            if (sm2Credentials == null || gmx509Credentials == null) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient sm2 key agreement parameters negotiated");
            }
            return new SM2KAKeyDerivation(context, (ECPrivateKey)gmx509Possession.popEncPrivateKey, (ECPublicKey)gmx509Possession.popEncPublicKey, sm2Possession.privateKey, sm2Possession.publicKey, (ECPublicKey)gmx509Credentials.popEncPublicKey, sm2Credentials.popPublicKey);
        }
    }

    private static final class SM2PossessionGenerator
    implements SSLPossessionGenerator {
        private SM2PossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            SupportedGroupsExtension.NamedGroup preferableNamedGroup = null;
            ProtocolVersion protocolVersion = context.t12WithGMCipherSuite ? ProtocolVersion.GMTLS : context.negotiatedProtocol;
            preferableNamedGroup = context.clientRequestedNamedGroups != null && !context.clientRequestedNamedGroups.isEmpty() ? SupportedGroupsExtension.SupportedGroups.getPreferredGroup(protocolVersion, context.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE, context.clientRequestedNamedGroups) : SupportedGroupsExtension.SupportedGroups.getPreferredGroup(protocolVersion, context.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE);
            if (preferableNamedGroup != null) {
                return new SM2Possession(preferableNamedGroup, context.sslContext.getSecureRandom());
            }
            return null;
        }
    }

    static final class SM2Possession
    implements SSLPossession {
        final ECPrivateKey privateKey;
        final ECPublicKey publicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        SM2Possession(SupportedGroupsExtension.NamedGroup namedGroup, SecureRandom random) {
            try {
                KeyPairGenerator kpg = JsseJce.getKeyPairGenerator("SM2");
                ECGenParameterSpec params = (ECGenParameterSpec)namedGroup.getParameterSpec();
                kpg.initialize(params, random);
                KeyPair kp = kpg.generateKeyPair();
                this.privateKey = (ECPrivateKey)kp.getPrivate();
                this.publicKey = (ECPublicKey)kp.getPublic();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Could not generate SM2 keypair", e);
            }
            this.namedGroup = namedGroup;
        }

        SM2Possession(SM2Credentials credentials, SecureRandom random) {
            ECParameterSpec params = credentials.popPublicKey.getParams();
            try {
                KeyPairGenerator kpg = JsseJce.getKeyPairGenerator("SM2");
                kpg.initialize(params, random);
                KeyPair kp = kpg.generateKeyPair();
                this.privateKey = (ECPrivateKey)kp.getPrivate();
                this.publicKey = (ECPublicKey)kp.getPublic();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Could not generate SM2 keypair", e);
            }
            this.namedGroup = credentials.namedGroup;
        }

        @Override
        public byte[] encode() {
            return ECUtil.encodePoint(this.publicKey.getW(), this.publicKey.getParams().getCurve());
        }
    }

    static final class SM2Credentials
    implements SSLCredentials {
        final ECPublicKey popPublicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        SM2Credentials(ECPublicKey popPublicKey, SupportedGroupsExtension.NamedGroup namedGroup) {
            this.popPublicKey = popPublicKey;
            this.namedGroup = namedGroup;
        }
    }
}

