/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.postgresql.core.NativeQuery;
import org.postgresql.core.Parser;
import org.postgresql.jdbc.ClientLogicException;
import org.postgresql.jdbc.ClientLogicImpl;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;

public class ClientLogic {
    static final int ERROR_BAD_RESPONSE_NULL = 1001;
    static final int ERROR_BAD_RESPONSE_1 = 1002;
    static final int ERROR_BAD_RESPONSE_2 = 1003;
    static final int ERROR_BAD_RESPONSE_3 = 1004;
    static final String ERROR_TEXT_BAD_RESPONSE = "Bad response from backend componenet";
    static final int ERROR_CONNECTION_IS_OPEN = 1005;
    static final String ERROR_TEXT_CONNECTION_IS_OPEN = "client logic connection is already opened";
    static final int ERROR_INVALID_HANDLE = 1010;
    static final String ERROR_TEXT_INVALID_HANDLE = "Invalid handle";
    static final int ERROR_EMPTY_DATA = 1012;
    static final String ERROR_TEXT_EMPTY_DATA = "Empty data";
    static final int ERROR_PARSER_FAILURE = 1013;
    static final String ERROR_TEXT_PARSER_FAILURE = "Failed parsing the input query";
    private AtomicInteger stamentNameCounter = new AtomicInteger(0);
    private static Log LOGGER = Logger.getLogger(ClientLogic.class.getName());
    private ClientLogicImpl impl = null;

    public void close() {
        if (this.impl != null) {
            this.impl.close();
            this.impl = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void linkClientLogic(String databaseName, PgConnection jdbcConn) throws ClientLogicException {
        long[] handleArr;
        this.impl = new ClientLogicImpl();
        Object[] result = this.impl.linkClientLogic(databaseName, jdbcConn);
        CLientLogicStatus status = new CLientLogicStatus(result);
        if (!status.isOK()) {
            throw new ClientLogicException(status.getErrorCode(), status.getErrorText());
        }
        long handle = 0L;
        if (result.length > 1 && result.getClass().isArray() && (handleArr = (long[])result[1]).length > 0) {
            handle = handleArr[0];
        }
        if (handle == 0L || handle < 0L) {
            throw new ClientLogicException(1010, ERROR_TEXT_INVALID_HANDLE);
        }
        this.impl.setHandle(handle);
    }

    public String runQueryPreProcess(String originalQuery) throws ClientLogicException {
        String errorText;
        Object[] result = this.impl.runQueryPreProcess(originalQuery);
        CLientLogicStatus status = new CLientLogicStatus(result);
        if (!status.isOK() && (errorText = status.getErrorText()).length() > 1) {
            if (errorText.charAt(errorText.length() - 1) == '\n') {
                errorText = errorText.substring(0, errorText.length() - 1);
            }
            throw new ClientLogicException(status.getErrorCode(), errorText);
        }
        String resultQuery = "";
        if (result.length > 1 && result[1] != null) {
            resultQuery = (String)result[1];
        }
        if (resultQuery.length() == 0) {
            resultQuery = originalQuery;
        }
        return resultQuery;
    }

    public void runQueryPostProcess() throws ClientLogicException {
        Object[] result = this.impl.runQueryPostProcess();
        CLientLogicStatus status = new CLientLogicStatus(result);
        if (!status.isOK()) {
            throw new ClientLogicException(status.getErrorCode(), status.getErrorText());
        }
    }

    public String runClientLogic(String data2Process, int dataType) throws ClientLogicException {
        Object[] result = this.impl.runClientLogic(data2Process, dataType);
        CLientLogicStatus status = new CLientLogicStatus(result);
        if (!status.isOK()) {
            throw new ClientLogicException(status.getErrorCode(), status.getErrorText());
        }
        String resultData = "";
        if (result.length > 1 && result[1] != null) {
            resultData = (String)result[1];
        }
        if (resultData.length() == 0) {
            throw new ClientLogicException(1012, ERROR_TEXT_EMPTY_DATA);
        }
        return resultData;
    }

    public boolean isActive() {
        return this.impl != null && this.impl.getHandle() > 0L;
    }

    public static boolean isClientLogicField(int dataType) {
        return dataType == 4402 || dataType == 4403;
    }

    public String prepareQuery(String query, String statement_name) throws ClientLogicException {
        List<NativeQuery> queries;
        try {
            queries = Parser.parseJdbcSql(query, true, true, true, true, new String[0]);
        }
        catch (SQLException e) {
            throw new ClientLogicException(1013, ERROR_TEXT_PARSER_FAILURE, true);
        }
        if (queries.size() <= 0 || queries.get(0) == null) {
            throw new ClientLogicException(1013, ERROR_TEXT_PARSER_FAILURE, true);
        }
        String queryNative = queries.get((int)0).nativeSql;
        int parameter_count = queries.get((int)0).bindPositions.length;
        Object[] result = this.impl.prepareQuery(queryNative, statement_name, parameter_count);
        CLientLogicStatus status = new CLientLogicStatus(result);
        if (!status.isOK()) {
            throw new ClientLogicException(status.getErrorCode(), status.getErrorText());
        }
        String modifiedQuery = "";
        if (result.length > 1 && result[1] != null) {
            modifiedQuery = (String)result[1];
        }
        if (modifiedQuery.length() == 0) {
            throw new ClientLogicException(1012, ERROR_TEXT_EMPTY_DATA, true);
        }
        return modifiedQuery;
    }

    public List<String> replaceStatementParams(String statementName, List<String> paramValues) throws ClientLogicException {
        String[] arrParams = new String[paramValues.size()];
        for (int i = 0; i < paramValues.size(); ++i) {
            arrParams[i] = paramValues.get(i);
        }
        Object[] resultImpl = this.impl.replaceStatementParams(statementName, arrParams);
        CLientLogicStatus status = new CLientLogicStatus(resultImpl);
        if (!status.isOK()) {
            throw new ClientLogicException(status.getErrorCode(), status.getErrorText());
        }
        if (resultImpl[1] == null || !resultImpl[1].getClass().isArray()) {
            throw new ClientLogicException(1012, ERROR_TEXT_EMPTY_DATA);
        }
        Object[] resultsImplArr = (Object[])resultImpl[1];
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < resultsImplArr.length; ++i) {
            Object value = resultsImplArr[i];
            if (value != null && value.getClass().equals(String.class)) {
                result.add((String)value);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public String getStatementName() {
        int stamanetCounter = this.stamentNameCounter.incrementAndGet();
        return "statament_" + stamanetCounter;
    }

    public String clientLogicMessage(String originalMessage) {
        String newMessage = originalMessage;
        Object[] result = this.impl.replaceErrorMessage(originalMessage);
        CLientLogicStatus status = new CLientLogicStatus(result);
        if (!status.isOK()) {
            return newMessage;
        }
        if (result.length > 1 && result[1] != null && (newMessage = (String)result[1]).length() == 0) {
            newMessage = originalMessage;
        }
        return newMessage;
    }

    private static class CLientLogicStatus {
        private int errorCode = 0;
        private String errorText = "";

        public CLientLogicStatus(Object[] JNIResult) {
            if (JNIResult == null) {
                this.errorCode = 1001;
                this.errorText = ClientLogic.ERROR_TEXT_BAD_RESPONSE;
                return;
            }
            if (JNIResult.length < 1) {
                this.errorCode = 1002;
                this.errorText = ClientLogic.ERROR_TEXT_BAD_RESPONSE;
                return;
            }
            if (JNIResult[0] == null) {
                this.errorCode = 1004;
                this.errorText = ClientLogic.ERROR_TEXT_BAD_RESPONSE;
                return;
            }
            Object[] statusData = (Object[])JNIResult[0];
            if (statusData.length < 2) {
                this.errorCode = 1003;
                this.errorText = ClientLogic.ERROR_TEXT_BAD_RESPONSE;
                return;
            }
            if (statusData[0] != null) {
                int[] errorCodeArr;
                this.errorText = (String)statusData[1];
                if (statusData[0].getClass().isArray() && (errorCodeArr = (int[])statusData[0]).length > 0) {
                    this.errorCode = errorCodeArr[0];
                }
            }
            if (statusData[1] != null) {
                this.errorText = (String)statusData[1];
            }
        }

        public boolean isOK() {
            return this.errorCode == 0;
        }

        public String toString() {
            return "CLientLogicStatus [error code=" + this.errorCode + ", error text=" + this.errorText + "]";
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorText() {
            return this.errorText;
        }
    }
}

