/*
 * Decompiled with CFR 0.152.
 */
package org.openl.domain;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.openl.domain.IDomain;
import org.openl.domain.IType;

public class EnumDomain<T>
implements IDomain<T> {
    private final LinkedHashSet<T> index;
    private final Class<?> componentType;

    public EnumDomain(T[] elements) {
        this.componentType = elements == null ? Object.class : elements.getClass().getComponentType();
        this.index = new LinkedHashSet(elements == null ? Collections.emptyList() : Arrays.asList(elements));
    }

    public boolean contains(T obj) {
        return this.index.contains(obj);
    }

    @Override
    public IType getElementType() {
        return null;
    }

    public T[] getAllObjects() {
        return this.index.toArray((Object[])Array.newInstance(this.componentType, 0));
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableSet(this.index).iterator();
    }

    @Override
    public boolean selectObject(T obj) {
        return this.contains(obj);
    }

    public int size() {
        return this.index.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean f = false;
        for (Object o : this.index) {
            if (f) {
                sb.append(",");
            } else {
                f = true;
            }
            sb.append(o.toString());
        }
        return "[" + sb + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumDomain that = (EnumDomain)o;
        if (this.componentType.equals(that.componentType)) {
            return this.index.equals(that.index);
        }
        return false;
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + this.componentType.hashCode();
        return result;
    }
}

