/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.openl.util.ClassUtils;
import org.openl.util.CollectionUtils;

public final class ArrayTool {
    public static final Object[] ZERO_OBJECT = new Object[0];

    private ArrayTool() {
    }

    public static boolean contains(Object array, Object test) {
        if (array == null) {
            return false;
        }
        int size = Array.getLength(array);
        for (int i = 0; i < size; ++i) {
            Object obj = Array.get(array, i);
            if (!Objects.equals(test, obj)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] container, T[] testArray) {
        if (container == null || testArray == null) {
            return false;
        }
        ArrayIterator<T> it = new ArrayIterator<T>(testArray);
        while (it.hasNext()) {
            if (ArrayTool.contains(container, it.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Object[] array) {
        if (array != null) {
            for (Object element : array) {
                if (element == null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsAll(int[] ary1, int[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (int arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(byte[] ary1, byte[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (byte arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(short[] ary1, short[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (short arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(long[] ary1, long[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (long arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(char[] ary1, char[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (char arrayElement : ary2) {
            if (ArrayTool.contains(ary1, Character.valueOf(arrayElement))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(float[] ary1, float[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (float arrayElement : ary2) {
            if (ArrayTool.contains(ary1, Float.valueOf(arrayElement))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(String[] ary1, String[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (String arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(double[] ary1, double[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (double arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(boolean[] ary1, boolean[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (boolean arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static String[] intersection(String[] ary1, String[] ary2) {
        if (ary1 == null || ary2 == null) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>();
        for (String s : ary2) {
            if (!ArrayTool.contains(ary1, s)) continue;
            v.add(s);
        }
        return v.toArray(new String[0]);
    }

    public static Object[] toArray(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass().isArray() ? object.getClass().getComponentType() : object.getClass();
        Class<?> componentType = clazz.isPrimitive() ? ClassUtils.primitiveToWrapper(clazz) : clazz;
        int size = !object.getClass().isArray() ? 1 : Array.getLength(object);
        Object[] newArray = (Object[])Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            newArray[i] = Array.get(object, i);
        }
        return newArray;
    }

    public static int getNotNullValuesCount(Object[] values) {
        if (CollectionUtils.isEmpty(values)) {
            return 0;
        }
        int count = values.length;
        for (Object value : values) {
            if (value != null) continue;
            --count;
        }
        return count;
    }

    public static <T> T[] removeNulls(T[] array) {
        Object[] result;
        int valuableSize = ArrayTool.getNotNullValuesCount(array);
        if (array == null || valuableSize == array.length) {
            result = array;
        } else {
            result = (Object[])Array.newInstance(array.getClass().getComponentType(), valuableSize);
            int i = 0;
            for (T value : array) {
                if (value == null) continue;
                result[i] = value;
                ++i;
            }
        }
        return result;
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private int _index;
        private final int _size;
        private final T[] _array;

        private ArrayIterator(T[] array) {
            this._size = Array.getLength(array);
            this._array = array;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._size;
        }

        @Override
        public T next() {
            return this._array[this._index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Should not be called");
        }
    }
}

