/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.openl.util.IOUtils;
import org.openl.util.formatters.FileNameFormatter;

public final class ZipArchiver
implements Closeable {
    private static final int BUFFER_SIZE = 65536;
    private final ZipOutputStream zos;
    private final byte[] buffer = new byte[65536];

    public ZipArchiver(Path file) throws IOException {
        Path dir = file.getParent();
        if (dir != null) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        OutputStream os = Files.newOutputStream(file, new OpenOption[0]);
        this.zos = new ZipOutputStream(os);
    }

    public void addEntry(Path file, String path) throws IOException {
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.addFolder(path);
        } else if (Files.isRegularFile(file, new LinkOption[0])) {
            this.addFile(file, path);
        }
    }

    public void addFile(File file, String path) throws IOException {
        this.addFile(file.toPath(), path);
    }

    public void addFile(Path file, String path) throws IOException {
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            this.addFile(fis, path);
        }
    }

    public void addFile(InputStream inputStream, String path) throws IOException {
        String zipPath = FileNameFormatter.normalizePath(path);
        ZipEntry entry = new ZipEntry(zipPath);
        this.zos.putNextEntry(entry);
        IOUtils.copy(inputStream, this.zos, this.buffer);
    }

    public void addFolder(String path) throws IOException {
        String zipPath = FileNameFormatter.normalizePath(path + File.separatorChar);
        ZipEntry entry = new ZipEntry(zipPath);
        this.zos.putNextEntry(entry);
    }

    @Override
    public void close() throws IOException {
        this.zos.close();
    }

    public void finish() throws IOException {
        this.zos.finish();
    }
}

