/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.openl.util.IOUtils;
import org.openl.util.ProjectPackager;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.ZipArchiver;

public final class ZipUtils {
    private static final int BUFFER_SIZE = 65536;

    private ZipUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void extractAll(File zipFile, File outputFolder) throws IOException {
        FileInputStream zippedStream = new FileInputStream(zipFile);
        ZipUtils.extractAll(zippedStream, outputFolder);
    }

    public static void extractAll(InputStream zippedStream, File outputFolder) throws IOException {
        byte[] buffer = new byte[65536];
        try (ZipInputStream zis = new ZipInputStream(zippedStream);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!ze.isDirectory()) {
                    String fileName = ze.getName();
                    File unzipped = new File(outputFolder, fileName);
                    ZipUtils.extractOneFile(zis, unzipped, buffer);
                }
                ze = zis.getNextEntry();
            }
        }
    }

    private static void extractOneFile(ZipInputStream zis, File targetFile, byte[] buffer) throws IOException {
        new File(targetFile.getParent()).mkdirs();
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            IOUtils.copy(zis, fos, buffer);
        }
    }

    public static void archive(File sourceDirectory, File targetFile) throws IOException {
        String[] list;
        if (!sourceDirectory.exists()) {
            throw new FileNotFoundException(String.format("File '%s' is not exist.", sourceDirectory.getAbsolutePath()));
        }
        if (sourceDirectory.isDirectory() && ((list = sourceDirectory.list()) == null || list.length == 0)) {
            throw new FileNotFoundException(String.format("Directory '%s' is empty.", sourceDirectory.getAbsolutePath()));
        }
        try (ZipArchiver arch = new ZipArchiver(targetFile.toPath());){
            ProjectPackager.addOpenLProject(sourceDirectory, arch);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contains(File zipFile, Predicate<String> names) {
        try (ZipFile zip = new ZipFile(zipFile);){
            ZipEntry zipEntry;
            Enumeration<? extends ZipEntry> entries = zip.entries();
            do {
                if (!entries.hasMoreElements()) return false;
            } while (!names.test((zipEntry = entries.nextElement()).getName()));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static URI toJarURI(Path pathToZip) {
        URI rootURI = pathToZip.toUri();
        try {
            return new URI("jar:" + rootURI.getScheme(), rootURI.getPath(), null);
        }
        catch (URISyntaxException e) {
            throw RuntimeExceptionWrapper.wrap(e);
        }
    }

    public static Path toPath(URI uri) {
        if ("jar".equals(uri.getScheme())) {
            String path = uri.getRawSchemeSpecificPart();
            int sep = path.indexOf("!/");
            if (sep > -1) {
                path = path.substring(0, sep);
            }
            try {
                URI uriToZip = new URI(path);
                if (uriToZip.getSchemeSpecificPart().contains("%")) {
                    try {
                        uriToZip = new URI(uriToZip.getScheme() + ":" + uriToZip.getSchemeSpecificPart());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                return Paths.get(uriToZip);
            }
            catch (URISyntaxException e) {
                throw RuntimeExceptionWrapper.wrap(e);
            }
        }
        if ("file".equals(uri.getScheme())) {
            return Paths.get(uri);
        }
        throw new IllegalArgumentException("Invalid URI scheme.");
    }
}

