/*
 * Decompiled with CFR 0.152.
 */
package org.openl.grammar;

import java.io.Reader;
import java.util.LinkedList;
import org.openl.grammar.JavaCC30Position;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.grammar.IGrammar;
import org.openl.syntax.impl.BinaryNode;
import org.openl.syntax.impl.CompositeLiteralNode;
import org.openl.syntax.impl.EmptyNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.LiteralNode;
import org.openl.syntax.impl.NaryNode;
import org.openl.syntax.impl.UnaryNode;
import org.openl.util.text.ILocation;
import org.openl.util.text.IPosition;
import org.openl.util.text.TextInterval;

public abstract class JavaCC30Grammar
implements IGrammar {
    protected SyntaxNodeException syntaxError;
    protected IOpenSourceCodeModule module;
    private final LinkedList<ISyntaxNode> stack = new LinkedList();

    public SyntaxNodeException getError() {
        return this.syntaxError;
    }

    public void setModule(IOpenSourceCodeModule module) {
        this.module = module;
    }

    public void parseAsMethod(Reader r) {
        this.ReInit(r);
        this.parseTopNode("method.body");
    }

    public void parseAsMethodHeader(Reader r) {
        this.ReInit(r);
        this.parseTopNode("method.header");
    }

    public void parseAsModule(Reader r) {
        this.ReInit(r);
        this.parseTopNode("module");
    }

    public void parseAsType(Reader reader) {
        this.ReInit(reader);
        this.parseTopNode("type");
    }

    public void parseAsParamDeclaration(Reader reader) {
        this.ReInit(reader);
        this.parseTopNode("param.declaration");
    }

    protected IPosition pos(int line, int col) {
        return new JavaCC30Position(line, col);
    }

    public abstract void parseTopNode(String var1);

    public abstract void ReInit(Reader var1);

    public ISyntaxNode getTopNode() {
        switch (this.stack.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.pop();
            }
        }
        if (this.syntaxError != null) {
            return this.pop();
        }
        ISyntaxNode node = this.pop();
        this.syntaxError = SyntaxNodeExceptionUtils.createError((String)("More than one syntax node on stack:\nSource:\n" + node.getModule().getCode()), null, (ISyntaxNode)node);
        return node;
    }

    public void bop(String type, TextInterval pos) {
        ISyntaxNode right = this.pop();
        ISyntaxNode left = this.pop();
        this.push((ISyntaxNode)new BinaryNode(type, (ILocation)pos, left, right, this.module));
    }

    public void emptyStatement(String type, TextInterval pos) {
        this.push((ISyntaxNode)new EmptyNode(type, pos, this.module));
    }

    public void identifier(String type, TextInterval pos, String image) {
        this.push((ISyntaxNode)new IdentifierNode(type, (ILocation)pos, image, this.module));
    }

    public void literal(String type, TextInterval pos, String image) {
        this.push((ISyntaxNode)new LiteralNode(type, pos, image, this.module));
    }

    public void literal(String type, TextInterval pos, int args) {
        this.push((ISyntaxNode)new CompositeLiteralNode(type, (ILocation)pos, this.popN(args), this.module));
    }

    public void nop(String type, TextInterval pos, boolean[] args) {
        int n = args.length;
        ISyntaxNode[] nodes = new ISyntaxNode[n];
        for (int i = n - 1; i >= 0; --i) {
            nodes[i] = args[i] ? this.pop() : null;
        }
        this.push((ISyntaxNode)new NaryNode(type, (ILocation)pos, nodes, this.module));
    }

    public void nop(String type, TextInterval pos, int args) {
        this.push((ISyntaxNode)new NaryNode(type, (ILocation)pos, this.popN(args), this.module));
    }

    public void notImplemented(String type) {
        throw new IllegalStateException(String.format("'%s' is not implemented yet.", type));
    }

    public void uop(String type, TextInterval pos) {
        ISyntaxNode left = this.pop();
        this.push((ISyntaxNode)new UnaryNode(type, (ILocation)pos, left, this.module));
    }

    private void push(ISyntaxNode sn) {
        this.stack.push(sn);
    }

    private ISyntaxNode pop() {
        return this.stack.pop();
    }

    private ISyntaxNode[] popN(int n) {
        ISyntaxNode[] nodes = new ISyntaxNode[n];
        for (int i = 0; i < n; ++i) {
            nodes[n - 1 - i] = this.pop();
        }
        return nodes;
    }
}

