/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.openl.rules.util.Statistics;

public final class Avg {
    private Avg() {
    }

    public static <T extends Number> Double avg(T ... values) {
        return (Double)Statistics.process(values, new Statistics.Result<T, Double>(){

            @Override
            public void processNonNull(T value) {
                double doubleValue = ((Number)value).doubleValue();
                this.result = this.result == null ? doubleValue : (Double)this.result + doubleValue;
            }

            @Override
            public Double result() {
                return this.result == null ? null : Double.valueOf((Double)this.result / (double)this.counter);
            }
        });
    }

    public static Float avg(Float ... values) {
        return Statistics.process(values, new Statistics.Result<Float, Float>(){

            @Override
            public void processNonNull(Float value) {
                this.result = Float.valueOf(this.result == null ? value.floatValue() : ((Float)this.result).floatValue() + value.floatValue());
            }

            @Override
            public Float result() {
                return this.result == null ? null : Float.valueOf(((Float)this.result).floatValue() / (float)this.counter);
            }
        });
    }

    public static BigDecimal avg(BigDecimal ... values) {
        return Statistics.process(values, new Statistics.Result<BigDecimal, BigDecimal>(){

            @Override
            public void processNonNull(BigDecimal value) {
                this.result = this.result == null ? value : ((BigDecimal)this.result).add(value);
            }

            @Override
            public BigDecimal result() {
                return Avg.devide((BigDecimal)this.result, this.counter);
            }
        });
    }

    public static BigDecimal avg(BigInteger ... values) {
        return Statistics.process(values, new Statistics.Result<BigInteger, BigDecimal>(){

            @Override
            public void processNonNull(BigInteger value) {
                BigDecimal bigDecimal = new BigDecimal(value);
                this.result = this.result == null ? bigDecimal : ((BigDecimal)this.result).add(bigDecimal);
            }

            @Override
            public BigDecimal result() {
                return Avg.devide((BigDecimal)this.result, this.counter);
            }
        });
    }

    private static BigDecimal devide(BigDecimal a, int b) {
        return a == null ? null : a.divide(BigDecimal.valueOf(b), MathContext.DECIMAL128);
    }
}

