/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.math.BigInteger;

public final class Booleans {
    private Booleans() {
    }

    public static boolean allTrue(boolean[] values) {
        return Boolean.TRUE.equals(Booleans.and(values));
    }

    public static boolean allTrue(Boolean ... values) {
        return Boolean.TRUE.equals(Booleans.and(values));
    }

    public static boolean anyTrue(boolean[] values) {
        return Boolean.TRUE.equals(Booleans.or(values));
    }

    public static boolean anyTrue(Boolean ... values) {
        return Boolean.TRUE.equals(Booleans.or(values));
    }

    public static boolean allFalse(boolean[] values) {
        return Boolean.FALSE.equals(Booleans.or(values));
    }

    public static boolean allFalse(Boolean ... values) {
        return Boolean.FALSE.equals(Booleans.or(values));
    }

    public static boolean anyFalse(boolean[] values) {
        return Boolean.FALSE.equals(Booleans.and(values));
    }

    public static boolean anyFalse(Boolean ... values) {
        return Boolean.FALSE.equals(Booleans.and(values));
    }

    public static boolean allYes(boolean[] values) {
        return Booleans.allTrue(values);
    }

    public static boolean allYes(Boolean ... values) {
        return Booleans.allTrue(values);
    }

    public static boolean allNo(boolean[] values) {
        return Booleans.allFalse(values);
    }

    public static boolean allNo(Boolean ... values) {
        return Booleans.allFalse(values);
    }

    public static boolean anyYes(boolean[] values) {
        return Booleans.anyTrue(values);
    }

    public static boolean anyYes(Boolean ... values) {
        return Booleans.anyTrue(values);
    }

    public static boolean anyNo(boolean[] values) {
        return Booleans.anyFalse(values);
    }

    public static boolean anyNo(Boolean ... values) {
        return Booleans.anyFalse(values);
    }

    static Boolean and(boolean[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        for (boolean value : values) {
            if (value) continue;
            return false;
        }
        return true;
    }

    static Boolean and(Boolean[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        Boolean result = true;
        for (Boolean value : values) {
            if (value == null) {
                result = null;
                continue;
            }
            if (value.booleanValue()) continue;
            return false;
        }
        return result;
    }

    static Boolean or(boolean[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        for (boolean value : values) {
            if (!value) continue;
            return true;
        }
        return false;
    }

    static Boolean or(Boolean[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        Boolean result = false;
        for (Boolean value : values) {
            if (value == null) {
                result = null;
                continue;
            }
            if (!value.booleanValue()) continue;
            return true;
        }
        return result;
    }

    public static Boolean toBoolean(Character ch) {
        if (ch == null) {
            return null;
        }
        return Booleans.toBoolean(ch.charValue());
    }

    public static Boolean toBoolean(char ch) {
        if (ch == 'y' || ch == 'Y' || ch == '1') {
            return Boolean.TRUE;
        }
        if (ch == 'n' || ch == 'N' || ch == '0') {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Boolean toBoolean(BigInteger i) {
        if (i == null) {
            return null;
        }
        if (BigInteger.ZERO.compareTo(i) == 0) {
            return Boolean.FALSE;
        }
        if (BigInteger.ONE.compareTo(i) == 0) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static Boolean toBoolean(Byte b) {
        if (b == null) {
            return null;
        }
        return Booleans.toBoolean((byte)b);
    }

    public static Boolean toBoolean(byte b) {
        switch (b) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public static Boolean toBoolean(Short s) {
        if (s == null) {
            return null;
        }
        return Booleans.toBoolean((short)s);
    }

    public static Boolean toBoolean(short s) {
        switch (s) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public static Boolean toBoolean(Integer i) {
        if (i == null) {
            return null;
        }
        return Booleans.toBoolean((int)i);
    }

    public static Boolean toBoolean(int i) {
        switch (i) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public static Boolean toBoolean(Long l) {
        if (l == null) {
            return null;
        }
        return Booleans.toBoolean((long)l);
    }

    public static Boolean toBoolean(long l) {
        if (l == 0L) {
            return Boolean.FALSE;
        }
        if (l == 1L) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static Boolean toBoolean(String str) {
        if (str == null) {
            return null;
        }
        switch (str.length()) {
            case 1: {
                return Booleans.toBoolean(str.charAt(0));
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                if (!(ch0 != 'o' && ch0 != 'O' || ch1 != 'n' && ch1 != 'N')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'n' && ch0 != 'N' || ch1 != 'o' && ch1 != 'O') break;
                return Boolean.FALSE;
            }
            case 3: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                if (!(ch0 != 'y' && ch0 != 'Y' || ch1 != 'e' && ch1 != 'E' || ch2 != 's' && ch2 != 'S')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'o' && ch0 != 'O' || ch1 != 'f' && ch1 != 'F' || ch2 != 'f' && ch2 != 'F') break;
                return Boolean.FALSE;
            }
            case 4: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                if (ch0 != 't' && ch0 != 'T' || ch1 != 'r' && ch1 != 'R' || ch2 != 'u' && ch2 != 'U' || ch3 != 'e' && ch3 != 'E') break;
                return Boolean.TRUE;
            }
            case 5: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                char ch4 = str.charAt(4);
                if (ch0 != 'f' && ch0 != 'F' || ch1 != 'a' && ch1 != 'A' || ch2 != 'l' && ch2 != 'L' || ch3 != 's' && ch3 != 'S' || ch4 != 'e' && ch4 != 'E') break;
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

