/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Pattern;

public final class Numbers {
    public static final String POSITIVE_INFINITY_SIGN = "\u221e";
    public static final String NEGATIVE_INFINITY_SIGN = "-\u221e";
    private static final Pattern TRAILING_ZERO = Pattern.compile("(\\.0+$)|(?<=\\.\\d{0,20})0+$");

    private Numbers() {
    }

    public static String toString(Number number) {
        Float floatNumber;
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            Double doubleNumber = (Double)number;
            if (doubleNumber.isInfinite()) {
                return doubleNumber > 0.0 ? POSITIVE_INFINITY_SIGN : NEGATIVE_INFINITY_SIGN;
            }
        } else if (number instanceof Float && (floatNumber = (Float)number).isInfinite()) {
            return floatNumber.floatValue() > 0.0f ? POSITIVE_INFINITY_SIGN : NEGATIVE_INFINITY_SIGN;
        }
        if (number instanceof Double || number instanceof Float || number instanceof BigDecimal) {
            return TRAILING_ZERO.matcher(number.toString()).replaceAll("");
        }
        return number.toString();
    }

    public static String toString(Number number, String pattern) {
        if (number == null || pattern == null) {
            return null;
        }
        try {
            DecimalFormat decimalFormat = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.US));
            return decimalFormat.format(number);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }
}

