/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.openl.rules.util.Statistics;

public final class Product {
    private Product() {
    }

    public static <T extends Number> Double product(T ... values) {
        return (Double)Statistics.process(values, new Statistics.Result<T, Double>(){

            @Override
            public void processNonNull(T value) {
                this.result = this.result == null ? ((Number)value).doubleValue() : (Double)this.result * ((Number)value).doubleValue();
            }
        });
    }

    public static Double product(Double ... values) {
        return Statistics.process(values, new Statistics.Result<Double, Double>(){

            @Override
            public void processNonNull(Double value) {
                this.result = this.result == null ? value : (Double)this.result * value;
            }
        });
    }

    public static Long product(Long ... values) {
        return Statistics.process(values, new Statistics.Result<Long, Long>(){

            @Override
            public void processNonNull(Long value) {
                this.result = this.result == null ? value : (Long)this.result * value;
            }
        });
    }

    public static BigDecimal product(BigDecimal ... values) {
        return Statistics.process(values, new Statistics.Result<BigDecimal, BigDecimal>(){

            @Override
            public void processNonNull(BigDecimal value) {
                this.result = this.result == null ? value : ((BigDecimal)this.result).multiply(value);
            }
        });
    }

    public static BigInteger product(BigInteger ... values) {
        return Statistics.process(values, new Statistics.Result<BigInteger, BigInteger>(){

            @Override
            public void processNonNull(BigInteger value) {
                this.result = this.result == null ? value : ((BigInteger)this.result).multiply(value);
            }
        });
    }
}

