/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class Round {
    public static final RoundingMode UP = RoundingMode.UP;
    public static final RoundingMode DOWN = RoundingMode.DOWN;
    public static final RoundingMode CEILING = RoundingMode.CEILING;
    public static final RoundingMode FLOOR = RoundingMode.FLOOR;
    public static final RoundingMode HALF_UP = RoundingMode.HALF_UP;
    public static final RoundingMode HALF_DOWN = RoundingMode.HALF_DOWN;
    public static final RoundingMode HALF_EVEN = RoundingMode.HALF_EVEN;
    public static final RoundingMode UNNECESSARY = RoundingMode.UNNECESSARY;

    private Round() {
    }

    public static Integer round(Double value) {
        if (value == null) {
            return null;
        }
        return Round.round((double)value);
    }

    public static Integer round(Double value, RoundingMode roundingMode) {
        if (value == null) {
            return null;
        }
        return Round.round((double)value, roundingMode);
    }

    public static int round(double value) {
        if (value == 0.0 || Double.isNaN(value)) {
            return 0;
        }
        if (value >= 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (value <= -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (value > 0.0) {
            return (int)Math.round(value + Math.ulp(value));
        }
        return -Round.round(-value);
    }

    public static int round(double x, RoundingMode rounding) {
        if (x == 0.0 || Double.isInfinite(x) || Double.isNaN(x)) {
            return Round.round(x);
        }
        return BigDecimal.valueOf(x).setScale(0, rounding).intValue();
    }

    public static Integer round(Float value) {
        if (value == null) {
            return null;
        }
        return Round.round(value.floatValue());
    }

    public static Integer round(Float value, RoundingMode roundingMode) {
        if (value == null) {
            return null;
        }
        return Round.round(value.floatValue(), roundingMode);
    }

    public static int round(float value) {
        if ((double)value == 0.0 || Float.isNaN(value)) {
            return 0;
        }
        if (Float.POSITIVE_INFINITY == value) {
            return Integer.MAX_VALUE;
        }
        if (Float.NEGATIVE_INFINITY == value) {
            return Integer.MIN_VALUE;
        }
        if (value > 0.0f) {
            return Math.round(value);
        }
        return -Round.round(-value);
    }

    public static int round(float x, RoundingMode rounding) {
        if (x == 0.0f || Float.isInfinite(x) || Float.isNaN(x)) {
            return Round.round(x);
        }
        return BigDecimal.valueOf(x).setScale(0, rounding).intValue();
    }

    public static BigInteger round(BigDecimal value) {
        return Round.round(value, HALF_UP);
    }

    public static Double round(Double value, int scale) {
        if (value == null) {
            return null;
        }
        return Round.round((double)value, scale);
    }

    public static double round(double value, int scale) {
        if (value > 0.0) {
            value += Math.ulp(value);
        } else if (value < 0.0) {
            value -= Math.ulp(value);
        }
        return Round.round(value, scale, HALF_UP);
    }

    public static BigDecimal round(BigDecimal value, int scale) {
        return Round.round(value, scale, HALF_UP);
    }

    public static Float round(Float value, int scale) {
        if (value == null) {
            return null;
        }
        return Float.valueOf(Round.round(value.floatValue(), scale));
    }

    public static float round(float value, int scale) {
        return Round.round(value, scale, HALF_UP);
    }

    public static Double round(Double value, int scale, RoundingMode rounding) {
        if (value == null) {
            return null;
        }
        return Round.round((double)value, scale, rounding);
    }

    public static double round(double x, int scale, RoundingMode rounding) {
        if (x == 0.0 || Double.isInfinite(x) || Double.isNaN(x)) {
            return x;
        }
        try {
            return BigDecimal.valueOf(x).setScale(scale, rounding).doubleValue();
        }
        catch (NumberFormatException var5) {
            return Double.NaN;
        }
    }

    public static Float round(Float value, int scale, RoundingMode rounding) {
        if (value == null) {
            return null;
        }
        return Float.valueOf(Round.round(value.floatValue(), scale, rounding));
    }

    public static float round(float x, int scale, RoundingMode rounding) {
        if (x == 0.0f || Float.isInfinite(x) || Float.isNaN(x)) {
            return x;
        }
        try {
            String val = Float.toString(x);
            return new BigDecimal(val).setScale(scale, rounding).floatValue();
        }
        catch (NumberFormatException var4) {
            return Float.NaN;
        }
    }

    public static BigDecimal round(BigDecimal x, int scale, RoundingMode rounding) {
        if (x == null) {
            return null;
        }
        return x.setScale(scale, rounding);
    }

    public static BigInteger round(BigDecimal x, RoundingMode rounding) {
        if (x == null) {
            return null;
        }
        return x.setScale(0, rounding).toBigInteger();
    }

    public static Double round(Double x, int scale, int rounding) {
        return Round.round(x, scale, RoundingMode.valueOf(rounding));
    }

    public static Float round(Float x, int scale, int rounding) {
        return Round.round(x, scale, RoundingMode.valueOf(rounding));
    }

    public static BigDecimal round(BigDecimal x, int scale, int rounding) {
        return Round.round(x, scale, RoundingMode.valueOf(rounding));
    }

    public static Long roundStrict(Double value) {
        if (value == null) {
            return null;
        }
        if (value == 0.0 || Double.isNaN(value)) {
            return 0L;
        }
        if (Double.POSITIVE_INFINITY == value) {
            return Long.MAX_VALUE;
        }
        if (Double.NEGATIVE_INFINITY == value) {
            return Long.MIN_VALUE;
        }
        if (value > 0.0) {
            return Math.round(value);
        }
        return -Round.roundStrict(-value.doubleValue()).longValue();
    }

    public static Double roundStrict(Double value, int scale) {
        return Round.round(value, scale, HALF_UP);
    }
}

