/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.openl.rules.util.Statistics;

public final class Sum {
    private Sum() {
    }

    public static <T extends Number> Double sum(T ... values) {
        return (Double)Statistics.process(values, new Statistics.Result<T, Double>(){

            @Override
            public void processNonNull(T value) {
                this.result = this.result == null ? ((Number)value).doubleValue() : (Double)this.result + ((Number)value).doubleValue();
            }
        });
    }

    public static Double sum(Double ... values) {
        return Statistics.process(values, new Statistics.Result<Double, Double>(){

            @Override
            public void processNonNull(Double value) {
                this.result = this.result == null ? value : (Double)this.result + value;
            }
        });
    }

    public static Float sum(Float ... values) {
        return Statistics.process(values, new Statistics.Result<Float, Float>(){

            @Override
            public void processNonNull(Float value) {
                this.result = Float.valueOf(this.result == null ? value.floatValue() : ((Float)this.result).floatValue() + value.floatValue());
            }
        });
    }

    public static Long sum(Long ... values) {
        return Statistics.process(values, new Statistics.Result<Long, Long>(){

            @Override
            public void processNonNull(Long value) {
                this.result = this.result == null ? value : (Long)this.result + value;
            }
        });
    }

    public static Integer sum(Integer ... values) {
        return Statistics.process(values, new Statistics.Result<Integer, Integer>(){

            @Override
            public void processNonNull(Integer value) {
                this.result = this.result == null ? value : (Integer)this.result + value;
            }
        });
    }

    public static Integer sum(Short ... values) {
        return Statistics.process(values, new Statistics.Result<Short, Integer>(){

            @Override
            public void processNonNull(Short value) {
                this.result = this.result == null ? value : (Integer)this.result + value;
            }
        });
    }

    public static Integer sum(Byte ... values) {
        return Statistics.process(values, new Statistics.Result<Byte, Integer>(){

            @Override
            public void processNonNull(Byte value) {
                this.result = this.result == null ? value : (Integer)this.result + value;
            }
        });
    }

    public static BigDecimal sum(BigDecimal ... values) {
        return Statistics.process(values, new Statistics.Result<BigDecimal, BigDecimal>(){

            @Override
            public void processNonNull(BigDecimal value) {
                this.result = this.result == null ? value : ((BigDecimal)this.result).add(value);
            }
        });
    }

    public static BigInteger sum(BigInteger ... values) {
        return Statistics.process(values, new Statistics.Result<BigInteger, BigInteger>(){

            @Override
            public void processNonNull(BigInteger value) {
                this.result = this.result == null ? value : ((BigInteger)this.result).add(value);
            }
        });
    }
}

