/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util.dates;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

final class CalendarWrapper {
    private static final long MILLS_IN_HOUR = 3600000L;
    private static final long MILLS_IN_DAY = 86400000L;
    static final int DAYS_IN_WEEK = 7;
    static final int MONTH_IN_YEAR = 12;
    private final GregorianCalendar calendar;
    private final int year;
    private final int month;
    private final int day;

    CalendarWrapper(Date date) {
        this.calendar = new GregorianCalendar();
        this.calendar.setTime(date);
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2) + 1;
        this.day = this.calendar.get(5);
    }

    CalendarWrapper(Calendar calendar) {
        this.calendar = (GregorianCalendar)calendar;
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
    }

    private long getTimeInMillis() {
        return this.calendar.getTimeInMillis() + (long)this.calendar.get(16) + (long)this.calendar.get(15);
    }

    private GregorianCalendar getCalendar() {
        return (GregorianCalendar)this.calendar.clone();
    }

    int daysDiff(CalendarWrapper start) {
        int estDiff = (int)((this.getTimeInMillis() - start.getTimeInMillis()) / 86400000L);
        GregorianCalendar startCalendar = start.getCalendar();
        ((Calendar)startCalendar).add(5, estDiff - 2);
        int i = estDiff - 1;
        while (true) {
            ((Calendar)startCalendar).add(5, 1);
            if (startCalendar.after(this.calendar)) {
                return i - 1;
            }
            ++i;
        }
    }

    int monthsDiff(CalendarWrapper start) {
        int monthsDiff = this.month - start.month + 12 * (this.year - start.year);
        if (start.day > this.day) {
            --monthsDiff;
        }
        return monthsDiff;
    }

    int yearsDiff(CalendarWrapper start) {
        int yearsDiff = this.year - start.year;
        if (!this.isCompleteLastYear(start)) {
            --yearsDiff;
        }
        return yearsDiff;
    }

    int daysDiffExcludeYearsAndMonths(CalendarWrapper start) {
        int daysWithoutMonthDiff;
        if (start.day <= this.day) {
            daysWithoutMonthDiff = this.day - start.day;
        } else {
            GregorianCalendar calendarStartDate = start.getCalendar();
            this.setPrevMonth(calendarStartDate);
            CalendarWrapper startDate = new CalendarWrapper(calendarStartDate);
            if (this.month == startDate.month && this.day < startDate.day) {
                return 0;
            }
            daysWithoutMonthDiff = this.daysDiff(startDate);
        }
        return daysWithoutMonthDiff;
    }

    private boolean isCompleteLastYear(CalendarWrapper start) {
        return this.month > start.month || this.month == start.month && this.day >= start.day;
    }

    int daysDiffExcludeYears(CalendarWrapper start) {
        GregorianCalendar calendarStartDate = start.getCalendar();
        if (this.isCompleteLastYear(start)) {
            calendarStartDate.set(1, this.year);
        } else {
            calendarStartDate.set(1, this.year - 1);
        }
        CalendarWrapper startDate = new CalendarWrapper(calendarStartDate);
        return this.daysDiff(startDate);
    }

    int getDay() {
        return this.day;
    }

    int getActualMonthLength() {
        return this.calendar.getActualMaximum(5);
    }

    int getPrevMonthLength() {
        GregorianCalendar calendar = this.getCalendar();
        calendar.set(5, 1);
        this.setPrevMonth(calendar);
        return calendar.getActualMaximum(5);
    }

    private void setPrevMonth(Calendar calendar) {
        if (this.month == 1) {
            calendar.set(1, this.year - 1);
            calendar.set(2, 11);
        } else {
            calendar.set(1, this.year);
            calendar.set(2, this.month - 2);
        }
    }

    int getUncompleteYearLength(CalendarWrapper start) {
        if (this.isCompleteLastYear(start)) {
            return this.calendar.getActualMaximum(6);
        }
        return this.getPrevYearLength();
    }

    private int getPrevYearLength() {
        GregorianCalendar calendar = this.getCalendar();
        calendar.set(1, this.year - 1);
        return calendar.getActualMaximum(6);
    }
}

