/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util.dates;

import java.util.Calendar;
import java.util.Date;
import org.openl.rules.util.dates.DateIntervalImpl;

public abstract class DateInterval {
    DateInterval() {
    }

    public abstract Double toDays();

    public abstract Double toWeeks(Scale var1);

    public abstract Double toMonths(Scale var1);

    public abstract Double toYears(Scale var1);

    public abstract Double toDaysExcludeYearsAndMonths();

    public abstract Double toDaysExcludeYears();

    public abstract Double toMonthsExcludeYears(Scale var1);

    public static DateInterval between(Date start, Date end) {
        if (start == null || end == null) {
            return DateIntervalImpl.NULLABLE;
        }
        return new DateIntervalImpl(start, end);
    }

    public static DateInterval between(Calendar start, Calendar end) {
        if (start == null || end == null) {
            return DateIntervalImpl.NULLABLE;
        }
        return new DateIntervalImpl(start, end);
    }

    public static enum Scale {
        INT,
        FRAC;

    }

    public static enum Unit {
        YEARS("Y"),
        MONTHS("M"),
        WEEKS("W"),
        DAYS("D"),
        DAYS_EXCLUDE_MONTHS_AND_YEARS("MD"),
        MONTHS_EXCLUDE_YEARS("YM"),
        DAYS_EXCLUDE_YEARS("YD"),
        YEARS_FRACTIONAL("YF"),
        MONTHS_FRACTIONAL("MF"),
        WEEKS_FRACTIONAL("WF"),
        MONTHS_FRACTIONAL_EXCLUDE_YEARS("YMF");

        private final String unitName;

        public static Unit getUnit(String unitName) {
            for (Unit unit : Unit.values()) {
                if (!unit.unitName.equalsIgnoreCase(unitName)) continue;
                return unit;
            }
            return null;
        }

        private Unit(String unitName) {
            this.unitName = unitName;
        }
    }
}

