/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.Optional;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ConstructorNode;
import org.openl.binding.impl.ConstructorUsage;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.NodeUsageCreator;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenMethod;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;

public class ConstructorNodeCreator
implements NodeUsageCreator {
    private ConstructorNodeCreator() {
    }

    @Override
    public boolean accept(IBoundNode boundNode) {
        return boundNode instanceof ConstructorNode;
    }

    @Override
    public Optional<NodeUsage> create(IBoundNode boundNode, String sourceString, int startIndex) {
        int pstart;
        int pend;
        ConstructorNode constructorNode = (ConstructorNode)boundNode;
        TextInfo info = new TextInfo(sourceString);
        MethodBoundNode methodBoundNode = constructorNode.getConstructor();
        ISyntaxNode syntaxNode = methodBoundNode.getSyntaxNode();
        IOpenMethod method = methodBoundNode.getMethodCaller().getMethod();
        ILocation location = syntaxNode.getSourceLocation();
        for (pend = pstart = location.getStart().getAbsolutePosition(info); pend < sourceString.length() && sourceString.charAt(pend) != '('; ++pend) {
        }
        while (pend >= pstart && sourceString.charAt(pend) == ' ') {
            --pend;
        }
        return Optional.of(new ConstructorUsage(constructorNode, pstart + startIndex, pend + startIndex, method));
    }

    public static ConstructorNodeCreator getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final ConstructorNodeCreator INSTANCE = new ConstructorNodeCreator();

        private Holder() {
        }
    }
}

