/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.grid;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.openl.excel.grid.EditableGridTable;
import org.openl.excel.grid.IndentedStyle;
import org.openl.excel.grid.ParsedCell;
import org.openl.excel.parser.AlignedValue;
import org.openl.excel.parser.ExcelReader;
import org.openl.excel.parser.ExcelReaderFactory;
import org.openl.excel.parser.ExtendedValue;
import org.openl.excel.parser.MergedCell;
import org.openl.excel.parser.SheetDescriptor;
import org.openl.excel.parser.TableStyles;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookListener;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.table.AGrid;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.RegionsPool;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedGrid
extends AGrid {
    private final Logger log = LoggerFactory.getLogger(ParsedGrid.class);
    private final String workbookPath;
    private final Object[][] cells;
    private final String uri;
    private final XlsSheetSourceCodeModule sheetSource;
    private final SheetDescriptor sheetDescriptor;
    private final boolean use1904Windowing;
    private final List<IGridRegion> regions = new ArrayList<IGridRegion>();
    private final RegionsPool regionsPool = new RegionsPool();
    private XlsSheetGridModel writableGrid;
    private transient IGridTable[] tables;
    private transient TableStyles currentTableStyles;

    ParsedGrid(String workbookPath, XlsSheetSourceCodeModule sheetSource, SheetDescriptor sheet, Object[][] cells, boolean use1904Windowing) {
        this.workbookPath = workbookPath;
        this.cells = cells;
        this.sheetSource = sheetSource;
        this.uri = sheetSource.getUri();
        this.sheetDescriptor = sheet;
        this.use1904Windowing = use1904Windowing;
        this.findRegions();
        sheetSource.getWorkbookSource().addListener(new WorkbookSaveListener());
    }

    @Override
    public ICell getCell(int column, int row) {
        return new ParsedCell(row, column, this);
    }

    @Override
    public int getColumnWidth(int i) {
        return 0;
    }

    @Override
    public int getMaxColumnIndex(int row) {
        int internalRow = row - this.getFirstRowNum();
        if (this.cells.length <= internalRow) {
            return 0;
        }
        return this.getFirstColNum() + this.cells[internalRow].length - 1;
    }

    @Override
    public int getMaxRowIndex() {
        return this.getFirstRowNum() + this.cells.length - 1;
    }

    @Override
    public IGridRegion getMergedRegion(int i) {
        return this.regions.get(i);
    }

    @Override
    public int getMinColumnIndex(int row) {
        return this.getFirstColNum();
    }

    @Override
    public int getMinRowIndex() {
        return this.getFirstRowNum();
    }

    @Override
    public int getNumberOfMergedRegions() {
        return this.regions.size();
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public boolean isEmpty(int col, int row) {
        Object value = this.getCellValue(row, col);
        return value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value));
    }

    @Override
    public IGridTable[] getTables() {
        this.tables = super.getTables();
        for (int t = 0; t < this.tables.length; ++t) {
            this.tables[t] = new EditableGridTable(this.tables[t]);
        }
        return this.tables;
    }

    private void findRegions() {
        LinkedHashSet<CellRowCol> startPoints = new LinkedHashSet<CellRowCol>();
        for (int i = 0; i < this.cells.length; ++i) {
            Object[] row = this.cells[i];
            for (int j = 0; j < row.length; ++j) {
                Object col = row[j];
                if (!(col instanceof MergedCell)) continue;
                CellRowCol rowCol = this.findTopLeft(i, j);
                startPoints.add(rowCol);
            }
        }
        for (CellRowCol start : startPoints) {
            CellRowCol end = this.findBottomRight(start.row, start.col);
            GridRegion region = new GridRegion(this.getFirstRowNum() + start.row, this.getFirstColNum() + start.col, this.getFirstRowNum() + end.row, this.getFirstColNum() + end.col);
            this.regions.add(region);
            this.regionsPool.add(region);
        }
    }

    private CellRowCol findTopLeft(int internalRow, int internalCol) {
        while (this.cells[internalRow][internalCol] == MergedCell.MERGE_WITH_LEFT && internalCol != 0) {
            --internalCol;
        }
        while (this.cells[internalRow][internalCol] == MergedCell.MERGE_WITH_UP && internalRow != 0) {
            --internalRow;
        }
        return new CellRowCol(internalRow, internalCol);
    }

    private CellRowCol findBottomRight(int internalRow, int internalCol) {
        int endRow;
        int endCol = internalCol;
        for (endRow = internalRow; endRow < this.cells.length - 1 && this.cells[endRow + 1][endCol] == MergedCell.MERGE_WITH_UP; ++endRow) {
        }
        while (endCol < this.cells[endRow].length - 1 && this.cells[endRow][endCol + 1] == MergedCell.MERGE_WITH_LEFT) {
            ++endCol;
        }
        return new CellRowCol(endRow, endCol);
    }

    protected Object getCellValue(int row, int column) {
        int internalRow = row - this.getFirstRowNum();
        int internalCol = column - this.getFirstColNum();
        if (internalRow < 0 || internalCol < 0 || this.cells.length <= internalRow || this.cells[internalRow].length <= internalCol) {
            return null;
        }
        Object value = this.cells[internalRow][internalCol];
        if (value instanceof MergedCell) {
            CellRowCol topLeft = this.findTopLeft(internalRow, internalCol);
            value = this.cells[topLeft.row][topLeft.col];
        }
        if (value instanceof ExtendedValue) {
            value = ((ExtendedValue)value).getValue();
        }
        return value;
    }

    protected ICellStyle getCellStyle(int row, int column) {
        int internalRow = row - this.getFirstRowNum();
        int internalCol = column - this.getFirstColNum();
        if (internalRow < 0 || internalCol < 0 || this.cells.length <= internalRow || this.cells[internalRow].length <= internalCol) {
            return null;
        }
        Object value = this.cells[internalRow][internalCol];
        short indent = value instanceof AlignedValue ? ((AlignedValue)value).getIndent() : (short)0;
        return new IndentedStyle(indent, this, row, column);
    }

    protected TableStyles getTableStyles(int row, int column) {
        int internalRow = row - this.getFirstRowNum();
        int internalCol = column - this.getFirstColNum();
        if (internalRow >= 0 && internalCol >= 0 && this.cells.length > internalRow && this.cells[internalRow].length > internalCol) {
            CellRowCol topLeft = this.findTopLeft(internalRow, internalCol);
            row -= internalRow - topLeft.row;
            column -= internalCol - topLeft.col;
        }
        if (this.currentTableStyles == null || !IGridRegion.Tool.contains(this.currentTableStyles.getRegion(), column, row)) {
            this.currentTableStyles = this.readTableStyles(row, column);
        }
        return this.currentTableStyles;
    }

    private TableStyles readTableStyles(int row, int column) {
        if (this.workbookPath == null) {
            return null;
        }
        TableStyles styles = null;
        for (IGridTable table : this.tables) {
            IGridRegion region = table.getRegion();
            int left = region.getLeft() == 0 ? 0 : region.getLeft() - 1;
            int top = region.getTop() == 0 ? 0 : region.getTop() - 1;
            GridRegion extendedRegion = new GridRegion(top, left, region.getBottom() + 1, region.getRight() + 1);
            if (!IGridRegion.Tool.contains(extendedRegion, column, row)) continue;
            try (ExcelReader excelReader = ExcelReaderFactory.sequentialFactory().create(this.workbookPath);){
                styles = excelReader.getTableStyles(this.sheetDescriptor, extendedRegion);
            }
            catch (Exception e) {
                this.log.error("Cannot read styles for sheet '{}'", (Object)this.sheetDescriptor.getName(), (Object)e);
                styles = new EmptyTableStyles(extendedRegion);
            }
            break;
        }
        return styles;
    }

    protected IGridRegion getRegion(int row, int col) {
        return this.regionsPool.getRegionContaining(col, row);
    }

    protected Object[][] getCells() {
        return this.cells;
    }

    private int getFirstRowNum() {
        return this.sheetDescriptor.getFirstRowNum();
    }

    private int getFirstColNum() {
        return this.sheetDescriptor.getFirstColNum();
    }

    protected boolean isUse1904Windowing() {
        return this.use1904Windowing;
    }

    protected IWritableGrid getWritableGrid() {
        if (this.writableGrid == null) {
            this.sheetSource.getWorkbookSource().getWorkbookLoader().setCanUnload(false);
            this.writableGrid = new XlsSheetGridModel(this.sheetSource);
            this.sheetSource.getSheet();
        }
        return this.writableGrid;
    }

    protected void stopEditing() {
        if (this.isEditing()) {
            this.sheetSource.getWorkbookSource().getWorkbookLoader().setCanUnload(true);
            this.writableGrid = null;
        }
    }

    protected boolean isEditing() {
        return this.writableGrid != null;
    }

    private class WorkbookSaveListener
    implements XlsWorkbookListener {
        private WorkbookSaveListener() {
        }

        @Override
        public void beforeSave(XlsWorkbookSourceCodeModule workbookSourceCodeModule) {
        }

        @Override
        public void afterSave(XlsWorkbookSourceCodeModule workbookSourceCodeModule) {
            ParsedGrid.this.stopEditing();
        }
    }

    private static class EmptyTableStyles
    implements TableStyles {
        private final IGridRegion extendedRegion;

        public EmptyTableStyles(IGridRegion extendedRegion) {
            this.extendedRegion = extendedRegion;
        }

        @Override
        public IGridRegion getRegion() {
            return this.extendedRegion;
        }

        @Override
        public ICellStyle getStyle(int row, int column) {
            return null;
        }

        @Override
        public ICellFont getFont(int row, int column) {
            return null;
        }

        @Override
        public ICellComment getComment(int row, int column) {
            return null;
        }

        @Override
        public String getFormula(int row, int column) {
            return null;
        }
    }

    private static class CellRowCol {
        final int row;
        final int col;

        private CellRowCol(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellRowCol that = (CellRowCol)o;
            return this.row == that.row && this.col == that.col;
        }

        public int hashCode() {
            return Objects.hash(this.row, this.col);
        }
    }
}

