/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.data.ITableModel;
import org.openl.rules.data.Table;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.binding.DuplicatedTableException;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;

public class DataBase
implements IDataBase {
    private final Map<String, ITable> tables = new HashMap<String, ITable>();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITable getTable(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.tables.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITable registerTable(String tableName, TableSyntaxNode tsn) throws DuplicatedTableException {
        Object object = this.lock;
        synchronized (object) {
            ITable table = this.getTable(tableName);
            if (table != null) {
                String newUri;
                String uri = table.getTableSyntaxNode().getTable().getSource().getUri();
                if (!uri.equals(newUri = tsn.getTable().getSource().getUri())) {
                    throw new DuplicatedTableException(tableName, tsn);
                }
                return table;
            }
            table = this.makeNewTable(tableName, tsn);
            this.tables.put(tableName, table);
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITable registerNewTable(String tableName, TableSyntaxNode tsn) {
        Object object = this.lock;
        synchronized (object) {
            ITable table = this.makeNewTable(tableName, tsn);
            this.tables.put(tableName, table);
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ITable> getTables() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<ITable>(this.tables.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTable(ITable newTable) throws DuplicatedTableException {
        Object object = this.lock;
        synchronized (object) {
            String newUri;
            String uri;
            ITable table = this.getTable(newTable.getName());
            if (table != null && !(uri = table.getUri()).equals(newUri = newTable.getUri())) {
                throw new DuplicatedTableException(newTable.getName(), newTable.getTableSyntaxNode());
            }
            this.tables.put(newTable.getName(), newTable);
        }
    }

    protected ITable makeNewTable(String tableName, TableSyntaxNode tsn) {
        return new Table(tableName, tsn);
    }

    @Override
    public void preLoadTable(ITable table, ITableModel dataModel, ILogicalTable dataWithTitles, OpenlToolAdaptor openlAdapter) throws Exception {
        table.setModel(dataModel);
        table.setData(dataWithTitles);
        table.preLoad(openlAdapter);
    }

    @Override
    public synchronized void clearOddDataForExecutionMode() {
        Iterator<Map.Entry<String, ITable>> itr = this.tables.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, ITable> entry = itr.next();
            if (XlsNodeTypes.XLS_DATA.equals((Object)entry.getValue().getXlsNodeType())) {
                entry.getValue().clearOddDataForExecutionMode();
                continue;
            }
            itr.remove();
        }
    }
}

