/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.rules.dt.MatchType;
import org.openl.rules.lang.xls.binding.DTColumnsDefinition;
import org.openl.rules.lang.xls.binding.ExpressionIdentifier;
import org.openl.util.text.TextInfo;

class MatchedDefinition {
    final List<ExpressionIdentifier> identifiers;
    final String statement;
    final int[] usedMethodParameterIndexes;
    final MatchType matchType;
    Map<String, String> parametersToRename;
    Map<String, String> externalParametersToRename;
    final Map<String, String> methodParametersToRename;
    final DTColumnsDefinition dtColumnsDefinition;
    boolean parametersRenamingIsUsed = false;
    final boolean mayHaveCompilationErrors;

    public MatchedDefinition(DTColumnsDefinition dtColumnsDefinition, String statement, int[] usedMethodParameterIndexes, Map<String, String> methodParametersToRename, List<ExpressionIdentifier> identifiers, MatchType matchType, boolean mayHaveCompilationErrors) {
        this.dtColumnsDefinition = dtColumnsDefinition;
        this.statement = statement;
        this.usedMethodParameterIndexes = usedMethodParameterIndexes;
        this.matchType = matchType;
        this.methodParametersToRename = methodParametersToRename;
        this.identifiers = identifiers;
        this.mayHaveCompilationErrors = mayHaveCompilationErrors;
    }

    public void renameParameterName(String name, String newName) {
        if (name != null) {
            if (this.parametersToRename == null) {
                this.parametersToRename = new HashMap<String, String>();
            }
            this.parametersToRename.put(name.toLowerCase(), newName);
            this.parametersRenamingIsUsed = true;
        }
    }

    public void renameExternalParameter(String name, String newName) {
        if (name != null) {
            if (this.externalParametersToRename == null) {
                this.externalParametersToRename = new HashMap<String, String>();
            }
            this.externalParametersToRename.put(name, newName);
            this.parametersRenamingIsUsed = true;
        }
    }

    public String getParameter(String name) {
        if (this.parametersToRename == null || name == null) {
            return name;
        }
        String newName = this.parametersToRename.get(name.toLowerCase());
        return newName != null ? newName : name;
    }

    public String getExternalParameter(String name) {
        if (this.externalParametersToRename == null || name == null) {
            return name;
        }
        String newName = this.externalParametersToRename.get(name);
        return newName != null ? newName : name;
    }

    public DTColumnsDefinition getDtColumnsDefinition() {
        return this.dtColumnsDefinition;
    }

    public String getStatementWithReplacedIdentifiers() {
        return MatchedDefinition.replaceIdentifierNodeNamesInCode(this.statement, this.identifiers, Pair.of(this.methodParametersToRename, (Object)true), Pair.of(this.externalParametersToRename, (Object)false), Pair.of(this.parametersToRename, (Object)true));
    }

    public int[] getUsedMethodParameterIndexes() {
        return this.usedMethodParameterIndexes;
    }

    public MatchType getMatchType() {
        switch (this.matchType) {
            case STRICT: {
                return this.parametersRenamingIsUsed ? MatchType.STRICT_PARAMS_RENAMED : this.matchType;
            }
            case STRICT_CASTED: {
                return this.parametersRenamingIsUsed ? MatchType.STRICT_CASTED_PARAMS_RENAMED : this.matchType;
            }
            case METHOD_ARGS_RENAMED: {
                return this.parametersRenamingIsUsed ? MatchType.METHOD_ARGS_AND_PARAMS_RENAMED : this.matchType;
            }
            case METHOD_ARGS_RENAMED_CASTED: {
                return this.parametersRenamingIsUsed ? MatchType.METHOD_ARGS_AND_PARAMS_RENAMED_CASTED : this.matchType;
            }
        }
        return this.matchType;
    }

    public boolean isMayHaveCompilationErrors() {
        return this.mayHaveCompilationErrors;
    }

    @SafeVarargs
    static String replaceIdentifierNodeNamesInCode(String code, List<ExpressionIdentifier> identifiers, Pair<Map<String, String>, Boolean> ... namesMaps) {
        identifiers = new ArrayList<ExpressionIdentifier>(identifiers);
        TextInfo textInfo = new TextInfo(code);
        identifiers.sort(Comparator.comparingInt(e -> e.getLocation().getStart().getAbsolutePosition(textInfo)).reversed());
        StringBuilder sb = new StringBuilder(code);
        for (ExpressionIdentifier identifier : identifiers) {
            int start = identifier.getLocation().getStart().getAbsolutePosition(textInfo);
            int end = identifier.getLocation().getEnd().getAbsolutePosition(textInfo);
            for (Pair<Map<String, String>, Boolean> m : namesMaps) {
                if (m == null || m.getKey() == null) continue;
                Map map = (Map)m.getKey();
                String string = identifier.getIdentifier() != null ? (Boolean.TRUE.equals(m.getValue()) ? identifier.getIdentifier().toLowerCase() : identifier.getIdentifier()) : null;
                if (!map.containsKey(string)) continue;
                sb.replace(start, end + 1, (String)((Map)m.getKey()).get(identifier.getIdentifier() != null ? (Boolean.TRUE.equals(m.getValue()) ? identifier.getIdentifier().toLowerCase() : identifier.getIdentifier()) : null));
            }
        }
        return sb.toString();
    }
}

