/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.index;

import java.util.BitSet;
import java.util.Collections;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.RangeIndexDecisionTableRuleNode;
import org.openl.rules.dt.index.IRuleIndex;
import org.openl.rules.dt.index.RangeAscIndex;
import org.openl.rules.dt.index.RangeDescIndex;

public class CombinedRangeIndex
implements IRuleIndex {
    private final DecisionTableRuleNode emptyNodeStub = new DecisionTableRuleNodeBuilder().makeNode();
    private final DecisionTableRuleNode nextNode;
    private final RangeAscIndex minIndex;
    private final RangeDescIndex maxIndex;
    private final IOpenCast castToConditionType;

    public CombinedRangeIndex(RangeAscIndex minIndex, RangeDescIndex maxIndex, DecisionTableRuleNode nextNode, IOpenCast expressionToParamOpenCast) {
        this.nextNode = nextNode;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.castToConditionType = expressionToParamOpenCast;
    }

    @Override
    public DecisionTableRuleNode findNode(Object value, DecisionTableRuleNode prevResult) {
        if (this.castToConditionType != null && this.castToConditionType.isImplicit()) {
            value = this.castToConditionType.convert(value);
        }
        BitSet minIndexRules = this.minIndex.findRules(value, prevResult);
        RangeIndexDecisionTableRuleNode minIndexResult = new RangeIndexDecisionTableRuleNode(minIndexRules, null);
        BitSet maxIndexRules = this.maxIndex.findRules(value, minIndexResult);
        return new RangeIndexDecisionTableRuleNode(maxIndexRules, this.nextNode.getNextIndex());
    }

    @Override
    public DecisionTableRuleNode getEmptyOrFormulaNodes() {
        return this.emptyNodeStub;
    }

    @Override
    public Iterable<? extends DecisionTableRuleNode> nodes() {
        return Collections.singletonList(this.nextNode);
    }

    @Override
    public int[] collectRules() {
        return this.minIndex.collectRules();
    }
}

