/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openl.binding.BindingDependencies;
import org.openl.binding.ILocalVar;
import org.openl.domain.IDomain;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.dt.IBaseDecisionRow;
import org.openl.rules.dt.IDecisionTable;
import org.openl.rules.dt.validator.ConditionAnalyzer;
import org.openl.rules.dt.validator.DecisionTableParamDescription;
import org.openl.rules.dt.validator.IDecisionTableValidatedObject;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenFieldDelegator;
import org.openl.types.impl.ParameterDeclaration;

public class DecisionTableAnalyzer {
    private final IDecisionTable decisionTable;
    private final Map<IBaseDecisionRow, ConditionAnalyzer> conditionAnalyzers = new HashMap<IBaseDecisionRow, ConditionAnalyzer>();
    private final Map<String, DecisionTableParamDescription> usedParamsFromSignature = new HashMap<String, DecisionTableParamDescription>();

    public DecisionTableAnalyzer(IDecisionTable decisionTable) {
        this.decisionTable = decisionTable;
        this.init(decisionTable);
    }

    private void init(IDecisionTable decisionTable) {
        int n = decisionTable.getNumberOfConditions();
        for (int i = 0; i < n; ++i) {
            this.conditionAnalyzers.put(decisionTable.getConditionRows()[i], new ConditionAnalyzer(decisionTable.getConditionRows()[i]));
        }
    }

    public boolean containsFormula(IBaseDecisionRow row) {
        int len = row.getNumberOfRules();
        for (int ruleN = 0; ruleN < len; ++ruleN) {
            if (!row.hasFormula(ruleN)) continue;
            return true;
        }
        return false;
    }

    public Iterator<DecisionTableParamDescription> tableParams() {
        return this.usedParamsFromSignature.values().iterator();
    }

    public IDecisionTable getDecisionTable() {
        return this.decisionTable;
    }

    public IDomain<?> getParameterDomain(String parameterName, IBaseDecisionRow condition) {
        return this.conditionAnalyzers.get(condition).getParameterDomain(parameterName);
    }

    public IDomain<?> getSignatureParameterDomain(String parameterName) {
        return this.usedParamsFromSignature.get(parameterName).getDomain();
    }

    public IParameterDeclaration[] referencedSignatureParams(IBaseDecisionRow row) {
        CompositeMethod method = (CompositeMethod)row.getMethod();
        RulesBindingDependencies bindingDependecies = new RulesBindingDependencies();
        method.updateDependency((BindingDependencies)bindingDependecies);
        IMethodSignature methodSignature = this.decisionTable.getSignature();
        ArrayList<ParameterDeclaration> paramDeclarations = new ArrayList<ParameterDeclaration>();
        for (IOpenField openField : bindingDependecies.getFieldsMap().values()) {
            IOpenField anotherOpenField = DecisionTableAnalyzer.getLocalField(openField);
            if (!(anotherOpenField instanceof ILocalVar)) continue;
            for (int i = 0; i < methodSignature.getNumberOfParameters(); ++i) {
                ParameterDeclaration parameterDeclaration;
                if (!methodSignature.getParameterName(i).equals(anotherOpenField.getName()) || paramDeclarations.contains(parameterDeclaration = new ParameterDeclaration(methodSignature.getParameterTypes()[i], methodSignature.getParameterName(i)))) continue;
                paramDeclarations.add(parameterDeclaration);
            }
        }
        return paramDeclarations.toArray(IParameterDeclaration.EMPTY);
    }

    public IOpenClass transformSignatureType(IParameterDeclaration paramDeclarationFromSignature, IDecisionTableValidatedObject decisionTableToValidate) {
        DecisionTableParamDescription paramDescription = this.usedParamsFromSignature.get(paramDeclarationFromSignature.getName());
        if (paramDescription == null) {
            IOpenClass newType = decisionTableToValidate.getTransformer().transformSignatureType(paramDeclarationFromSignature);
            paramDescription = new DecisionTableParamDescription(paramDeclarationFromSignature, newType);
            this.usedParamsFromSignature.put(paramDeclarationFromSignature.getName(), paramDescription);
        }
        return paramDescription.getNewType();
    }

    public Map<String, DecisionTableParamDescription> getUsedParams() {
        return this.usedParamsFromSignature;
    }

    private static IOpenField getLocalField(IOpenField field) {
        if (field instanceof ILocalVar) {
            return field;
        }
        if (field instanceof OpenFieldDelegator) {
            OpenFieldDelegator delegator = (OpenFieldDelegator)field;
            return delegator.getDelegate();
        }
        return field;
    }
}

