/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.beans.Transient;
import java.util.Comparator;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import org.openl.rules.range.Range;
import org.openl.rules.range.RangeParser;
import org.openl.util.StringUtils;

@XmlRootElement
public class CharRange
extends Range<Character> {
    private static final int TO_CHAR_RANGE_CAST_DISTANCE = 38;
    protected final Character min;
    protected final Character max;
    protected final Range.Type type;

    public CharRange(char min, char max) {
        this.min = Character.valueOf(min);
        this.max = Character.valueOf(max);
        this.type = max == '\uffff' ? Range.Type.LEFT_CLOSED : (min == '\u0000' ? Range.Type.RIGHT_CLOSED : Range.Type.CLOSED);
        this.validate();
    }

    public CharRange(char c) {
        this.min = Character.valueOf(c);
        this.max = Character.valueOf(c);
        this.type = Range.Type.DEGENERATE;
    }

    public CharRange(String range) {
        Objects.requireNonNull(range, "CharRange value cannot be null");
        RangeParser parser = this.parse(range);
        if (parser == null) {
            this.type = Range.Type.DEGENERATE;
            this.max = this.min = CharRange.convertToChar(range.trim());
        } else {
            this.type = parser.getType();
            String left = parser.getLeft();
            String right = parser.getRight();
            this.min = Character.valueOf(left == null ? (char)'\u0000' : CharRange.convertToChar(left).charValue());
            this.max = Character.valueOf(right == null ? (char)'\uffff' : CharRange.convertToChar(right).charValue());
            this.validate();
        }
    }

    @Override
    public boolean contains(Character value) {
        return super.contains(value);
    }

    @Override
    @Transient
    public Range.Type getType() {
        return this.type;
    }

    @Override
    protected Character getLeft() {
        return this.min;
    }

    @Override
    protected Character getRight() {
        return this.max;
    }

    public Character getMin() {
        return this.min;
    }

    public Character getMax() {
        return this.max;
    }

    @Override
    protected int compare(Character left, Character right) {
        return Comparator.nullsLast(Comparator.naturalOrder()).compare(left, right);
    }

    @Override
    protected void format(StringBuilder sb, Character ch) {
        boolean printable = !StringUtils.isSpaceOrControl((char)ch.charValue()) && (ch.charValue() < '\u00ff' || Character.isUnicodeIdentifierPart(ch.charValue()));
        sb.append(printable ? String.valueOf(ch) : String.format("\\u%04x", ch.charValue()));
    }

    public static CharRange autocast(char x, CharRange y) {
        return new CharRange(x);
    }

    public static int distance(char x, CharRange y) {
        return 38;
    }

    private static Character convertToChar(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() != 1) {
            throw new IllegalArgumentException("Only one character can be defined");
        }
        return Character.valueOf(text.charAt(0));
    }
}

