/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.beans.Transient;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlRootElement;
import org.openl.rules.helpers.ARangeParser;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.range.Range;
import org.openl.rules.range.RangeParser;

@XmlRootElement
public class DoubleRange
extends Range<Double>
implements INumberRange {
    private static final int TO_DOUBLE_RANGE_CAST_DISTANCE = 38;
    private double lowerBound;
    private double upperBound;
    private final Range.Type type;

    public DoubleRange(double range) {
        this.lowerBound = range;
        this.upperBound = range;
        this.type = Range.Type.DEGENERATE;
    }

    public DoubleRange(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.type = Double.isInfinite(upperBound) ? Range.Type.LEFT_CLOSED : (Double.isInfinite(lowerBound) ? Range.Type.RIGHT_CLOSED : Range.Type.CLOSED);
        this.validate();
    }

    public DoubleRange(double lowerBound, double upperBound, ARangeParser.ParseStruct.BoundType lowerBoundType, ARangeParser.ParseStruct.BoundType upperBoundType) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.type = Double.isInfinite(upperBound) ? (lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.LEFT_OPEN : Range.Type.LEFT_CLOSED) : (Double.isInfinite(lowerBound) ? (upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.RIGHT_OPEN : Range.Type.RIGHT_CLOSED) : (upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? (lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.OPEN : Range.Type.CLOSED_OPEN) : (lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING ? Range.Type.OPEN_CLOSED : Range.Type.CLOSED)));
        this.validate();
    }

    public DoubleRange() {
        this.lowerBound = 0.0;
        this.upperBound = 0.0;
        this.type = Range.Type.DEGENERATE;
    }

    public DoubleRange(String range) {
        Range.Type type;
        try {
            RangeParser parser = this.parse(range);
            if (parser == null) {
                type = Range.Type.DEGENERATE;
                this.upperBound = this.lowerBound = DoubleRange.convertToDouble(range.trim());
            } else {
                type = parser.getType();
                String left = parser.getLeft();
                String right = parser.getRight();
                this.lowerBound = left == null ? Double.NEGATIVE_INFINITY : DoubleRange.convertToDouble(left);
                this.upperBound = right == null ? Double.POSITIVE_INFINITY : DoubleRange.convertToDouble(right);
            }
        }
        catch (RuntimeException ex) {
            try {
                if (!range.contains("less") && !range.contains("more")) {
                    throw ex;
                }
                range = range.replaceAll("less\\s+than", "<").replaceAll("more\\s+than", ">").replaceAll("(\\S+)\\s+or\\s+less", "<=$1").replaceAll("(\\S+)\\s+and\\s+more", ">=$1");
                RangeParser parser = this.parse(range);
                type = parser.getType();
                String left = parser.getLeft();
                String right = parser.getRight();
                this.lowerBound = left == null ? Double.NEGATIVE_INFINITY : DoubleRange.convertToDouble(left);
                this.upperBound = right == null ? Double.POSITIVE_INFINITY : DoubleRange.convertToDouble(right);
            }
            catch (Exception ignore) {
                throw ex;
            }
        }
        this.type = type;
        this.validate();
    }

    protected static boolean isTruncated(Number from, double to) {
        return from instanceof BigDecimal && Double.isInfinite(to);
    }

    @Deprecated
    public int compareLowerBound(DoubleRange range) {
        if (this.lowerBound < range.lowerBound) {
            return -1;
        }
        if (this.lowerBound == range.lowerBound) {
            if (this.type.left != Range.Bound.OPEN && range.type.left == Range.Bound.OPEN) {
                return -1;
            }
            if (this.type.left == range.type.left) {
                return 0;
            }
        }
        return 1;
    }

    @Deprecated
    public int compareUpperBound(DoubleRange range) {
        if (this.upperBound < range.upperBound) {
            return -1;
        }
        if (this.upperBound == range.upperBound) {
            if (this.type.right != Range.Bound.OPEN && range.type.right == Range.Bound.OPEN) {
                return -1;
            }
            if (this.type.right == range.type.right) {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public boolean contains(Number n) {
        if (n instanceof Float) {
            return this.contains(Double.parseDouble(n.toString()));
        }
        return n != null && this.contains(n.doubleValue());
    }

    @Override
    @Transient
    public Range.Type getType() {
        return this.type;
    }

    @Override
    protected Double getLeft() {
        return this.lowerBound;
    }

    @Override
    protected Double getRight() {
        return this.upperBound;
    }

    @Override
    protected int compare(Double left, Double right) {
        return Double.compare(left, right);
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    @Deprecated
    public DoubleRange intersect(DoubleRange range) {
        int lowerBoundComaring = this.compareLowerBound(range);
        int upperBoundComaring = this.compareUpperBound(range);
        double lowerBound = lowerBoundComaring > 0 ? this.lowerBound : range.lowerBound;
        ARangeParser.ParseStruct.BoundType lowerBoundType = lowerBoundComaring > 0 ? this.getLowerBoundType() : range.getLowerBoundType();
        double upperBound = upperBoundComaring < 0 ? this.upperBound : range.upperBound;
        ARangeParser.ParseStruct.BoundType upperBoundType = upperBoundComaring < 0 ? this.getUpperBoundType() : range.getUpperBoundType();
        return lowerBound > upperBound ? null : new DoubleRange(lowerBound, upperBound, lowerBoundType, upperBoundType);
    }

    @Deprecated
    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    @Deprecated
    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    @Deprecated
    public ARangeParser.ParseStruct.BoundType getLowerBoundType() {
        return this.type.left == Range.Bound.OPEN ? ARangeParser.ParseStruct.BoundType.EXCLUDING : ARangeParser.ParseStruct.BoundType.INCLUDING;
    }

    @Deprecated
    public void setLowerBoundType(ARangeParser.ParseStruct.BoundType lowerBoundType) {
    }

    @Deprecated
    public ARangeParser.ParseStruct.BoundType getUpperBoundType() {
        return this.type.right == Range.Bound.OPEN ? ARangeParser.ParseStruct.BoundType.EXCLUDING : ARangeParser.ParseStruct.BoundType.INCLUDING;
    }

    @Deprecated
    public void setUpperBoundType(ARangeParser.ParseStruct.BoundType upperBoundType) {
    }

    public static DoubleRange autocast(byte x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(byte x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(short x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(short x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(int x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(int x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(long x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(long x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(float x, DoubleRange y) {
        return new DoubleRange(new BigDecimal(String.valueOf(x)).doubleValue());
    }

    public static int distance(float x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(double x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(double x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange cast(BigInteger x, DoubleRange y) {
        return new DoubleRange(x.doubleValue());
    }

    public static int distance(BigInteger x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange cast(BigDecimal x, DoubleRange y) {
        return new DoubleRange(x.doubleValue());
    }

    public static int distance(BigDecimal x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(IntRange x, DoubleRange y) {
        return new DoubleRange(x.getMin(), x.getMax());
    }

    private static double convertToDouble(String text) {
        double multiplier = 1.0;
        int start = 0;
        if (text.startsWith("$")) {
            ++start;
        }
        if (text.charAt(start) == ',') {
            throw new NumberFormatException("For input string: \"" + text + "\"");
        }
        int end = text.length();
        switch (text.charAt(end - 1)) {
            case 'B': {
                multiplier *= 1000.0;
            }
            case 'M': {
                multiplier *= 1000.0;
            }
            case 'K': {
                multiplier *= 1000.0;
                --end;
            }
        }
        if (!Character.isDigit(text.charAt(end - 1)) || text.indexOf(101) >= 0 || text.indexOf(69) >= 0) {
            throw new NumberFormatException("For input string: \"" + text + "\"");
        }
        text = text.substring(start, end).replace(",", "");
        double value = Double.parseDouble(text);
        return value * multiplier;
    }
}

