/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types;

import java.lang.reflect.Constructor;
import java.util.Objects;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IParameterDeclaration;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.vm.IRuntimeEnv;

public class DatatypeOpenConstructor
extends JavaOpenConstructor {
    private static final IParameterDeclaration[] EMPTY = IParameterDeclaration.EMPTY;
    private final JavaOpenConstructor delegator;
    private final IOpenClass declaringClass;
    private final IParameterDeclaration[] parameters;

    public DatatypeOpenConstructor(JavaOpenConstructor delegator, IOpenClass declaringClass) {
        this(delegator, declaringClass, EMPTY);
    }

    public DatatypeOpenConstructor(JavaOpenConstructor delegator, IOpenClass declaringClass, IParameterDeclaration[] parameters) {
        super(delegator.getJavaConstructor());
        this.delegator = delegator;
        this.declaringClass = declaringClass;
        this.parameters = Objects.requireNonNull(parameters);
    }

    public IOpenClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String getDisplayName(int mode) {
        return this.delegator.getDisplayName(mode);
    }

    public IMemberMetaInfo getInfo() {
        return this.delegator.getInfo();
    }

    public IOpenMethod getMethod() {
        return this;
    }

    public String getName() {
        return this.delegator.getName();
    }

    public int getNumberOfParameters() {
        return this.parameters.length;
    }

    public String getParameterName(int i) {
        return this.parameters[i].getName();
    }

    public IOpenClass getParameterType(int i) {
        return this.parameters[i].getType();
    }

    public IOpenClass[] getParameterTypes() {
        if (this.parameters.length == 0) {
            return IOpenClass.EMPTY;
        }
        IOpenClass[] parameterTypes = new IOpenClass[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            parameterTypes[i] = this.parameters[i].getType();
        }
        return parameterTypes;
    }

    public IMethodSignature getSignature() {
        return this;
    }

    public IOpenClass getType() {
        return this.declaringClass;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        return this.delegator.invoke(target, params, env);
    }

    public boolean isStatic() {
        return this.delegator.isStatic();
    }

    public boolean isConstructor() {
        return this.delegator.isConstructor();
    }

    public String toString() {
        return this.getDeclaringClass().getName();
    }

    public Constructor<?> getJavaConstructor() {
        return this.delegator.getJavaConstructor();
    }
}

