/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;
import org.openl.rules.table.ui.ICellStyle;

public class SetBorderStyleAction
extends AUndoableCellAction {
    private final int col;
    private final int row;
    private boolean clearCell = true;
    private final ICellStyle newCellStyle;

    public SetBorderStyleAction(int col, int row, ICellStyle newCellStyle, MetaInfoWriter metaInfoWriter) {
        super(col, row, metaInfoWriter);
        this.col = col;
        this.row = row;
        this.newCellStyle = newCellStyle;
    }

    public SetBorderStyleAction(int col, int row, ICellStyle newCellStyle, boolean clearCell, MetaInfoWriter metaInfoWriter) {
        super(col, row, metaInfoWriter);
        this.col = col;
        this.row = row;
        this.newCellStyle = newCellStyle;
        this.clearCell = clearCell;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        this.savePrevCell(grid);
        if (this.clearCell) {
            grid.clearCell(this.getCol(), this.getRow());
        }
        grid.setCellBorderStyle(this.col, this.row, this.newCellStyle);
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        this.restorePrevCell(grid);
    }
}

