/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import java.util.ArrayList;
import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.AGridTableDecorator;
import org.openl.rules.table.GridTableUtils;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.UndoableCompositeAction;
import org.openl.rules.table.actions.UndoableMoveTableAction;

public abstract class UndoableEditTableAction
implements IUndoableGridTableAction {
    public static final boolean COLUMNS = true;
    public static final boolean ROWS = false;
    public static final boolean INSERT = true;
    public static final boolean REMOVE = false;

    public static IGridTable getOriginalTable(IGridTable table) {
        return GridTableUtils.getOriginalTable(table);
    }

    public static boolean isDecoratorTable(IGridTable table) {
        return table instanceof AGridTableDecorator;
    }

    public static IGridRegion getOriginalRegion(IGridTable table) {
        return UndoableEditTableAction.getOriginalTable(table).getRegion();
    }

    public static synchronized IUndoableGridTableAction moveTable(IGridTable table, MetaInfoWriter metaInfoWriter) {
        UndoableMoveTableAction moveTableAction = new UndoableMoveTableAction(metaInfoWriter);
        moveTableAction.doAction(table);
        IUndoableGridTableAction changeRegions = UndoableEditTableAction.setRegion(moveTableAction.getNewRegion(), table);
        changeRegions.doAction(table);
        return new UndoableCompositeAction(moveTableAction, changeRegions);
    }

    private static IUndoableGridTableAction setRegion(IGridRegion newRegion, IGridTable table) {
        IGridRegion fullTableRegion = UndoableEditTableAction.getOriginalRegion(table);
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>();
        int topOffset = newRegion.getTop() - fullTableRegion.getTop();
        int leftOffset = newRegion.getLeft() - fullTableRegion.getLeft();
        if (topOffset != 0) {
            actions.add(new GridRegionAction(fullTableRegion, false, true, GridRegionAction.ActionType.MOVE, topOffset));
            if (UndoableEditTableAction.isDecoratorTable(table)) {
                actions.add(new GridRegionAction(table.getRegion(), false, true, GridRegionAction.ActionType.MOVE, topOffset));
            }
        }
        if (leftOffset != 0) {
            actions.add(new GridRegionAction(fullTableRegion, true, true, GridRegionAction.ActionType.MOVE, leftOffset));
            if (UndoableEditTableAction.isDecoratorTable(table)) {
                actions.add(new GridRegionAction(table.getRegion(), true, true, GridRegionAction.ActionType.MOVE, leftOffset));
            }
        }
        return new UndoableCompositeAction(actions);
    }
}

